/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.logging.Level;

public class LogLevelMapping {
    private static final String DEBUG = "DEBUG";
    private static ImmutableMap<Integer, Level> levelMap;

    static {
        Level[] supportedLevels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        ImmutableMap.Builder<Integer, Level> builder = ImmutableMap.builder();
        Level[] levelArray = supportedLevels;
        int n = supportedLevels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            builder.put(level.intValue(), level);
            ++n2;
        }
        levelMap = builder.build();
    }

    public static Level normalize(Level level) {
        if (levelMap.containsKey(level.intValue())) {
            return levelMap.get(level.intValue());
        }
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Level.SEVERE;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Level.INFO;
        }
        return Level.FINE;
    }

    public static String getName(Level level) {
        Level normalized = LogLevelMapping.normalize(level);
        return normalized == Level.FINE ? DEBUG : normalized.getName();
    }

    public static Level toLevel(String logLevelName) {
        if (Strings.isNullOrEmpty(logLevelName)) {
            return Level.INFO;
        }
        if (logLevelName.equals(DEBUG)) {
            return Level.FINE;
        }
        return levelMap.get(Level.parse(logLevelName).intValue());
    }
}

