/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.ClientGoneException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RequestHandler
implements Comparable<RequestHandler> {
    private final Registry registry;
    private final SeleniumBasedRequest request;
    private final HttpServletResponse response;
    private volatile TestSession session = null;
    private final CountDownLatch sessionAssigned = new CountDownLatch(1);
    private static final Logger log = Logger.getLogger(RequestHandler.class.getName());
    private final Thread waitingThread;

    public RequestHandler(SeleniumBasedRequest request, HttpServletResponse response, Registry registry) {
        this.request = request;
        this.response = response;
        this.registry = registry;
        this.waitingThread = Thread.currentThread();
    }

    public void forwardNewSessionRequestAndUpdateRegistry(TestSession session) throws NewSessionException {
        try {
            String content = this.request.getNewSessionRequestedCapability(session);
            this.getRequest().setBody(content);
            session.forward(this.getRequest(), this.getResponse(), true);
        }
        catch (IOException e) {
            throw new NewSessionException("Error forwarding the request " + e.getMessage(), e);
        }
    }

    protected void forwardRequest(TestSession session, RequestHandler handler) throws IOException {
        session.forward(this.request, this.response, false);
    }

    public void process() {
        switch (this.request.getRequestType()) {
            case START_SESSION: {
                log.info("Got a request to create a new session: " + new DesiredCapabilities(this.request.getDesiredCapabilities()));
                try {
                    this.registry.addNewSessionRequest(this);
                    this.waitForSessionBound();
                    this.beforeSessionEvent();
                    this.forwardNewSessionRequestAndUpdateRegistry(this.session);
                    break;
                }
                catch (Exception e) {
                    this.cleanup();
                    throw new GridException("Error forwarding the new session " + e.getMessage(), e);
                }
            }
            case STOP_SESSION: 
            case REGULAR: {
                this.session = this.getSession();
                if (this.session == null) {
                    ExternalSessionKey sessionKey = null;
                    try {
                        sessionKey = this.request.extractSession();
                    }
                    catch (RuntimeException runtimeException) {}
                    throw new GridException("Session [" + sessionKey + "] not available - " + this.registry.getActiveSessions());
                }
                try {
                    this.forwardRequest(this.session, this);
                }
                catch (ClientGoneException clientGoneException) {
                    log.log(Level.WARNING, "The client is gone for session " + this.session + ", terminating");
                    this.registry.terminate(this.session, SessionTerminationReason.CLIENT_GONE);
                }
                catch (SocketTimeoutException e) {
                    log.log(Level.SEVERE, "Socket timed out for session " + this.session + ", " + e.getMessage());
                    this.registry.terminate(this.session, SessionTerminationReason.SO_TIMEOUT);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "cannot forward the request " + t.getMessage(), t);
                    this.registry.terminate(this.session, SessionTerminationReason.FORWARDING_TO_NODE_FAILED);
                    throw new GridException("cannot forward the request " + t.getMessage(), t);
                }
                if (this.request.getRequestType() != RequestType.STOP_SESSION) break;
                this.registry.terminate(this.session, SessionTerminationReason.CLIENT_STOPPED_SESSION);
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }

    private void cleanup() {
        this.registry.removeNewSessionRequest(this);
        if (this.session != null) {
            this.registry.terminate(this.session, SessionTerminationReason.CREATIONFAILED);
        }
    }

    private void beforeSessionEvent() throws NewSessionException {
        RemoteProxy p = this.session.getSlot().getProxy();
        if (p instanceof TestSessionListener) {
            try {
                ((TestSessionListener)((Object)p)).beforeSession(this.session);
            }
            catch (Exception e) {
                log.severe("Error running the beforeSessionListener : " + e.getMessage());
                e.printStackTrace();
                throw new NewSessionException("The listener threw an exception ( listener bug )", e);
            }
        }
    }

    public void waitForSessionBound() throws InterruptedException, TimeoutException {
        if (this.registry.getNewSessionWaitTimeout() != -1) {
            if (!this.sessionAssigned.await(this.registry.getNewSessionWaitTimeout(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Request timed out waiting for a node to become available.");
            }
        } else {
            this.sessionAssigned.await();
        }
    }

    public SeleniumBasedRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public int compareTo(RequestHandler o) {
        Prioritizer prioritizer = this.registry.getPrioritizer();
        if (prioritizer != null) {
            return prioritizer.compareTo(this.getRequest().getDesiredCapabilities(), o.getRequest().getDesiredCapabilities());
        }
        return 0;
    }

    protected void setSession(TestSession session) {
        this.session = session;
    }

    public void bindSession(TestSession session) {
        this.session = session;
        this.sessionAssigned.countDown();
    }

    public TestSession getSession() {
        if (this.session == null) {
            ExternalSessionKey externalKey = this.request.extractSession();
            this.session = this.registry.getExistingSession(externalKey);
        }
        return this.session;
    }

    public ExternalSessionKey getServerSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getExternalKey();
    }

    public void stop() {
        this.waitingThread.interrupt();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("session :").append(this.session).append(" , ");
        b.append("\n");
        return b.toString();
    }

    public String debug() {
        StringBuilder b = new StringBuilder();
        b.append("\nmethod: ").append(this.request.getMethod());
        b.append("\npathInfo: ").append(this.request.getPathInfo());
        b.append("\nuri: ").append(this.request.getRequestURI());
        b.append("\ncontent :").append(this.request.getBody());
        return b.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHandler other = (RequestHandler)obj;
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

