/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public abstract class HtmlInput
extends HtmlElement
implements DisabledElement,
SubmittableElement,
FormFieldWithNameHistory {
    public static final String TAG_NAME = "input";
    private String defaultValue_;
    private String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private boolean createdByJavascript_;
    private Object valueAtFocus_;

    public HtmlInput(SgmlPage page, Map<String, DomAttr> attributes) {
        this(TAG_NAME, page, attributes);
    }

    public HtmlInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.defaultValue_ = this.getValueAttribute();
        this.originalName_ = this.getNameAttribute();
    }

    public Page setValueAttribute(String newValue) {
        WebAssert.notNull("newValue", newValue);
        this.setAttribute("value", newValue);
        Page page = HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        this.valueAtFocus_ = this.getInternalValue();
        return page;
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getValueAttribute() {
        return this.getAttribute("value");
    }

    public final String getCheckedAttribute() {
        return this.getAttribute("checked");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttribute("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttribute("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttribute("maxLength");
    }

    protected int getMaxLength() {
        String maxLength = this.getMaxLengthAttribute();
        if (maxLength.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(maxLength.trim());
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttribute("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttribute("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    @Override
    public void reset() {
        this.setValueAttribute(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.hasFeature(BrowserVersionFeatures.HTMLINPUT_SET_DEFAULT_VALUE_UPDATES_VALUE);
        this.setDefaultValue(defaultValue, modifyValue);
    }

    protected void setDefaultValue(String defaultValue, boolean modifyValue) {
        this.defaultValue_ = defaultValue;
        if (modifyValue) {
            this.setValueAttribute(defaultValue);
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isChecked() {
        return this.hasAttribute("checked");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        return this.click();
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_DOES_NOT_CLICK_SURROUNDING_ANCHOR);
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        SgmlPage page = htmlElement.getPage();
        JavaScriptEngine engine = htmlElement.getPage().getWebClient().getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (page.getWebClient().containsWebWindow(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return scriptResult.getNewPage();
        }
        return page;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    @Override
    public final void focus() {
        super.focus();
        this.valueAtFocus_ = this.getInternalValue();
    }

    @Override
    final void removeFocus() {
        super.removeFocus();
        if (!this.valueAtFocus_.equals(this.getInternalValue())) {
            this.handleFocusLostValueChanged();
        }
        this.valueAtFocus_ = null;
    }

    void handleFocusLostValueChanged() {
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    Object getInternalValue() {
        return this.getValueAttribute();
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_INPUT_DISPLAY_INLINE_BLOCK)) {
            return HtmlElement.DisplayStyle.INLINE_BLOCK;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.hasAttribute("required");
    }

    @JsxSetter
    public void setRequired(boolean required) {
        if (required) {
            this.setAttribute("required", "required");
        } else {
            this.removeAttribute("required");
        }
    }

    public String getSize() {
        return this.getAttribute("size");
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    public void setMaxLength(int maxLength) {
        this.setAttribute("maxLength", String.valueOf(maxLength));
    }

    public void setMinLength(int minLength) {
        this.setAttribute("minLength", String.valueOf(minLength));
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public String getAutocomplete() {
        return this.getAttribute("autocomplete");
    }

    public void setAutocomplete(String autocomplete) {
        this.setAttribute("autocomplete", autocomplete);
    }
}

