/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.wrapper;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.webbitserver.HttpRequest;
import org.webbitserver.WebSocketConnection;

public class WebSocketConnectionWrapper
implements WebSocketConnection {
    private WebSocketConnection connection;

    public WebSocketConnectionWrapper(WebSocketConnection connection) {
        this.connection = connection;
    }

    public WebSocketConnection underlyingControl() {
        return this.connection;
    }

    public WebSocketConnectionWrapper underlyingControl(WebSocketConnection control) {
        this.connection = control;
        return this;
    }

    public WebSocketConnection originalControl() {
        if (this.connection instanceof WebSocketConnectionWrapper) {
            WebSocketConnectionWrapper wrapper = (WebSocketConnectionWrapper)this.connection;
            return wrapper.originalControl();
        }
        return this.connection;
    }

    @Override
    public HttpRequest httpRequest() {
        return this.connection.httpRequest();
    }

    @Override
    public WebSocketConnectionWrapper send(String message) {
        this.connection.send(message);
        return this;
    }

    @Override
    public WebSocketConnectionWrapper send(byte[] message) {
        this.connection.send(message);
        return this;
    }

    @Override
    public WebSocketConnectionWrapper ping(byte[] msg) {
        this.connection.ping(msg);
        return this;
    }

    @Override
    public WebSocketConnectionWrapper send(byte[] message, int offset, int length) {
        this.connection.send(message, offset, length);
        return this;
    }

    @Override
    public WebSocketConnectionWrapper pong(byte[] msg) {
        this.connection.pong(msg);
        return this;
    }

    @Override
    public WebSocketConnectionWrapper close() {
        this.connection.close();
        return this;
    }

    @Override
    public Map<String, Object> data() {
        return this.connection.data();
    }

    @Override
    public Object data(String key) {
        return this.connection.data(key);
    }

    @Override
    public WebSocketConnectionWrapper data(String key, Object value) {
        this.connection.data(key, value);
        return this;
    }

    @Override
    public Set<String> dataKeys() {
        return this.connection.dataKeys();
    }

    @Override
    public Executor handlerExecutor() {
        return this.connection.handlerExecutor();
    }

    @Override
    public String version() {
        return this.connection.version();
    }

    @Override
    public void execute(Runnable command) {
        this.connection.execute(command);
    }
}

