/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.xdrpc;

import com.google.common.io.CharStreams;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpc;

public class CrossDomainRpcLoader {
    public CrossDomainRpc loadRpc(HttpServletRequest request) throws IOException {
        JSONObject json;
        try {
            json = new JSONObject(CharStreams.toString(request.getReader()));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse JSON request: " + e.getMessage(), e);
        }
        return new CrossDomainRpc(this.getField(json, "method"), this.getField(json, "path"), this.getField(json, "data"));
    }

    private String getField(JSONObject json, String key) {
        if (!json.has(key) || json.isNull(key)) {
            throw new IllegalArgumentException("Missing required parameter: " + key);
        }
        try {
            return json.get(key).toString();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not a string", e);
        }
    }

    private static class Field {
        public static final String METHOD = "method";
        public static final String PATH = "path";
        public static final String DATA = "data";

        private Field() {
        }
    }
}

