/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class Flick
extends WebElementHandler
implements JsonParametersAware {
    private static final String ELEMENT = "element";
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    private static final String SPEED = "speed";
    private static final String XSPEED = "xspeed";
    private static final String YSPEED = "yspeed";
    private String elementId;
    private int xOffset;
    private int yOffset;
    private int speed;
    private int xSpeed;
    private int ySpeed;

    public Flick(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        TouchScreen touchScreen = ((HasTouchScreen)((Object)this.getDriver())).getTouch();
        if (this.elementId != null) {
            WebElement element = this.getKnownElements().get(this.elementId);
            Coordinates elementLocation = ((Locatable)((Object)element)).getCoordinates();
            touchScreen.flick(elementLocation, this.xOffset, this.yOffset, this.speed);
        } else {
            touchScreen.flick(this.xSpeed, this.ySpeed);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[Flick]", new Object[0]);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters.containsKey(ELEMENT) && allParameters.get(ELEMENT) != null) {
            this.elementId = (String)allParameters.get(ELEMENT);
            this.xOffset = ((Long)allParameters.get(XOFFSET)).intValue();
            this.yOffset = ((Long)allParameters.get(YOFFSET)).intValue();
            this.speed = ((Long)allParameters.get(SPEED)).intValue();
        } else if (allParameters.containsKey(XSPEED) && allParameters.containsKey(YSPEED)) {
            this.xSpeed = ((Long)allParameters.get(XSPEED)).intValue();
            this.ySpeed = ((Long)allParameters.get(YSPEED)).intValue();
        }
    }
}

