/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.logging.SessionLogs;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;
import org.openqa.selenium.server.log.LoggingManager;

public class GetSessionLogsHandler
implements RestishHandler {
    private final Response response = new Response();

    public Response getResponse() {
        return this.response;
    }

    @Override
    public ResultType handle() throws Exception {
        ImmutableMap.Builder<String, SessionLogs> builder = ImmutableMap.builder();
        for (SessionId sessionId : LoggingManager.perSessionLogHandler().getLoggedSessions()) {
            builder.put(sessionId.toString(), LoggingManager.perSessionLogHandler().getAllLogsForSession(sessionId));
        }
        this.response.setValue(builder.build());
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[fetching session logs]", new Object[0]);
    }
}

