/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class FindChildElements
extends WebElementHandler
implements JsonParametersAware {
    private volatile By by;

    public FindChildElements(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.by = this.newBySelector().pickFromJsonParameters(allParameters);
    }

    @Override
    public ResultType call() throws Exception {
        List<WebElement> elements = this.getElement().findElements(this.by);
        LinkedHashSet<Map<String, String>> elementIds = Sets.newLinkedHashSet(Iterables.transform(elements, new Function<WebElement, Map<String, String>>(){

            @Override
            public Map<String, String> apply(WebElement element) {
                return ImmutableMap.of("ELEMENT", FindChildElements.this.getKnownElements().add(element));
            }
        }));
        this.response.setValue(elementIds);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[find child elements: %s, %s]", this.getElementAsString(), this.by);
    }
}

