/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class JsonToWebElementConverter
implements Function<Object, Object> {
    private final RemoteWebDriver driver;

    public JsonToWebElementConverter(RemoteWebDriver driver) {
        this.driver = driver;
    }

    @Override
    public Object apply(Object result) {
        if (result instanceof Collection) {
            Collection results = (Collection)result;
            return Lists.newArrayList(Iterables.transform(results, this));
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            if (resultAsMap.containsKey("ELEMENT")) {
                RemoteWebElement element = this.newRemoteWebElement();
                element.setId(String.valueOf(resultAsMap.get("ELEMENT")));
                element.setFileDetector(this.driver.getFileDetector());
                return element;
            }
            return Maps.transformValues(resultAsMap, this);
        }
        if (result instanceof Number) {
            if (result instanceof Float || result instanceof Double) {
                return ((Number)result).doubleValue();
            }
            return ((Number)result).longValue();
        }
        return result;
    }

    protected RemoteWebElement newRemoteWebElement() {
        RemoteWebElement toReturn = new RemoteWebElement();
        toReturn.setParent(this.driver);
        return toReturn;
    }
}

