/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import java.util.logging.Logger;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.Firefox2Locator;
import org.openqa.selenium.browserlaunchers.locators.Firefox3Locator;
import org.openqa.selenium.browserlaunchers.locators.FirefoxPathLocator;

public class CombinedFirefoxLocator
implements BrowserLocator {
    private static Logger LOGGER = Logger.getLogger(CombinedFirefoxLocator.class.getName());

    @Override
    public BrowserInstallation findBrowserLocationOrFail() {
        LOGGER.fine("Discovering Firefox 2...");
        BrowserInstallation firefox2Location = new Firefox2Locator().findBrowserLocation();
        if (firefox2Location != null) {
            return firefox2Location;
        }
        LOGGER.fine("Did not find Firefox 2, now discovering Firefox 3...");
        BrowserInstallation firefox3Location = new Firefox3Locator().findBrowserLocation();
        if (firefox3Location != null) {
            return firefox3Location;
        }
        LOGGER.fine("Did not find Firefox 3, now searching PATH...");
        BrowserInstallation firefoxPathLocation = new FirefoxPathLocator().findBrowserLocation();
        if (firefoxPathLocation != null) {
            return firefoxPathLocation;
        }
        throw new RuntimeException(this.couldNotFindFirefoxMessage());
    }

    @Override
    public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
        return new Firefox3Locator().retrieveValidInstallationPath(customLauncherPath);
    }

    private String couldNotFindFirefoxMessage() {
        return new Firefox3Locator().couldNotFindAnyInstallationMessage();
    }
}

