/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.net.URI;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;

@JsxClass(browsers={@WebBrowser(value=BrowserName.FF)})
public class WebSocket
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private int readyState_ = 3;
    private HtmlPage containingPage_;
    private WebSocket.Connection incomingConnection_;
    private WebSocket.Connection outgoingConnection_;

    public WebSocket() {
    }

    private WebSocket(String url, Object protocols, Window window) {
        WebSocketClientFactory factory = new WebSocketClientFactory();
        try {
            factory.start();
            WebSocketClient client = factory.newWebSocketClient();
            this.incomingConnection_ = client.open(new URI(url), new WebSocketImpl()).get();
            this.containingPage_ = (HtmlPage)window.getWebWindow().getEnclosedPage();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError("WebSocket Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError("WebSocket Error: 'url' parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError("WebSocket Error: 'url' parameter must be a String.");
        }
        return new WebSocket((String)args[0], null, WebSocket.getWindow(ctorObj));
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
        this.fireOnOpen();
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        if (this.incomingConnection_ != null) {
            this.incomingConnection_.close();
        }
        if (this.outgoingConnection_ != null) {
            this.outgoingConnection_.close();
        }
    }

    @JsxFunction
    public void send(Object content) {
        try {
            if (!(content instanceof String)) {
                throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
            }
            this.outgoingConnection_.sendMessage(content.toString());
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private void fireOnOpen() {
        Scriptable scope = this.openHandler_.getParentScope();
        JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
        jsEngine.callFunction(this.containingPage_, this.openHandler_, scope, this, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    private class WebSocketImpl
    implements WebSocket.OnBinaryMessage,
    WebSocket.OnTextMessage {
        private WebSocketImpl() {
        }

        @Override
        public void onOpen(WebSocket.Connection connection) {
            WebSocket.this.outgoingConnection_ = connection;
        }

        @Override
        public void onClose(int closeCode, String message) {
            Scriptable scope = WebSocket.this.closeHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction(WebSocket.this.containingPage_, WebSocket.this.closeHandler_, scope, WebSocket.this, new Object[]{closeCode, message});
        }

        @Override
        public void onMessage(String data) {
            Scriptable scope = WebSocket.this.messageHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            MessageEvent event = new MessageEvent(data);
            event.setParentScope(WebSocket.this.getParentScope());
            event.setPrototype(WebSocket.this.getPrototype(event.getClass()));
            jsEngine.callFunction(WebSocket.this.containingPage_, WebSocket.this.messageHandler_, scope, WebSocket.this, new Object[]{event});
        }

        @Override
        public void onMessage(byte[] data, int offset, int length) {
            Scriptable scope = WebSocket.this.messageHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction(WebSocket.this.containingPage_, WebSocket.this.messageHandler_, scope, WebSocket.this, new Object[]{data, offset, length});
        }
    }
}

