package Tk::TabbedForm::CFontItem;

=head1 NAME

Tk::TabbedForm::CFontItem - Font select entry widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CTextItem);
Construct Tk::Widget 'CFontItem';
require Tk::FontDialog;


=head1 SYNOPSIS

 require Tk::TabbedForm::CBooleanItem;
 my $bool = $window->CBooleanItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CTextItem>. Provides a font entry with dialog for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

=over 4

=item Switch: B<-image>

Image to be used for the dialog button.

=back

=cut

sub Populate {
	my ($self,$args) = @_;
	$self->SUPER::Populate($args);
	$self->ConfigSpecs(
		-image => [$self->Subwidget('Select')],
		-background => ['SELF', 'DESCENDANTS'],
		DEFAULT => ['SELF'],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	$self->SUPER::createHandler($var);
	my @bopt = ();
	my $but = $self->Button(@bopt,
		-command => sub {
			my $dialog = $self->FontDialog(
				-title => "Select font",
				-initfont => $$var,
			);
			my $font = $dialog->Show(-popover => $self->toplevel);
			if (defined $font) {
				$$var =  $dialog->GetDescriptiveFontName($font)
			}
			$dialog->destroy;
		}
	)->pack(-side => 'left', -padx => 2);
	$self->Advertise(Select => $but);
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=item L<Tk::TabbedForm::CTextItem>

=back

=cut



1;

__END__
