#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More 0.82;

eval 'use Map::Tube::London';
plan skip_all => 'Map::Tube::London required for this test' if $@;

plan tests => 18;

my $tube = Map::Tube::London->new();
my $ret;

$ret = [ $tube->fuzzy_find( 'Bakerloo',   objects => 'lines' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding Bakerloo exactly (up to case)');

$ret = [ $tube->fuzzy_find( 'BAKERLOO',   objects => 'lines' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding Bakerloo exactly (all caps)');

$ret = [ $tube->fuzzy_find( 'Waterloo',   objects => 'lines' ) ];
is_deeply($ret, [ ], 'Finding Waterloo exactly should fail');

$ret = [ $tube->fuzzy_find( 'Bakerloo',   objects => 'lines', method => 'start' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding Bakerloo at start');

$ret = [ $tube->fuzzy_find( 'Waterloo',   objects => 'lines', method => 'start' ) ];
is_deeply($ret, [ 'Waterloo & City' ], 'Finding Waterloo at start');

$ret = [ $tube->fuzzy_find( 'kerloo',     objects => 'lines', method => 'start' ) ];
is_deeply($ret, [ ], 'Finding kerloo at start should fail');

$ret = [ $tube->fuzzy_find( 'C',          objects => 'lines', method => 'start' ) ];
is_deeply($ret, [ 'Central', 'Circle' ], 'Finding C at start');

$ret = [ $tube->fuzzy_find( 'Bakerloo',   objects => 'lines', method => 'in' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding Bakerloo somewhere');

$ret = [ $tube->fuzzy_find( 'Waterloo',   objects => 'lines', method => 'in' ) ];
is_deeply($ret, [ 'Waterloo & City' ], 'Finding Waterloo somewhere');

$ret = [ $tube->fuzzy_find( 'kerloo',     objects => 'lines', method => 'in' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding kerloo somewhere');

$ret = [ $tube->fuzzy_find( 'xerloo',     objects => 'lines', method => 'in' ) ];
is_deeply($ret, [ ], 'Finding xerloo somewhere should fail');

$ret = [ $tube->fuzzy_find( '[kx]erloo',  objects => 'lines', method => 're' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding regex [kx]erloo');

$ret = [ $tube->fuzzy_find( '[tx]erloo',  objects => 'lines', method => 're' ) ];
is_deeply($ret, [ 'Waterloo & City' ], 'Finding regex [tx]erloo');

$ret = [ $tube->fuzzy_find( '[ktx]erloo', objects => 'lines', method => 're' ) ];
is_deeply($ret, [ 'Bakerloo',  'Waterloo & City'  ], 'Finding regex [ktx]erloo');

$ret = [ $tube->fuzzy_find( 'Bakerloo',   objects => 'lines', method => 'levenshtein' ) ];
is_deeply($ret, [ 'Bakerloo' ], 'Finding Bakerloo fuzzy');

$ret = [ $tube->fuzzy_find( 'Packalu',    objects => 'lines', method => 'levenshtein', maxdist => 6 ) ];
is_deeply($ret, [ 'Bakerloo', 'Central', 'Circle', 'DLR', 'Piccadilly' ], 'Finding Packalu fuzzy with distance 6');

$ret = [ $tube->fuzzy_find( 'Packalu',    objects => 'lines', method => 'levenshtein', maxdist => 5 ) ];
is_deeply($ret, [ ], 'Finding Packalu fuzzy with distance 5 should fail');

$ret = [ $tube->fuzzy_find( 'Packalu',    objects => 'lines', method => 'levenshtein' ) ];
is_deeply($ret, [ ], 'Finding Packalu fuzzy with standard distance should fail');

