BEGIN {
  use Config;
  if (! $Config{'useithreads'}) {
      print("1..0 # Skipped: Perl not compiled with 'useithreads'\n");
      exit(0);
  }
  if (! -f 'tk_is_ok' ) {
      print("1..0 # Skipped: Tk can't work : graphical environment is out ?\n");
      exit(0);
  }
}

use strict;

use Text::Editor::Easy;

Text::Editor::Easy->new (
    {
        'sub'      => 'main',    # Sub for action
        'x_offset' => 60,
        'y_offset' => 170,
        'width'    => 500,
        'height'   => 300,
    }
);

print "Fin du programme", threads->tid, "\n";
exit;
print "Fin du programme ...\n";

sub main {
		my ( $editor ) = @_;
		
		use Test::More qw( no_plan );
		
		# Full trace thread creation
		print "Full trace thread creation by trace_print call\n";
		my @first_list = threads->list;
		print "Scalar first ", scalar (@first_list), "\n";
		
		my $tid = $editor->create_new_server(
		   {
				'use' => 'Text::Editor::Easy::Test::Test3', 
				'package' => 'Text::Editor::Easy::Test::Test3',
				'methods' => ['test3', 'test4', 'object_test'], 
				'object' => [23, "rere"] ,
		    });

		print "Aprs create_new_server : ", scalar (threads->list), "\n";
		
		my @second_list = threads->list;		
		is ( scalar(@second_list), scalar(@first_list) + 1, "One more thread");

		my @param = ( 3, 'BOF' );
		my ( $first, $second ) = $editor->object_test( @param );
		is ( $first, 12 * 23 - 2 * 3, "First return value, first instance call" );
		is ( $second, "rereBOFBOF", "Second return value, first instance call" );

		@param = ( 7, 'zefvfc' );
		( $first, $second ) = $editor->object_test( @param );
		is ( $first, 12 * 23 - 2 * 7, "First return value, first instance call" );
		is ( $second, "rereBOFzefvfc", "Second return value, first instance call" );
		
		my $editor2 = Text::Editor::Easy->new();
		
		my @first = threads->list;
		my $first_thread_number = scalar (@first);
		print "Avant appel add_thread_method : $first_thread_number\n";
        

		$editor2->ask_thread(
		    'add_thread_object', $tid, 
			{
				'object' => [4, "titi"] ,
		    }
		);
		my @second = threads->list;
		my $second_thread_number = scalar (@second);
		print "Aprs appel add_thread_object : $second_thread_number\n";
		
		is (  $first_thread_number, $second_thread_number, "No thread more");

		@param = ( 7, 'zefvfc' );
		( $first, $second ) = $editor2->object_test( @param );
		is ( $first, 12 * 4 - 2 * 7, "First return value, second instance call" );
		is ( $second, "titiBOFzefvfc", "Second return value, second instance call" );

		@param = ( 5, 'ee' );
		( $first, $second ) = $editor->object_test( @param );
		is ( $first, 12 * 23 - 2 * 5, "First return value, first instance call" );
		is ( $second, "rereBOFee", "Second return value, first instance call" );

		( $first, $second ) = $editor2->object_test( @param );
		is ( $first, 12 * 4 - 2 * 5, "First return value, second instance call" );
		is ( $second, "titiBOFee", "Second return value, second instance call" );
	
		# Tests de cration de thread nomms (mthodes mises en commun sans augmentation du nombre d'entre de %get_tid_from_instance_method

		# Vrifier le bon partage du mme objet
		# Donner la possibilit d'avoir un objet personnel ?
		# Si oui tester le bon partage par dfaut, la diffrence si souhaite
        # Ajout avec une autre mthode de classe dfinie pour l'occassion
		# Vrifier l'appel de classe correct
		# Vrifier l'hritage automatique
		# Vrifier l'appel de classe incorrect (appel Text::Editor::Easy avec mthode uniquement dfinie dans la classe hrite)
		# Vrifier l'implmentation de "->super"
		# Vrifier le non crasement de mthode ? (add et non overload ?)
	Text::Editor::Easy->exit(0);
}		