package App::Manoc::DB::Result::DeviceIfStatus;
#ABSTRACT: A model object for information on device ports status

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('device_ifstatus');

__PACKAGE__->add_columns(
    'interface_id' => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    },
    'description' => {
        data_type     => 'varchar',
        size          => 128,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'up' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'up_admin' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'duplex' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'duplex_admin' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'speed' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'stp_state' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'cps_enable' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'cps_status' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'cps_count' => {
        data_type     => 'varchar',
        size          => 16,
        is_nullable   => 1,
        default_value => 'NULL'
    },
    'vlan' => {
        data_type     => 'int',
        is_nullable   => 1,
        default_value => 'NULL'
    },
);

__PACKAGE__->belongs_to(
    interface => 'App::Manoc::DB::Result::DeviceIface',
    'interface_id'
);

__PACKAGE__->set_primary_key('interface_id');


sub device { shift->interface->device }

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::DeviceIfStatus - A model object for information on device ports status

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 device

Shortcut to for $row->interface->device

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
