package App::Manoc::DB::InflateColumn::IPv4;
#ABSTRACT: Inflator for IP v4 addresses


use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'DBIx::Class';

use App::Manoc::IPAddress::IPv4;


sub register_column {
    my $self = shift;
    my ( $column, $info, $args ) = @_;
    $self->next::method(@_);

    return unless $info->{'ipv4_address'};

    $self->inflate_column(
        $column => {
            inflate => \&_inflate_ipv4_column,
            deflate => \&_deflate_ipv4_column,
        }
    );
}

sub _inflate_ipv4_column {
    my ( $value, $obj ) = @_;
    return App::Manoc::IPAddress::IPv4->new($value) if defined($value);
}

sub _deflate_ipv4_column {
    my ( $value, $obj ) = @_;
    return $value->padded if defined($value);
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::InflateColumn::IPv4 - Inflator for IP v4 addresses

=head1 VERSION

version 2.99.2

=head1 SYNOPSIS

  package App::Manoc::DB::Result::Table;
  use parent 'DBIx::Class';

  __PACKAGE__->load_components('+App::Manoc::DB::InflateColumn::IPv4);

  __PACKAGE__->add_columns(
    'data_column' => {
      'data_type'    => 'VARCHAR',
      'size'         => 255,
      'ipv4_address' => 1
    }
  );

=head1 SYNOPSIS

  __PACKAGE__->add_column(
    mng_address => {
        data_type    => 'varchar',
        is_nullable  => 0,
        size         => 15,
        ipv4_address => 1,
    }
   );

=for Pod::Coverage register_column

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
