# for developers: "make more_test" does all the extra tests
use strict;
use warnings;
BEGIN{ $INC{'Module/Install/ExtraTests.pm'} = 1 } # M::I::ExtraTests considered harmful!
use inc::Module::Install;
use Module::Install::XSUtil 0.24;
use Module::Install::AuthorTests;

all_from 'lib/Text/Xslate.pm';

requires 'Any::Moose' => '0.13';

# XXX we don't handle Moose stuff here
requires 'Mouse'                => '0.61';
requires 'MouseX::Getopt'       => '0.2601';
requires 'parent'               => '0.221';
requires 'Scalar::Util'         => '1.23';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
#test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive;
author_tests 'xt';

my $want_xs = want_xs();
if($want_xs) {
    use_ppport 3.19;
    cc_warnings;

    cc_src_paths qw(xs);
}

auto_set_repository() if -d '.git';

system "$^X tool/opcode.pl xs/xslate_opcode.inc >xslate_ops.h";
system "$^X tool/opcode_for_pp.pl xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm";

postamble <<'M';
xs/Text-Xslate.xs :: xs/xslate_opcode.inc

# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/Text-Xslate.xs tool/opcode.pl
	$(PERLRUNINST) tool/opcode.pl xs/xslate_opcode.inc >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: xs/Text-Xslate.xs tool/opcode_for_pp.pl
	$(PERLRUNINST) tool/opcode_for_pp.pl xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm
M

sub more_test;

if(eval q{ use Moose 1.05 }) {
    more_test test_moose => (
        ANY_MOOSE => 'Moose',
    );
}

if($want_xs) {
    more_test test_pp => (
        XSLATE         => 'pp',
        MOUSE_PUREPERL => 1,
    );

    more_test test_pp_opcode => (
        XSLATE => 'pp=opcode',
    );

    more_test test_pp_booster => (
        XSLATE => 'pp=booster',
    );

    postamble qq{test_dynamic :: test_pp\n\n};
}

sub more_test {
    my($name, %env) = @_;
    my $e = '';
    while(my($name, $value) = each %env) {
        s/"/\\"/g for $name, $value;
        $e .= sprintf '\\$$ENV{q{%s}}=q{%s};', $name, $value;
    }

    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    my $t =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
            .q{ "%s test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
            .q{ $(TEST_FILES)};

    postamble qq{$name :: pure_all\n}
            . qq{\t} . q{$(NOECHO) $(ECHO) TESTING: } . $name . qq{\n}
            . qq{\t} . sprintf($t, $e) . qq{\n\n}

            . qq{more_test :: $name\n\n};
    return;
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
);

WriteAll(check_nmake => 0);

