#!perl -w
use strict;
use Test::More;

use Text::Xslate;

my $tx = Text::Xslate->new();

my @data = (
    ['<:= $value10 + 11 :>', 21],
    ['<:= $value10 - 11 :>', -1],

    ['<:= 12 + $value10 :>', 22],
    ['<:= 12 - $value10 :>',  2],

    ['<:= $value10 + $value20 :>', 30],
    ['<:= $value0  + $value20 :>', 20],

    ['<:= 1 + 3 + 5 :>',  9],
    ['<:= 1 + 3 - 5 :>', -1],
    ['<:= 1 - 3 + 5 :>',  3],

    ['<:=(1 - 3) + 5 :>',  3],
    ['<:= 1 - (3 + 5):>', -7],

    ['<:= 9 - (3 + (5 - 7)):>',  8],
    ['<:= (3 + (5 - 7)) + 9:>', 10],

    ['<:= 3 * 2 :>', 6],
    ['<:= 3 / 2 :>', 1.5],
    ['<:= 3 % 2 :>', 1],

    ['<:= 1 + 3 * 2 :>', 7],
    ['<:= 1 + 3 / 2 :>', 2.5],
    ['<:= 1 + 3 % 2 :>', 2],
    ['<:= 9 + 3 * 2 :>', 15],
    ['<:= 9 + 3 / 2 :>', 10.5],
    ['<:= 9 + 3 % 2 :>', 10],

    ['<:= 1 + 3 * 2 + 42 :>', 7   + 42],
    ['<:= 1 + 3 / 2 + 42 :>', 2.5 + 42],
    ['<:= 1 + 3 % 2 + 42 :>', 2   + 42],
    ['<:= 9 + 3 * 2 + 42 :>', 15  + 42],
    ['<:= 9 + 3 / 2 + 42 :>', 10.5+ 42],
    ['<:= 9 + 3 % 2 + 42 :>', 10  + 42],

    # from Perl6
    ['<:= "foo" ~ "bar" :>',         "foobar" ],
    ['<:= "foo" ~ "bar" ~ "baz" :>', "foobarbaz" ],

    ['<: 10 min 20 :>', 10 ],
    ['<: 20 min 10 :>', 10 ],
    ['<: 10 max 20 :>', 20 ],
    ['<: 20 max 10 :>', 20 ],

    ['<: 10 min 20 min 30 :>', 10 ],
    ['<: 30 min 20 min 10 :>', 10 ],
    ['<: 10 max 20 max 30 :>', 30 ],
    ['<: 30 max 20 max 10 :>', 30 ],
);

foreach my $pair(@data) {
    my($in, $out) = @$pair;

    my %vars = (
        value0  =>  0,
        value10 => 10,
        value20 => 20,
    );
    is $tx->render_string($in, \%vars), $out or diag $in;
}

done_testing;
