#
# (c) Jan Gehring <jan.gehring@gmail.com>
#
# vim: set ts=2 sw=2 tw=0:
# vim: set expandtab:

package Rex::Interface::Shell::Tcsh;

use strict;
use warnings;
use Rex::Interface::Shell::Csh;

our $VERSION = '1.3.1_2'; # TRIAL VERSION

use base qw(Rex::Interface::Shell::Csh);

sub new {
  my $class = shift;
  my $proto = ref($class) || $class;
  my $self  = $proto->SUPER::new(@_);

  bless( $self, $class );

  return $self;
}

sub detect {
  my ( $self, $con ) = @_;

  my ($shell_path) = $con->_exec("echo \$SHELL");
  if ( $shell_path =~ m/\/tcsh$/ ) {
    return 1;
  }

  return 0;
}

1;
