#!/usr/bin/perl -w

use strict;
use warnings;
use Module::Build;

my $build = Module::Build->new(
    dist_name            => 'Bio-Community',
    module_name          => 'Bio::Community', # look here for version number
    dist_author          => 'BioPerl Team <bioperl-l@bioperl.org>',
    dist_abstract        => 'Modules to represent and manipulate communities of biological organisms',
    license              => 'perl',
    recursive_test_files => 1,
    create_license       => 1,
    meta_merge           => {
                             'resources' => {
                                             'repository' => 'git://github.com/bioperl/Bio-Community.git',
                                             'homepage'   => 'http://www.bioperl.org',
                                             'bugtracker' => 'https://redmine.open-bio.org/projects/bioperl/',
                                            },
                            },
    build_requires       => {
                             'Test::Number::Delta'          =>  0,
                            },
    requires             => {
                             'perl'                         => '5.10.0',
                             #'Bio::Root::IO'               => '1.7', # unreleased. Bio::Root::IO bundled here
                             'Bio::Root::Version'           => '1.006910',
                             'DateTime'                     =>  0,
                             'Getopt::Euclid'               => '0.4.3',
                             'JSON::XS'                     =>  0, # biom format
                             'Hash::Util'                   =>  0,
                             'Math::Random::MT'             =>  0, # sampler
                             'Method::Signatures'           =>  0,
                             'Moose'                        =>  0,
                             'MooseX::NonMoose'             =>  0, # 0.24 works well with Moose 2.1005 but not with 2.1103-TRIAL
                             'MooseX::StrictConstructor'    =>  0,
                             'Parallel::Iterator'           =>  0, # community member iteration
                             'PerlIO::eol'                  =>  0, # portable line ending in Bio::Root::IO
                             'Scalar::Util'                 =>  0,
                             'Tie::IxHash'                  =>  0, # metacommunity
                            },
    recommends           => {
                             #'Clone::Fast'                  =>  0, # C bindings for Bio::Root::clone(). Broken in 0.97?!
                             'Math::BigInt::GMP'            =>  0, # C bindings for arithmetic
                            },
    script_files         => [
                             'scripts/bc_clean_shrapnel',
                             'scripts/bc_convert_files',
                             'scripts/bc_correct_misassignments',
                             'scripts/bc_get_info',
                             'scripts/bc_manage_samples',
                             'scripts/bc_measure_distance',
                             'scripts/bc_rarefy',
                             'scripts/bc_relative_to_absolute',
                             'scripts/bc_remove_unexpected_members',
                             'scripts/bc_summarize',
                             'scripts/bc_use_repr_id',
                            ],
    recursive_test_files => 1,
    dynamic_config       => 1,
);

$build->create_build_script;

exit;
