use Test::More tests => 141;
use strict;
use MARC::Charset;

BEGIN {
    use_ok('MARC::Charset::CyrillicBasic');
    use_ok('MARC::Charset::CyrillicExtended');
}

my $cs = MARC::Charset->new();
$cs->g0( MARC::Charset::CyrillicBasic->new() );
$cs->g1( MARC::Charset::CyrillicExtended->new() );

## make sure we were able to set the G0 and G1 charsets

isa_ok( $cs->g0(), 'MARC::Charset::CyrillicBasic' );
isa_ok( $cs->g1(), 'MARC::Charset::CyrillicExtended' );

## see if we can use valid Cyrillic characters

my %valid = (

chr(0x21)=>chr(0x0021),
chr(0x22)=>chr(0x0022),
chr(0x23)=>chr(0x0023),
chr(0x24)=>chr(0x0024),
chr(0x25)=>chr(0x0025),
chr(0x26)=>chr(0x0026),
chr(0x27)=>chr(0x0027),
chr(0x28)=>chr(0x0028),
chr(0x29)=>chr(0x0029),
chr(0x2A)=>chr(0x002A),
chr(0x2B)=>chr(0x002B),
chr(0x2C)=>chr(0x002C),
chr(0x2D)=>chr(0x002D),
chr(0x2E)=>chr(0x002E),
chr(0x2F)=>chr(0x002F),
chr(0x30)=>chr(0x0030),
chr(0x31)=>chr(0x0031),
chr(0x32)=>chr(0x0032),
chr(0x33)=>chr(0x0033),
chr(0x34)=>chr(0x0034),
chr(0x35)=>chr(0x0035),
chr(0x36)=>chr(0x0036),
chr(0x37)=>chr(0x0037),
chr(0x38)=>chr(0x0038),
chr(0x39)=>chr(0x0039),
chr(0x3A)=>chr(0x003A),
chr(0x3B)=>chr(0x003B),
chr(0x3C)=>chr(0x003C),
chr(0x3D)=>chr(0x003D),
chr(0x3E)=>chr(0x003E),
chr(0x3F)=>chr(0x003F),
chr(0x40)=>chr(0x044E),
chr(0x41)=>chr(0x0430),
chr(0x42)=>chr(0x0431),
chr(0x43)=>chr(0x0446),
chr(0x44)=>chr(0x0434),
chr(0x45)=>chr(0x0435),
chr(0x46)=>chr(0x0444),
chr(0x47)=>chr(0x0433),
chr(0x48)=>chr(0x0445),
chr(0x49)=>chr(0x0438),
chr(0x4A)=>chr(0x0439),
chr(0x4B)=>chr(0x043A),
chr(0x4C)=>chr(0x043B),
chr(0x4D)=>chr(0x043C),
chr(0x4E)=>chr(0x043D),
chr(0x4F)=>chr(0x043E),
chr(0x50)=>chr(0x043F),
chr(0x51)=>chr(0x044F),
chr(0x52)=>chr(0x0440),
chr(0x53)=>chr(0x0441),
chr(0x54)=>chr(0x0442),
chr(0x55)=>chr(0x0443),
chr(0x56)=>chr(0x0436),
chr(0x57)=>chr(0x0432),
chr(0x58)=>chr(0x044C),
chr(0x59)=>chr(0x044B),
chr(0x5A)=>chr(0x0437),
chr(0x5B)=>chr(0x0448),
chr(0x5C)=>chr(0x044D),
chr(0x5D)=>chr(0x0449),
chr(0x5E)=>chr(0x0447),
chr(0x5F)=>chr(0x044A),
chr(0x60)=>chr(0x042E),
chr(0x61)=>chr(0x0410),
chr(0x62)=>chr(0x0411),
chr(0x63)=>chr(0x0426),
chr(0x64)=>chr(0x0414),
chr(0x65)=>chr(0x0415),
chr(0x66)=>chr(0x0424),
chr(0x67)=>chr(0x0413),
chr(0x68)=>chr(0x0425),
chr(0x69)=>chr(0x0418),
chr(0x6A)=>chr(0x0419),
chr(0x6B)=>chr(0x041A),
chr(0x6C)=>chr(0x041B),
chr(0x6D)=>chr(0x041C),
chr(0x6E)=>chr(0x041D),
chr(0x6F)=>chr(0x041E),
chr(0x70)=>chr(0x041F),
chr(0x71)=>chr(0x042F),
chr(0x72)=>chr(0x0420),
chr(0x73)=>chr(0x0421),
chr(0x74)=>chr(0x0422),
chr(0x75)=>chr(0x0423),
chr(0x76)=>chr(0x0416),
chr(0x77)=>chr(0x0412),
chr(0x78)=>chr(0x042C),
chr(0x79)=>chr(0x042B),
chr(0x7A)=>chr(0x0417),
chr(0x7B)=>chr(0x0428),
chr(0x7C)=>chr(0x042D),
chr(0x7D)=>chr(0x0429),
chr(0x7E)=>chr(0x0427),
chr(0xC0)=>chr(0x0491),
chr(0xC1)=>chr(0x0452),
chr(0xC2)=>chr(0x0453),
chr(0xC3)=>chr(0x0454),
chr(0xC4)=>chr(0x0451),
chr(0xC5)=>chr(0x0455),
chr(0xC6)=>chr(0x0456),
chr(0xC7)=>chr(0x0457),
chr(0xC8)=>chr(0x0458),
chr(0xC9)=>chr(0x0459),
chr(0xCA)=>chr(0x045A),
chr(0xCB)=>chr(0x045B),
chr(0xCC)=>chr(0x045C),
chr(0xCD)=>chr(0x045E),
chr(0xCE)=>chr(0x045F),
chr(0xD0)=>chr(0x0463),
chr(0xD1)=>chr(0x0473),
chr(0xD2)=>chr(0x0475),
chr(0xD3)=>chr(0x046B),
chr(0xDB)=>chr(0x005B),
chr(0xDD)=>chr(0x005D),
chr(0xDF)=>chr(0x005F),
chr(0xE0)=>chr(0x0490),
chr(0xE1)=>chr(0x0402),
chr(0xE2)=>chr(0x0403),
chr(0xE3)=>chr(0x0404),
chr(0xE4)=>chr(0x0401),
chr(0xE5)=>chr(0x0405),
chr(0xE6)=>chr(0x0406),
chr(0xE7)=>chr(0x0407),
chr(0xE8)=>chr(0x0408),
chr(0xE9)=>chr(0x0409),
chr(0xEA)=>chr(0x040A),
chr(0xEB)=>chr(0x040B),
chr(0xEC)=>chr(0x040C),
chr(0xED)=>chr(0x040E),
chr(0xEE)=>chr(0x040F),
chr(0xEF)=>chr(0x042A),
chr(0xF0)=>chr(0x0462), 
chr(0xF1)=>chr(0x0472), 
chr(0xF2)=>chr(0x0474), 
chr(0xF3)=>chr(0x046A), 

);

while ( my($test,$expected) = each %valid ) {
    my $converted = $cs->to_utf8($test);
    is( $converted => $expected,
	'valid Cyrillic character chr(0x'.sprintf("%2x",ord($test)).')'
    ); 
}

## and lets try one longish string
my $test = chr(0xEA).chr(0xF3).chr(0xF2).chr(0xF2).chr(0xED);
my $expected = chr(0x040A).chr(0x046A).chr(0x0474).chr(0x0474).chr(0x040E);
is ($cs->to_utf8($test),$expected,'longish Cyrillic string');




