package SiteSpy;

use strictures 1;

use Array::Diff;
use HTML::TreeBuilder;
use Moo;

has old_HTML => (
    is      => 'ro',
    default => sub { '' },
);

has new_HTML => (
    is          => 'ro',
    required    => 1,
);

has new_tree => (
    is => 'lazy',
);

has old_tree => (
    is => 'lazy',
);

has args => (
    is          => 'ro',
    required    => 1,
);

sub _build_new_tree {
    my ($self) = @_;

    return HTML::TreeBuilder->new_from_content($self->new_HTML);
}

sub _build_old_tree {
    my ($self) = @_;

    return HTML::TreeBuilder->new_from_content($self->old_HTML);
}

sub get_content {
    my ($self, $elem) = @_;

    return $elem->as_trimmed_text;
}

sub collect_elems {
    my ($self, $args_ref) = @_;

    my (@old, @new);

    my @old_elems = $self->old_tree->look_down(%{$args_ref});
    my @new_elems = $self->new_tree->look_down(%{$args_ref});

    my $elem;

    for $elem (@old_elems) {
        push @old, $self->get_content($elem);
    }

    for $elem (@new_elems) {
        push @new, $self->get_content($elem);
    }

    return (\@old, \@new);
}

sub find_diffs {
    my ($self) = @_;

    my $args = $self->args;

    my ($old_ref, $new_ref) = $self->collect_elems($args);
    my $diff = Array::Diff->diff($old_ref, $new_ref);

    return $diff;
}

1;
