/*
 * IBPerl -- a Perl 5 extension for SQL RDBMS programming
 *   with InterBase client library.
 *
 * handles.c
 *
 * Copyright (c) 1996-1999 Bill Karwin
 *
 * This is unsupported, free software.  Neither Bill Karwin,
 * InterBase Software Corporation, nor Inprise Corporation are
 * responsible for damages resulting from the use or misuse of
 * this software.  Test early, test well, test often.
 *
 * You may distribute under the terms of either the GNU General
 * Public License or the Artistic License, as specified in the
 * Perl README file.
 */

#define H_PERL 1
#include "IBPerl.h"

static DB_info *DB = NULL;
static int num_db = 0;
static void IB_init_DB(int);
static void IB_init_TR(int);
static void IB_init_ST(int);

static void
IB_init_DB(i)
int i;
{
    DB[i].id = i;
    if ((DB[i].dpb_buffer = (char *) malloc(1024 * sizeof(char))) == NULL)
    {
	 fprintf(stderr, "Cannot allocate dpb buffer.\n");
	 exit(1);
    }

    DB[i].handle = (isc_db_handle) NULL;
}

DB_info *
IB_new_DB()
{
int i;

    if (num_db == 0)
    {
	if ((DB = (DB_info *) malloc(CHUNK * sizeof(DB_info))) == NULL)
	{
	     fprintf(stderr, "Cannot allocate database information structures.\n");
	     exit(1);
	}

	for (i=FIRST; i<CHUNK; ++i)
	{
	    IB_init_DB(i);
	}

	num_db = CHUNK;
	i = FIRST;

    } else {
	for (i=FIRST; i<num_db && DB[i].inuse != AVAILABLE; ++i)
	{
	    ;
	}

	if (i >= num_db)
	{
	    if ((DB = (DB_info *) realloc(DB, sizeof(DB_info)*(num_db+CHUNK))) == NULL)
	    {
		fprintf(stderr, "Cannot allocate database information structures.\n");
		exit(1);
	    }

	    for (i=num_db; i<num_db+CHUNK; ++i)
	    {
		IB_init_DB(i);
	    }

	    i = num_db;
	    num_db += CHUNK;
	}
    }

    DB[i].inuse = TAKEN;
    return &DB[i];
}

DB_info *
IB_get_DB(int handle)
{
    if (handle < 0 || handle >= num_db) return (DB_info *) NULL;
    return DB[handle].inuse == TAKEN ? &(DB[handle]) : (DB_info *) NULL;
}

void
IB_free_DB(DB_info *DB)
{
    if (DB == (DB_info *) NULL) return;

    DB->inuse = AVAILABLE;
    DB->handle = (isc_db_handle) NULL;
}

/**********************************************************************/

static TR_info *TR = NULL;
static int num_tr = 0;

static void
IB_init_TR(int i)
{
    TR[i].id = i;
    if ((TR[i].tpb_buffer = (char *) malloc(1024 * sizeof(char))) == NULL)
    {
	 fprintf(stderr, "Cannot allocate tpb buffer.\n");
	 exit(1);
    }
    TR[i].handle = (isc_tr_handle) NULL;
}

TR_info *
IB_new_TR(int dbhandle)
{
int i;

    if (num_tr == 0)
    {
	if ((TR = (TR_info *) malloc(CHUNK * sizeof(TR_info))) == NULL)
	{
	    fprintf(stderr, "Cannot allocate database information structures.\n");
	    exit(1);
	}

	num_tr = CHUNK;
	i = FIRST;

    } else {
	for (i=FIRST; i<num_tr && TR[i].inuse != AVAILABLE; ++i)
	{
	    ;
	}

	if (i >= num_tr)
	{
	    if ((TR = (TR_info *) realloc(TR, sizeof(TR_info)*(num_tr+CHUNK))) == NULL)
	    {
		fprintf(stderr, "Cannot allocate database information structures.\n");
		exit(1);
	    }

	    i = num_tr;
	    num_tr += CHUNK;
	}
    }

    IB_init_TR(i);
    TR[i].inuse = TAKEN;
    TR[i].db = &DB[dbhandle];
    return &TR[i];
}

TR_info *
IB_get_TR(int handle)
{
    if (handle < 0 || handle >= num_tr) return (TR_info *) NULL;
    return TR[handle].inuse == TAKEN ? &(TR[handle]) : (TR_info *) NULL;
}

void
IB_free_TR(TR_info *TR)
{
    if (!TR) return;

    TR->inuse = AVAILABLE;
    TR->db = NULL;
    TR->handle = (isc_tr_handle) NULL;
}

/**********************************************************************/

static ST_info *ST = NULL;
static int num_st = 0;

static void
IB_init_ST(int i)
{
    ST[i].id = i;

    if ((ST[i].out_sqlda = (XSQLDA *) malloc(XSQLDA_LENGTH(20))) == NULL)
    {
	 fprintf(stderr, "Cannot allocate SQL internal data structure.\n");
	 exit(1);
    }
    ST[i].out_sqlda->version = SQLDA_VERSION1;
    ST[i].out_sqlda->sqln = 20;

    if ((ST[i].in_sqlda = (XSQLDA *) malloc(XSQLDA_LENGTH(2))) == NULL)
    {
	 fprintf(stderr, "Cannot allocate SQL internal data structure.\n");
	 exit(1);
    }
    ST[i].in_sqlda->version = SQLDA_VERSION1;
    ST[i].in_sqlda->sqln = 2;

    ST[i].cursor_name = NULL;
    ST[i].sqldialect = IBPERL_DEFAULT_SQL_DIALECT;
    ST[i].sp_fetched = 0;
    ST[i].osqlind = NULL;
    ST[i].isqlind = NULL;

    ST[i].handle = (isc_stmt_handle) NULL;
}

ST_info *
IB_new_ST(int trhandle)
{
int i;

    if (num_st == 0)
    {
	if ((ST = (ST_info *) malloc(CHUNK * sizeof(ST_info))) == NULL)
	{
	    fprintf(stderr, "Cannot allocate database information structures.\n");
	    exit(1);
	}

	num_st = CHUNK;
	i = FIRST;

    } else {
	/*
	 * Find first AVAILABLE ST.
	 */
	for (i=FIRST; i<num_st && ST[i].inuse != AVAILABLE; ++i)
	{
	    ;
	}

	if (i >= num_st)
	{
	    if ((ST = (ST_info *) realloc(ST, sizeof(ST_info)*(num_st+CHUNK))) == NULL)
	    {
		fprintf(stderr, "Cannot allocate database information structures.\n");
		exit(1);
	    }

	    i = num_st;
	    num_st += CHUNK;
	}
    }

    IB_init_ST(i);
    ST[i].inuse = TAKEN;
    ST[i].trans = &TR[trhandle];
    return &ST[i];
}

ST_info *
IB_get_ST(int handle)
{
    if (handle < 0 || handle >= num_st) return (ST_info *) NULL;
    return ST[handle].inuse == TAKEN ? &(ST[handle]) : (ST_info *) NULL;
}

void
IB_free_ST(ST_info *ST)
{
    int i;
    XSQLVAR *var;

    if (!ST) return;

    /*
     * It's a shame C doesn't garbage collect like Perl.
     * XXX Should I reimplement the dynamic allocation
     * of these handles and structures to use Perl mortals?
     * Something to think about...
     */
    if (ST->out_sqlda)
    {
	for (i=0, var = ST->out_sqlda->sqlvar;
	    i < ST->out_sqlda->sqld;
	    i++, var++)
	{
	    if (var->sqldata) { free(var->sqldata); }
	}

 	free(ST->out_sqlda);
	ST->out_sqlda = NULL;
    }
    if (ST->osqlind) free(ST->osqlind);

    if (ST->in_sqlda)
    {
	for (i=0, var = ST->in_sqlda->sqlvar;
	    i < ST->in_sqlda->sqld;
	    i++, var++)
	{
	    if (var->sqldata) { free(var->sqldata); }
	}

 	free(ST->in_sqlda);
	ST->in_sqlda = NULL;
    }
    if (ST->isqlind) free(ST->isqlind);

    if (ST->cursor_name)
    {
	free(ST->cursor_name);
	ST->cursor_name = NULL;
    }

    ST->sp_fetched = 0;

    ST->inuse = AVAILABLE;
    ST->trans = NULL;
    ST->handle = (isc_stmt_handle) NULL;
}
