/*
 * Diag.sql -- InterBase SQL script to create an example
 * expert system database for use in diag.pl, an IBPerl
 * CGI application.
 * Copyright 1996 Bill Karwin
 */

CREATE DATABASE "diag.gdb";

SET ECHO ON;

CREATE TABLE FLOWCHART (
	NODE    SMALLINT NOT NULL PRIMARY KEY,
	NOTES   VARCHAR(1024),
	HITS    INTEGER DEFAULT 0 NOT NULL,
	LAST    DATE DEFAULT "TODAY" NOT NULL
);

CREATE TABLE LINKS (
	NODE    SMALLINT REFERENCES FLOWCHART(NODE),
	CHOICE  VARCHAR(50),
	LINK    SMALLINT REFERENCES FLOWCHART(NODE)
);

INSERT INTO FLOWCHART (NODE, NOTES) VALUES (1, "What error message are you getting?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (2, "Can you rlogin to the server without supplying a password?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (3, "You must establish Host Equivalence between the server and client, with /etc/hosts.equiv or .rhosts configuration files, or NIS host equivalence configuration.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (4, "Are all aliases for the client's hostname listed in the server's /etc/hosts.equiv?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (5, "You must list all hostname aliases in the /etc/hosts.equiv to satisfy host equivalence for InterBase.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (6, "Is your user name and id the same on the client and server?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (7, "Use identical login names and uid's, or else use the gds_proxy feature of InterBase to map users.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (8, "What are the permissions for /usr/interbase/bin/gds_inet_server on the server?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (9, "Fix the perms on the file with: chmod 6755 gds_inet_server");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (10, "Is inetd running?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (11, "Reboot the system to start inetd.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (12, "Does /etc/inetd.conf contain an entry for gds_db?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (13, "Add to the end of /etc/inetd.conf: gds_db stream tcp nowait root /usr/interbase/bin/gds_inet_server /usr/interbase/bin/gds_inet_server .  Then find the process id of inetd and use: kill -HUP pid  to restart inetd.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (14, "Try to test the TCP/IP connection from the client to the server.  Run on the client: ping server .");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (15, "Configure your network so that you can ping from the client to the server with TCP/IP.");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (16, "Does /etc/inetd.conf contain an entry for gds_db?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (17, "Does /etc/services have an entry for gds_db?");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (18, "Add to the end of /etc/services: gds_db 3050/tcp .");
INSERT INTO FLOWCHART (NODE, NOTES) VALUES (19, "Check /etc/netgroup file for mistakes.");

INSERT INTO LINKS VALUES ( 1, "Connection Rejected", 2);
INSERT INTO LINKS VALUES ( 1, "Connection Refused", 14);
INSERT INTO LINKS VALUES ( 1, "Sometimes Rejected, Sometimes Refused", 19);

INSERT INTO LINKS VALUES ( 2, "Yes", 4);
INSERT INTO LINKS VALUES ( 2, "No", 3);

INSERT INTO LINKS VALUES ( 4, "Yes", 6);
INSERT INTO LINKS VALUES ( 4, "No", 5);

INSERT INTO LINKS VALUES ( 6, "Yes", 8);
INSERT INTO LINKS VALUES ( 6, "No", 7);

INSERT INTO LINKS VALUES ( 8, "-rwsr-sr-x", 10);
INSERT INTO LINKS VALUES ( 8, "-rwxr-xr-x", 9);
INSERT INTO LINKS VALUES ( 8, "-rw-r--r--", 9);
INSERT INTO LINKS VALUES ( 8, "none of the above", 9);

INSERT INTO LINKS VALUES ( 10, "Yes", 12);
INSERT INTO LINKS VALUES ( 10, "No", 11);

INSERT INTO LINKS VALUES ( 12, "Yes", 14);
INSERT INTO LINKS VALUES ( 12, "No", 13);

INSERT INTO LINKS VALUES ( 14, "Server is alive and responding.", 16);
INSERT INTO LINKS VALUES ( 14, "Error: unknown host.", 15);
INSERT INTO LINKS VALUES ( 14, "Error: host not responding.", 15);

INSERT INTO LINKS VALUES ( 16, "Yes", 17);
INSERT INTO LINKS VALUES ( 16, "No", 13);

INSERT INTO LINKS VALUES ( 17, "Yes", 19);
INSERT INTO LINKS VALUES ( 17, "No", 18);

COMMIT;
