package VMS::Process;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;
require DynaLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw();
@EXPORT_OK = qw(&process_list &suspend_process &release_process
                &kill_process &change_priority);
$VERSION = '0.02';

bootstrap VMS::Process $VERSION;

# Preloaded methods go here.
#sub new {
#  my($pkg,$pid) = @_;
#  my $self = { __PID => $pid || $$ };
#  bless $self, $pkg; 
#}
#
#sub one_info { get_one_proc_info_item($_[0]->{__PID}, $_[1]); }
#sub all_info { get_all_proc_info_items($_[0]->{__PID}) }
#
#sub TIEHASH { my $obj = new VMS::Process @_; $obj; }
#sub FETCH   { $_[0]->one_info($_[1]); }
#sub EXISTS  { grep(/$_[1]/, proc_info_names()) }
#
# Can't STORE, DELETE, or CLEAR--this is readonly. We'll Do The Right Thing
# later, when I know what it is...
#sub STORE   {
#  my($self,$priv,$val) = @_;
#  if (defined $val and $val) { $self->add([ $priv ],$self->{__PRMFLG});    }
#  else                       { $self->remove([ $priv ],$self->{__PRMFLG}); }
#}
#sub DELETE  { $_[0]->remove([ $_[1] ],$_[0]->{__PRMFLG}); }
#sub CLEAR   { $_[0]->remove([ keys %{$_[0]->current_privs} ],$_[0]->{__PRMFLG}) }

#sub FIRSTKEY {
#  $_[0]->{__PROC_INFO_ITERLIST} = [ proc_info_names() ];
#  $_[0]->one_info(shift @{$_[0]->{__PROC_INFO_ITERLIST}});
#}
#sub NEXTKEY { $_[0]->one_info(shift @{$_[0]->{__PROC_INFO_ITERLIST}}); }

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

VMS::Process - Perl extension to manage processes

=head1 SYNOPSIS

  use VMS::Process;

  @pid_list = process_list([@process_characteristics]);
  $WorkedOK = suspend_process($pid);
  $WorkedOK = release_process($pid);
  $WorkedOK = kill_process($pid);
  $WorkedOK = change_priority($pid, $priority);
  @char_list = valid_process_chars();

=head1 DESCRIPTION

VMS::Process allows a perl program to get a list of some or all the
processes on one or more nodes in the cluster, change process priority,
suspend, release, or kill them. Normal VMS system security is in effect, so
a program can't see or modify processes that the process doesn't have the
privs to see. Once process pids are available, information about those
processes can be retrieved with the VMS::ProcInfo module.

=head2 Narrowing down the PID list from C<process_list()>

process_list uses the VMS $PROCESS_SCAN system service to narrow down the
list of PIDs that it returns. Normally, a full-wildcard scan is done,
returning all the PIDs for all the cluster nodes that your process has
privileges to see. Oftentimes, though, you'll get more PIDS than you really
want.

The process_list function takes an optional reference to a list with the
characteristics of the processes whose pids will be returned. Each element
of the list is a hash struct with required NAME and VALUE elements, and 
optional COMPARISION and MODIFIER elements.

The NAME element is the name of the thing you want to select on. They're
the names of the constants that $PROCESS_SCAN takes, minus the leading
PSCAN$_. A list is available from the C<process_list_names()> function.

Some of the items you can select on, specifically JOBTYPE, MODE, and STATE,
take symbolic values instead of integers. Rather than having to figure out
what the constant SCH$C_MWAIT really is, you can use "MWAIT" instead.

The VALUE element is the value being compared to. It will be used either in
an integer or string context, depending on what NAME is.

The COMPARISON element specifies what sort of comparison should be
made. The choices are C<gt>, C<lt>, C<eq>, C<le>, C<ge>, C<ne>, C<pre>, and
C<*>, for greater than, less than, equal, less than or equal greater than
or equal, not equal, prefix match, or wildcard matching.

If the COMPARISON element is not specified, C<eq> is assumed.

The MODIFIER element specifies the special things that affect this list
item. They are C<|>, C<&&>, C<||>, and C<I>. C<|> indicates this entry
should be ORd with the I<next> entry. C<&&> is a bitwise AND, and C<||> is
a bitwise OR (valid only for bitmask items). C<I> makes comparisons case
insensitive, and is valid only for string comparisions.

The standard VMS wildcards are used--C<*> for any characters, and C<%> for
one character. Sorry, no Perl regexps.

=head2 Getting valid NAME names

The function C<process_list_names()> returns a list of all the valid names
that can be used as elements for the C<process_list()> function.

=head1 BUGS

May leak memory. May not, though.

While process_list is supposed to take a hash ref, right now it
doesn't. You get all the pids for the processes on the cluster that you
would normally have privs to see.

=head1 LIMITATIONS

The list built and passed to $PROCESS_SCAN in the order that they're passed
to C<process_list>. This means you must follow the rules and limitations of
$PROCESS_SCAN. The biggest being that OR'd items I<must> be of the same
type. (No ORing NODENAME and USERNAME, for example)

The tests are really primitive. (Like there aren't any right now)

VMS system security is in force, so process_list() is likely to show fewer
PIDs than SHOW SYSTEM will. Nothing we can do about that, short if INSALLing Perl with lots of privs, which is a really, really bad idea, so don't.

=head1 AUTHOR

Dan Sugalski <sugalsd@lbcc.cc.or.us>

=head1 SEE ALSO

perl(1), VMS::ProcInfo.

=cut
