use strict;

use ExtUtils::MakeMaker qw( prompt WriteMakefile );

# Saves some headaches for people later.
use 5.005;

{
    unless (-d './Install')
    {
        mkdir './Install', 0755
            or die "can't make dir ./Install: $!";
    }

    my %config;
    $config{email_address} = prompt( q[
To do a full test of the Log::Dispatch::* modules, we need
to attempt to send an email.  If you want these tests to
be done please supply an address.
Address?] );

    $config{syslog} = prompt( q[ 
Do you want to test Log::Dispatch::Syslog by sending a message as
daemon.notice?
Yes/No?], 'No' );

    delete $config{syslog} if $config{syslog} !~ /^y(?:es)?/i;

    if ($config{syslog})
    {
        my $default;
        foreach ( qw( /var/adm/messages
                      /var/adm/syslog
                      /var/log/messages
                      /var/log/syslog
                      /var/log/syslog
                      /etc/log/syslog ) )
        {
            if (-e)
            {
                $default = $_;
                last;
            }
        }

        $config{syslog_file} = prompt('What file would a message sent as daemon.notice end up in?', $default);

        unless (-r $config{syslog_file})
        {
            warn "$config{syslog_file} is not readable.  Syslog tests will be skipped\n";
            delete $config{syslog};
            delete $config{syslog_file};
        }
    }

    open CFG, ">./Install/TestConfig.pm"
        or die "can't write to ./Install/TestConfig.pm: $!";

    print CFG <<"EOF";
#
#    This file was automatically generated by Makefile.PL. Do not
#    edit, instead do a "make realclean" in the toplevel directory and
#    rerun "perl makefile.PL".
#

package Install::TestConfig;
EOF

    print CFG "\%config = \n(\n";
    foreach (keys %config)
    {
        print CFG "\t$_ => '$config{$_}',\n";
    }
    print CFG ');';
    close CFG;
}

WriteMakefile( NAME	=> 'Log::Dispatch',
               VERSION_FROM => 'lib/Log/Dispatch.pm',
               PREREQ_PM => { 'Params::Validate' => 0.15,
                            },

               AUTHOR => 'Dave Rolsky <autarch@urth.org>',
               ABSTRACT => 'Uniform logging interface to multiple outputs',

               realclean => { FILES => 'write_mode.tst ./Install/TestConfig.pm ./Install' },
	     );

package MY;

sub libscan
{
    my $self = shift;
    my $file = shift;

    return $file =~ /svn/ ? 0 : $self->SUPER::libscan($file);
}
