use ExtUtils::MakeMaker;
use Config;
use FileHandle ();
use File::Basename qw(dirname);
use File::Copy qw(cp);
use File::Path qw(mkpath rmtree);
use Cwd;

$VERSION = "0.98_03";
#
# Check if Readline is installed
#

use subs qw(_prompt);

readline_setup();        
#
# Check if knwon config
#

eval 'use Apache::MyConfig' ;

if ($@ eq '') { 
    $APACHE_SRC_DEFAULT = $Apache::MyConfig::Setup{Apache_Src} ; 
}
else {
    $APACHE_SRC_DEFAULT = '../apache_x.x/src' ;
}

my $PWD = cwd;

# Patch up the Makefiles we are going to use with Apache
system $^X, "-pi", "-e", "s!^PERL\\s*=.*!PERL=$Config{'perlpath'}!",
            <src/Makefile.tmpl*>, "src/modules/perl/Makefile";

#soes yous can try out the zamples
unless (-l "t/net/perl/eg") {
    system "$Config{lns} $PWD/eg $PWD/t/net/perl/eg";
}

chmod 0644, "t/conf/mod_perl_srm.conf";

#generated by us at one time or another
my(@do_clean) = qw{
   t/docs/.htaccess 
   t/docs/hooks.txt
   src/Configuration
   lib/Apache/MyConfig.pm
};
#t/conf/httpd.conf
#t/net/config.pl

for(@do_clean) { unlink $_ }
rmtree "t/docs/stacked", 0, 0;

my(@test_pre_init) = qq(
test_pre_init:
);

# Automatic setup support
my(@adirs, %seen, %mft_map, %vers_map, $src_dir, $vers, $conf, $ans);
%vers_map = (
   '1.1.1' => "Makefile.tmpl",
   '1.1.3' => "Makefile.tmpl",
   '1.2'  => "Makefile.tmpl-1.2",
   '1.1.1Ben-SSL' => "Makefile.tmpl-Ben-SSL",
   NONE => "", 
);	     

$Port = $PORT = 8529;
$NO_HTTPD = $ENV{NO_HTTPD} || 0;
$PERL_TRACE = 0;
$ALL_HOOKS  = 0;
$APACHE_SRC = "";
$PERL_SECTIONS = 0;
$ADD_VERSION = 1;
$STATIC = 0;

#callback hooks
@callback_hooks = qw{
   PERL_HANDLER
   PERL_TRANS PERL_AUTHEN PERL_AUTHZ 
   PERL_ACCESS PERL_TYPE PERL_FIXUP
   PERL_LOG PERL_HEADER_PARSER
   PERL_INIT PERL_CLEANUP
   PERL_STACKED_HANDLERS 
   PERL_METHOD_HANDLERS
};
$callback_alias{PERL_INIT} = "PERL_HEADER_PARSER";
$callback_alias{PERL_CLEANUP} = "PERL_LOG";
%callback_hooks = map { $_,0 } @callback_hooks;
$callback_hooks{PERL_HANDLER} = 1; #PerlHandler always on
#$callback_hooks{PERL_CLEANUP} = 1;
#$callback_hooks{PERL_TRANS}   = 1;
%cant_hook = ();

while($_ = shift) {
    ($k,$v) = split /=/;
    $v ||= 1;
    ${$k} = $v, next if defined ${$k};
    $callback_hooks{$k} = $v if exists $callback_hooks{$k};
}

for (keys %callback_alias) {
    $callback_hooks{$callback_alias{$_}}++ 
       if $callback_hooks{$_};
}

if($ALL_HOOKS) {
    for (@callback_hooks) {
	next if /Handlers?$/i;
	$callback_hooks{$_}++;
    }
}

foreach $src_dir ($APACHE_SRC, qw(../apache_1.1.1/src), <../apache_1.2*/src>,
		  <../apache*/src>, <../stronghold*/src>, <../src>, <./src>) 
{
    next unless -d $src_dir;
    next if $seen{$src_dir}++;
    next unless $vers = httpd_version($src_dir);
    $no_header_parser{$src_dir}++ if $no_header_parser{$vers};
    unless(exists $vers_map{$vers}) {
	print STDERR "Apache version '$vers' unsupported\n";
	next;
    }
    $mft_map{$src_dir} = $vers_map{$vers};
    #print STDERR "$src_dir -> $vers_map{$vers}\n";
    push @adirs, $src_dir;
}

unless (@adirs) {
    print "Enter `q' to stop search\n";
    while(1) {
       print "Please tell me where I can find your apache src\n" ; 
       $src_dir = _prompt("", $APACHE_SRC_DEFAULT);
       last if $src_dir eq "q";
	if(-d $src_dir) {
	    push(@adirs, $src_dir);
	    $mft_map{$src_dir} = $vers_map{httpd_version($src_dir)};
	    last;
	}
	else {
	    print "Can't stat $src_dir\n";
	}
    }
}

foreach $adir (@adirs) {
    $conf = "$adir/Configuration";
    $httpd_h = "$adir/httpd.h";

    if (-e $httpd_h) {
	unless($APACHE_SRC) {
	    $ans = _prompt("Configure mod_perl with $adir ?", "y");
	    next unless $ans =~ /^y$/i;
	    $APACHE_SRC = $adir;
	}
	$IsBenSSL = -e "$adir/apache_ssl.c";
	last unless(-e $conf || -e "$conf.tmpl"); #building from 'make offsite-tar' 
	unless ($NO_HTTPD) {
	    $ans = _prompt("Shall I build httpd in $adir for you?", "y");
	    ++$NO_HTTPD unless $ans =~ /^y$/i;
	}
	last if $NO_HTTPD;

	unless ($can_dash_make{$adir}) {
	    unless (-e "$adir/Makefile.tmpl.bak") {
		print STDERR "Backing up $adir/Makefile.tmpl to $adir/Makefile.tmpl.bak\n";
		cp "$adir/Makefile.tmpl", "$adir/Makefile.tmpl.bak";
	    }
	    cp "src/$mft_map{$adir}", "$adir/Makefile.tmpl";
	    print STDERR "cp src/$mft_map{$adir} $adir/Makefile.tmpl\n";
	}

	mkpath "$adir/modules/perl";
	#ignore make's output here
	`(cd $adir/modules/perl && make clean 2> /dev/null)`;

	local(*MANI);
	open *MANI, "MANIFEST" or die "open MANIFEST $!";
	my $atopdir = dirname($adir);
	#only rm and cp files mod_perl ships with
	while(<MANI>) {
	    next unless m,^src/modules/perl/,; chomp;
	    #print "rm -f $adir/$_\n";
	    unlink "$atopdir/$_";
	    #print "cp $_ $adir/$_\n";
	    cp $_, "$atopdir/$_";
	}
	close MANI;
	unless(-e "src/Configuration" and (-M "src/Configuration" < -M $conf)) {
	    unless(-e $conf) {
		cp "$conf.tmpl", $conf;
	    }
	    cp $conf, "src/Configuration";
	    $conf = "src/Configuration";

	    if ($ADD_VERSION) {
		my $inc = " -I$Config{archlibexp}/CORE -I./";
		system $^X, "-pi", "-e",  
		q{next unless /EXTRA_CFLAGS\s*=/;}.
 	        q{next if /mod_perl/; chomp; }.
		qq{\$_ .= q: $inc -DSERVER_SUBVERSION=\\"mod_perl/$VERSION\\"\n:;},
			$conf;
	    }

	    $b8_chop = (split "/", $PWD)[1];

	    my $ldopts = "`$^X $PWD/src/modules/perl/ldopts`";
	    system $^X, "-pi", "-e",  
	    q{next unless /EXTRA_LIBS\s*=/;}.
            q{next if /perl/; chomp;}.
            qq{\$_ .= q: $ldopts\n:;},
	    $conf;

	    open(CONF, $conf) || die "Can't open $conf: $!";
	    while (<CONF>) {
		$seen_modperl++ if /^Module\s+perl_module/i;
	    }
	    close(CONF);
	    unless ($seen_modperl) {
		print "Appending mod_perl to $conf\n";
		open(CONF, ">>$conf") || die "Can't open $conf: $!";
		print CONF <<EOT;
		
# Embed a perl interpreter
Module perl_module         modules/perl/libmodperl.a


EOT
    close(CONF);
	    } else {
		print "mod_perl already present in $conf\n";
	    }
	}
    }

    unless ($NO_HTTPD) {
	$conf = "src/Configuration";
	my $dash_make;
	$dash_make = " -make $PWD/src/$mft_map{$adir} "
	    if $can_dash_make{$adir} and $mft_map{$adir};
	#print STDERR "(cd $adir; ./Configure${dash_make} -file $PWD/$conf)\n";
	system "(cd $adir && ./Configure${dash_make} -file $PWD/$conf)";
	if($do_b8_chop and -e "$adir/modules/Makefile") {
	    print "getting rid of $b8_chop target in modules/Makefile\n";
	    system $^X, "-pi~", "-e", 
	    "s/=$b8_chop".'\s+/=/g', "$adir/modules/Makefile";
	}
    }

    open FH, "$APACHE_SRC/Makefile";
    while(<FH>) {
	$EXTRA_CFLAGS = $1 if /CFLAGS1\s*=\s*(.*)/;
    }
    close FH;
    print "EXTRA_CFLAGS: $EXTRA_CFLAGS\n" if $EXTRA_CFLAGS;

    last if $APACHE_SRC;
}

unless ($NO_HTTPD) {
    ++$STATIC if $Config{osname} =~ /^(aix|bsdos)$/i;

    if($no_header_parser{$APACHE_SRC}) {
	$callback_hooks{PERL_HEADER_PARSER} = 0;
	$cant_hook{PERL_HEADER_PARSER} = 
	    "(need 1.2b5 or higher)";
    }

    setup_for_static() if $STATIC;

    system $^X, "-pi~", "-e", 
    's/^(PERL_SECTIONS) /#$1 /', 
    "$APACHE_SRC/modules/perl/Makefile" 
	if $PERL_SECTIONS;

    for ( @callback_hooks) {
	($k,$v) = ($_,$callback_hooks{$_});
	system $^X, "-pi~", "-e", 
	"s/^$k /#$k /", "$APACHE_SRC/modules/perl/Makefile" if $v;
	$why = ($cant_hook{$k} || "(enable with $k=1)") unless $v;
	$k =~ s/([A-Z]+)/ucfirst(lc($1))/ge;
	$k =~ s/_//g;
	$k .= "Handler" unless $k =~ /Handlers?$/;
	print $k . '.' x (25 - length($k));
	print $v ? "enabled\n" : "disabled $why\n";
    }

    system $^X, "-pi~", "-e", 
    "s/^#TRACE/TRACE/", "$APACHE_SRC/modules/perl/Makefile" if $PERL_TRACE;

    system $^X, "-pi~", "-e", 
    "s/^#APACHE_SSL/APACHE_SSL/",
    "$APACHE_SRC/modules/perl/Makefile" if is_ssl();

    my $p54 = "-DHAVE_PERL_5__4" if $] > 5.00398;
    my $edit_note = quotemeta(<<EOF);

#---------------------------------------------------------------------
# This Makefile is derived from:
# $PWD/src/modules/perl/Makefile 
# which comes with the mod_perl distribution and 
# written by mod_perl's Makefile.PL.
# Rerunning Makefile.PL overwrites this file. Consequently...

# DO NOT EDIT THIS FILES, EDIT
#    $PWD/src/modules/perl/Makefile
# INSTEAD
#---------------------------------------------------------------------

#let's not bother with patchlevel.h
PERL_VERSION = $p54

EOF
    system $^X, "-pi~", "-e", 
    "s/^#__ORIGINAL__/$edit_note/",
    "$APACHE_SRC/modules/perl/Makefile";

    if($callback_hooks{PERL_TRANS}) {
	push @test_pre_init, 
	"\t", '$(CP) t/conf/mod_perl_srm.conf /tmp', "\n";
    }
    unless (-l "t/httpd") {
	system "$Config{lns} $APACHE_SRC/httpd t/httpd";
    }
    write_extra_tests();
}

unless (-e "t/net/config.pl") {
    cp "t/net/config.pl.dist", "t/net/config.pl";
}

unless(-e "t/conf/httpd.conf") {
    cp "t/conf/httpd.conf-dist", "t/conf/httpd.conf";
#    $User  = (getpwnam('nobody'))[0]  || getpwuid($>) || $>;
#    $Group = (getgrnam('nogroup'))[0] || getgrgid($)) || $); 
    $User  = getpwuid($>) || $>;
    $Group = getgrgid($)) || $); 

    print STDERR "Will run tests as User: '$User' Group: '$Group'\n";

    if($Port != $PORT) {
	system $^X, "-pi~", "-e", 
	"s/^(Port) .*/\$1 $PORT/", "t/conf/httpd.conf";
	system $^X, "-pi~", "-e", 
	"s/$Port/$PORT/;", "t/net/config.pl";
    }

    #expand ./t to full path
    system $^X, "-pi~", "-e", 
    "s: \./t(\S*): $PWD/t\$1:", "t/conf/httpd.conf";

    for (qw(User Group)) {
	system $^X, "-pi~", "-e", "s/^$_ .*/$_ $$_/", "t/conf/httpd.conf";
    }
    if($IsBenSSL) {
	local *CONF;
	open CONF, ">>t/conf/httpd.conf" or die $!;
	print CONF "SSLDisable\n";
	close CONF;
    }
}


# writing Configuration to Apache::MyConfig

open FH, '>lib/Apache/MyConfig.pm'  ||
    die "Can't open lib/Apache/MyConfig.pm: $!";
print FH <<EOT;
#
# Configuartion for mod_perl and Apache::...
#
package Apache::MyConfig ;

%Setup = (
   'Apache_Src' => \'$APACHE_SRC\'
);

1;

__END__
EOT
close FH;

#checking for LWP code, borrowed from LWP's own Makefile.PL :-)
print "Checking for LWP::UserAgent...";
eval {
    require LWP::UserAgent;
};
if ($@) {
    $no_lwp++;
    $missing_modules++;
    print "failed\n";
    print <<EOT;
$@
The libwww-perl library is needed to run the test suite.
Installation of this library is recommended, but not required.   

EOT
    sleep(2);  # Don't hurry too much
} else {
    print "ok\n";
}

eval {
    require CGI;
};
if ($@) {

}
else {
    print "Checking CGI.pm VERSION.......";
    if($CGI::VERSION >= 2.35) {
	print "ok\n";
    }
    else {
	print "not ok\n";
	print "you need to upgrade CGI.pm from $CGI::VERSION to 2.35 or higher\n";
	sleep(10);
    }
}

print <<EOT if $missing_modules;
The missing modules can be obtained from CPAN.  Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.

EOT

sub is_ssl {
    for (qw(apache_ssl.c mod_ssl.h)) {
	return 1 if -e "$APACHE_SRC/$_";
    }
    return 0;
}
  
sub write_extra_tests {
    return unless 
	$callback_hooks{PERL_STACKED_HANDLERS} 
    and $callback_hooks{PERL_FIXUP};
    local *FH;
    my $meth_test;
    if($callback_hooks{PERL_METHOD_HANDLERS}) {
	$meth_test = <<'EOF';
#see startup.pl
PerlFixupHandler MyClass->method 
PerlFixupHandler MyClass 
PerlFixupHandler LoadClass
PerlFixupHandler LoadClass->method
EOF
    }
    my $dir = "t/docs/stacked";
    mkdir $dir, 0755;
    cp "t/docs/test.html", $dir;
    open FH, ">$dir/.htaccess";
    print FH <<EOF;
    $meth_test
PerlFixupHandler  OK DECLINED MyClass::method
EOF
        close FH;
}

print "Ignore warnings about Constants.xs and Apache.xs\n" if $STATIC;
WriteMakefile(
    NAME    => "mod_perl",
    VERSION => $VERSION,
    #should override `CCFLAGS', can't with older perls
    #CCDLFLAGS => "$Config{ccdlflags} $EXTRA_CFLAGS", 
    DEFINE => $EXTRA_CFLAGS, 
    macro   => {
        APACHE_SRC => $APACHE_SRC,
	ARCHNAME => $Config{archname},
	PERL_VERSION => $]+0,
	HTTPD => $IsBenSSL ? "httpsd" : "httpd",
	PORT => $PORT,
    },
    dist    => {
	COMPRESS=> 'gzip -9f', SUFFIX=>'gz', 
	DIST_DEFAULT => 'all tardist',
#	POSTOP => 'mv $(DISTNAME)-*.tar.gz ../'
	},
    clean   => {
	FILES	=> "@do_clean",
    }
);

cleanup_for_static() if $STATIC;

sub MY::clean {
    my $self = shift;
    my $string = $self->MM::clean;
    return $string if $NO_HTTPD;
    return $string unless $APACHE_SRC and -e "$APACHE_SRC/http_main.c";
    $string .= "\t-cd \$(APACHE_SRC) && \$(MAKE) clean\n";
    $string;
}

sub MY::top_targets {
    my $self = shift;
    my $string = $self->MM::top_targets;
    return $string unless $APACHE_SRC;
    if(-e "$APACHE_SRC/http_main.c" and !$NO_HTTPD) {
        $string =~ s/(pure_all\s+::\s+)(.*)/$1 apache_httpd $2/;
    }
    $string .= <<'EOF';

apache_httpd: $(APACHE_SRC)/Configuration	
	(cd $(APACHE_SRC) && $(MAKE) CC="$(CC)";)

tar_Apache:
	(cd $(INSTALLSITELIB); \
	     $(TAR) -cf Apache.tar Apache.pm Apache/ $(ARCHNAME)/auto/Apache; )
	$(MV) $(INSTALLSITELIB)/Apache.tar .

offsite-tar:
	$(CP) MANIFEST MANIFEST.orig
	$(PERL) -e 'for (<$(APACHE_SRC)/*.h>) {' \
	-e 'system "$(CP) $$_ src/";' \
	-e 's,^$(APACHE_SRC),,;' \
	-e 'system "echo src$$_ >> MANIFEST";' \
	-e '}' 
	$(MAKE) dist
	$(RM_F) src/*.h
	$(MV) MANIFEST.orig MANIFEST

EOF

    $string;
}

sub MY::pasthru {
    return unless $APACHE_SRC;
    my $self = shift;
    chomp(my $str = $self->MM::pasthru);
    join $/, "$str\\", 
    "\t".'APACHE_SRC="$(APACHE_SRC)"\\', 
    "\t".'DEFINE="$(DEFINE)"', 
    "";   
}

sub MY::test {
    join '', @test_pre_init,
    q(
TEST_VERBOSE=0

kill_httpd:
	kill `cat /tmp/mod_perl_httpd.pid`
	@$(RM_F) /tmp/mod_perl_srm.conf
	$(RM_F) /tmp/mod_perl_httpd.pid
	$(RM_F) /tmp/mod_perl_error_log

start_httpd: test_pre_init
	@(cd t/conf; test -f httpd.conf || cp httpd.conf-dist httpd.conf)
	@(cd t/net; test -f config.pl || cp config.pl.dist config.pl)
	@$(TOUCH) /tmp/mod_perl_srm.conf
	$(APACHE_SRC)/$(HTTPD) -X -d `pwd`/t & 
	@echo httpd listening on port $(PORT)
	@echo will write error_log to: /tmp/mod_perl_error_log

run_tests:
	$(FULLPERL) t/TEST $(TEST_VERBOSE)

test:	start_httpd run_tests kill_httpd

);
}

sub httpd_version {
    my($dir) = @_;
    my $fh = new FileHandle "$dir/httpd.h" or return;
    my($server, $version, $rest);
    my($fserver, $fversion, $frest);
    my($string, $extra, @vers);
    while(<$fh>) {
	next unless s/^#define\s+SERVER_(BASE|)VERSION\s+"(.*)\s*".*/$2/;
	chomp($string = $_);

	#print STDERR "Examining SERVER_VERSION '$string'...";
	#could be something like:
	#Stronghold-1.4b1-dev Ben-SSL/1.3 Apache/1.1.1 
	@vers = split /\s+/, $string;
	foreach (@vers) {
	    next unless ($fserver,$fversion,$frest) =  
		m,^([^/]+)/(\d\.\d+\.?\d*)([^ ]*),i;
	    #print STDERR "match ($fserver,$fversion,$frest)\n";  
	    if($fserver eq "Ben-SSL") {
		$extra = $fserver;
		print STDERR "I see $fserver/$fversion, ok\n";
		next;
	    }

	    if($fserver eq "Apache") {
		($server, $version) = ($fserver, $fversion);
		if($version == 1.2 and $frest =~ s/^b(\d+).*/$1/) {
		    if($frest < 6) {
			warn "Apache/1.2b$frest is not supported, skipping.\n";
			return undef;
		    }
		    ++$can_dash_make{$dir} if $frest >= 3;
		    ++$do_b8_chop if($frest == 8);
		    if($frest >= 8) {
			#warn "Don't need our own Makefile.tmpl (b$frest)!\n";
			return "NONE";
		    }
		}
		elsif($version >= 1.2) {
		    $can_dash_make{$dir}++;
		    return "NONE";
		}
	    }
	    else {
		#print STDERR "'$fserver/$fversion' unrecognized.\n";
		next;
	    }

	    if("$version$rest" eq "1.2-dev") {
		print STDERR "Apache/1.2-dev not supported, upgrade to 1.2bX\n";
		next;
	    }

	    print STDERR "Found $fserver '$fversion' in $dir/httpd.h\n";
	}
    }
    $fh->close;
    #print STDERR "return $version$extra\n";
    return($version.$extra);
}

sub cleanup_for_static {
    for (qw(Apache Constants)) {
	rename "${_}/${_}.xs.disabled", "${_}/${_}.xs";
    }
}

sub setup_for_static {
    my $d = "$APACHE_SRC/modules/perl";
    cp "Apache/typemap", $d;

    for (qw(Apache Constants)) {
	cp "${_}/${_}.xs", $d;
	rename "${_}/${_}.xs", "${_}/${_}.xs.disabled";
    }

    system $^X, "-pi~", "-e", 
    "s/^#STATIC_/STATIC_/",
    "$APACHE_SRC/modules/perl/Makefile";
}

sub readline_setup {
    eval 'use Term::ReadLine' ;

    if ($@ eq '') {
	my $term = new Term::ReadLine 'mod_perl install';
	
	eval {
	    sub main::_prompt {
		my ($prompt, $default) = @_ ;
		
		$_ = $term -> readline ("$prompt [$default] ") ;
		if (!/^\s*$/) {
		    s/\s+$//;
		    return $_ ;
		}
		else {
		    if ($_ eq "") {
			return $default ;
		    }
		    else {
			return "" ; 
		    }
		}
	    }
        };
	die $@ if $@;
	print "ReadLine support enabled\n" ;
    }
    else { 
	eval <<'EOT' ;
    
	sub main::_prompt {
	    prompt(@_);
	}
EOT
    }
}
    
