package Locales::DB::Language::uk;

# Auto generated from CLDR

$Locales::DB::Language::uk::VERSION = '0.02';

$Locales::DB::Language::uk::cldr_version = '1.7.1';

%Locales::DB::Language::uk::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Мова\ з\ кодом\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Територія\ з\ кодом\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ні\:н",
        'yesstr' => "так\:т"
    },
);

%Locales::DB::Language::uk::code_to_name = (
    'aa'    => 'афарська',
    'ab'    => 'абхазька',
    'ace'   => 'ачехська',
    'ach'   => 'ачолі',
    'ada'   => 'адангме',
    'ady'   => 'адигейська',
    'ae'    => 'авестійська',
    'af'    => 'африкаанс',
    'afa'   => "афро\-азійська\ мова",
    'afh'   => 'африхілі',
    'ain'   => 'айнська',
    'ak'    => 'акан',
    'akk'   => 'аккадська',
    'ale'   => 'алеутська',
    'alg'   => "алгонкінські\ мови",
    'alt'   => 'південноалтайська',
    'am'    => 'амхарська',
    'an'    => 'арагонська',
    'ang'   => 'давньоанглійська',
    'anp'   => 'ангіка',
    'apa'   => "апачі\ мови",
    'ar'    => 'арабська',
    'arc'   => 'арамейська',
    'arn'   => 'арауканська',
    'arp'   => 'арапахо',
    'art'   => "штучна\ мова",
    'arw'   => 'аравакська',
    'as'    => 'ассамська',
    'ast'   => 'астурська',
    'ath'   => "атапаскські\ мови",
    'aus'   => "австралійські\ мови",
    'av'    => 'аварська',
    'awa'   => 'авадхі',
    'ay'    => 'аймара',
    'az'    => 'азербайджанська',
    'ba'    => 'башкирська',
    'bad'   => 'банда',
    'bai'   => "бамілеке\ мови",
    'bal'   => 'балучі',
    'ban'   => 'балійська',
    'bas'   => 'баса',
    'bat'   => "балтійська\ мова",
    'be'    => 'білоруська',
    'bej'   => 'беджа',
    'bem'   => 'бемба',
    'ber'   => 'берберська',
    'bg'    => 'болгарська',
    'bh'    => 'біхарі',
    'bho'   => 'бходжпурі',
    'bi'    => 'біслама',
    'bik'   => 'бікольська',
    'bin'   => 'біні',
    'bla'   => 'сіксіка',
    'bm'    => 'бамбара',
    'bn'    => 'бенгальська',
    'bnt'   => 'банту',
    'bo'    => 'тибетська',
    'br'    => 'бретонська',
    'bra'   => 'брадж',
    'bs'    => 'боснійська',
    'btk'   => 'батак',
    'bua'   => 'бурятська',
    'bug'   => 'бугійська',
    'byn'   => 'блін',
    'ca'    => 'каталонська',
    'cad'   => 'каддо',
    'cai'   => "центральноамериканьских\ індіанців\ мова",
    'car'   => 'карібська',
    'cau'   => "кавказька\ мова",
    'cch'   => 'атсам',
    'ce'    => 'чеченська',
    'ceb'   => 'себуанська',
    'cel'   => "кельтська\ мова",
    'ch'    => 'чаморро',
    'chb'   => 'чібча',
    'chg'   => 'чагатайська',
    'chk'   => 'чуукська',
    'chm'   => 'марійська',
    'chn'   => "чинук\ жаргон",
    'cho'   => 'чокто',
    'chp'   => 'чіпев’ян',
    'chr'   => 'черокі',
    'chy'   => 'чейєнн',
    'cmc'   => "хамітські\ мови",
    'co'    => 'корсиканська',
    'cop'   => 'коптська',
    'cpe'   => "англо\-креольські\ та\ піджінізовані\ англійські\ мови",
    'cpf'   => "франко\-креольські\ та\ піджінізовані\ франкофонні\ мови",
    'cpp'   => "португальсько\-креольські\ та\ піджінізовані\ португальські\ мови",
    'cr'    => 'крі',
    'crh'   => 'кримськотатарська',
    'crp'   => "креольські\ та\ піджінізовані\ мови",
    'cs'    => 'чеська',
    'csb'   => 'кашубська',
    'cu'    => 'церковнослов’янська',
    'cus'   => "кушітська\ мова",
    'cv'    => 'чуваська',
    'cy'    => 'валлійська',
    'da'    => 'данська',
    'dak'   => 'дакота',
    'dar'   => 'даргінська',
    'day'   => 'даяк',
    'de'    => 'німецька',
    'de_at' => "німецька\ австрійська",
    'de_ch' => "верхньонімецька\ швейцарська",
    'del'   => 'делаварська',
    'den'   => 'слейв',
    'dgr'   => 'догрибська',
    'din'   => 'дінка',
    'doi'   => 'догрі',
    'dra'   => "дравідійська\ мова",
    'dsb'   => 'нижньолужицька',
    'dua'   => 'дуала',
    'dum'   => 'середньонідерландська',
    'dv'    => 'дівехі',
    'dyu'   => 'діула',
    'dz'    => "дзонг\-ке",
    'ee'    => 'еве',
    'efi'   => 'ефік',
    'egy'   => 'давньоєгипетська',
    'eka'   => 'екаджук',
    'el'    => 'грецька',
    'elx'   => 'еламська',
    'en'    => 'англійська',
    'en_au' => "англійська\ австралійська",
    'en_ca' => "англійська\ канадська",
    'en_gb' => "англійська\ британська",
    'en_us' => "англійська\ США",
    'enm'   => 'середньоанглійська',
    'eo'    => 'есперанто',
    'es'    => 'іспанська',
    'es_es' => "іберійська\ іспанська",
    'et'    => 'естонська',
    'eu'    => 'басків',
    'ewo'   => 'евондо',
    'fa'    => 'перська',
    'fan'   => 'фанг',
    'fat'   => 'фанті',
    'ff'    => 'фула',
    'fi'    => 'фінська',
    'fil'   => 'філіппінська',
    'fiu'   => "фінно\-угорські\ мови",
    'fj'    => 'фіджі',
    'fo'    => 'фарерська',
    'fon'   => 'фон',
    'fr'    => 'французька',
    'fr_ca' => "французька\ канадська",
    'fr_ch' => "французька\ швейцарська",
    'frm'   => 'середньофранцузька',
    'fro'   => 'давньофранцузька',
    'frr'   => "фризька\ північна",
    'frs'   => "фризька\ східна",
    'fur'   => 'фріульська',
    'fy'    => 'фризька',
    'ga'    => 'ірландська',
    'gaa'   => 'га',
    'gay'   => 'гайо',
    'gba'   => 'гбайя',
    'gd'    => 'гаельська',
    'gem'   => "германська\ мова",
    'gez'   => 'гєез',
    'gil'   => 'гільбертська',
    'gl'    => 'галісійська',
    'gmh'   => 'середньоверхньонімецька',
    'gn'    => 'гуарані',
    'goh'   => 'давньоверхньонімецька',
    'gon'   => 'гонді',
    'gor'   => 'горонтало',
    'got'   => 'готська',
    'grb'   => 'гребо',
    'grc'   => 'давньогрецька',
    'gsw'   => "німецька\ швейцарська",
    'gu'    => 'гуджараті',
    'gv'    => 'менкська',
    'gwi'   => 'кучін',
    'ha'    => 'хауса',
    'hai'   => 'хайда',
    'haw'   => 'гавайська',
    'he'    => 'іврит',
    'hi'    => 'гінді',
    'hil'   => 'хілігайнон',
    'him'   => 'хімачалі',
    'hit'   => 'хітіті',
    'hmn'   => 'хмонг',
    'ho'    => "хірі\-моту",
    'hr'    => 'хорватська',
    'hsb'   => 'верхньолужицька',
    'ht'    => 'гаїтянська',
    'hu'    => 'угорська',
    'hup'   => 'хупа',
    'hy'    => 'вірменська',
    'hz'    => 'гереро',
    'ia'    => 'інтерлінгва',
    'iba'   => 'ібанська',
    'id'    => 'індонезійська',
    'ie'    => 'інтерлінгве',
    'ig'    => 'ігбо',
    'ii'    => 'сичуань',
    'ijo'   => 'іджо',
    'ik'    => 'інупіак',
    'ilo'   => 'ілоканська',
    'inc'   => "індійські\ мови",
    'ine'   => "індоєвропейські\ мови",
    'inh'   => 'інгуська',
    'io'    => 'ідо',
    'ira'   => 'іранська',
    'iro'   => "ірокезькі\ мови",
    'is'    => 'ісландська',
    'it'    => 'італійська',
    'iu'    => 'інуктітут',
    'ja'    => 'японська',
    'jbo'   => 'ложбан',
    'jpr'   => "іудео\-перська",
    'jrb'   => "іудео\-арабська",
    'jv'    => 'яванська',
    'ka'    => 'грузинська',
    'kaa'   => 'каракалпацька',
    'kab'   => 'кабильська',
    'kac'   => 'качін',
    'kaj'   => 'йю',
    'kam'   => 'камба',
    'kar'   => 'каренська',
    'kaw'   => 'каві',
    'kbd'   => 'кабардинська',
    'kcg'   => 'тіап',
    'kfo'   => 'коро',
    'kg'    => 'конґолезька',
    'kha'   => 'кхасі',
    'khi'   => "койсанські\ мови",
    'kho'   => 'хотаносакська',
    'ki'    => 'кікуйю',
    'kj'    => 'кунама',
    'kk'    => 'казахська',
    'kl'    => 'калааллісут',
    'km'    => 'кхмерська',
    'kmb'   => 'кімбунду',
    'kn'    => 'каннада',
    'ko'    => 'корейська',
    'kok'   => 'конкані',
    'kos'   => 'косрае',
    'kpe'   => 'кпеллє',
    'kr'    => 'канурі',
    'krc'   => "карачаєво\-балкарська",
    'krl'   => 'карельська',
    'kro'   => 'кру',
    'kru'   => 'курукх',
    'ks'    => 'кашмірська',
    'ku'    => 'курдська',
    'kum'   => 'кумицька',
    'kut'   => 'кутенаї',
    'kv'    => 'комі',
    'kw'    => 'корнійська',
    'ky'    => 'киргизька',
    'la'    => 'латинська',
    'lad'   => 'ладіно',
    'lah'   => 'ланда',
    'lam'   => 'ламба',
    'lb'    => 'люксембурзька',
    'lez'   => 'лезгінська',
    'lg'    => 'ганда',
    'li'    => 'лімбургійська',
    'ln'    => 'лінгала',
    'lo'    => 'лаоська',
    'lol'   => 'монго',
    'loz'   => 'лозі',
    'lt'    => 'литовська',
    'lu'    => "луба\-катанга",
    'lua'   => "луба\-лулуа",
    'lui'   => 'луїсеньо',
    'lun'   => 'лунда',
    'luo'   => 'луо',
    'lus'   => 'лушей',
    'lv'    => 'латвійська',
    'mad'   => 'мадурська',
    'mag'   => 'магадхі',
    'mai'   => 'майтхілі',
    'mak'   => 'макасарська',
    'man'   => 'мандінго',
    'map'   => "австронезійська\ мова",
    'mas'   => 'масаї',
    'mdf'   => 'мокша',
    'mdr'   => 'мандарська',
    'men'   => 'менде',
    'mfe'   => 'Morisyen',
    'mg'    => 'малагасійська',
    'mga'   => 'середньоірландська',
    'mh'    => 'маршалльська',
    'mi'    => 'маорі',
    'mic'   => 'мікмак',
    'min'   => 'мінангкабау',
    'mis'   => "інші\ мови",
    'mk'    => 'македонська',
    'mkh'   => "мон\-кхмерські\ мови",
    'ml'    => 'малайялам',
    'mn'    => 'монгольська',
    'mnc'   => 'манчжурська',
    'mni'   => 'маніпурі',
    'mno'   => "манобо\ мови",
    'mo'    => 'молдавська',
    'moh'   => 'магавк',
    'mos'   => 'моссі',
    'mr'    => 'маратхі',
    'ms'    => 'малайська',
    'mt'    => 'мальтійська',
    'mul'   => "декілька\ мов",
    'mun'   => "мунда\ мови",
    'mus'   => 'крік',
    'mwl'   => 'мірандська',
    'mwr'   => 'марварі',
    'my'    => 'бірманська',
    'myn'   => "майя\ мови",
    'myv'   => 'ерзя',
    'na'    => 'науру',
    'nah'   => 'нахуатль',
    'nai'   => "північноамериканських\ індіанців\ мови",
    'nap'   => 'неаполітанська',
    'nb'    => "норвезька\ букмол",
    'nd'    => "ндебелє\ північна",
    'nds'   => 'нижньонімецька',
    'ne'    => 'непальська',
    'new'   => 'неварі',
    'ng'    => 'ндонга',
    'nia'   => 'ніаська',
    'nic'   => "ніґеро\-кордофанські\ мови",
    'niu'   => 'ніуе',
    'nl'    => 'голландська',
    'nl_be' => 'фламандська',
    'nn'    => "норвезька\ нюнорськ",
    'no'    => 'норвезька',
    'nog'   => 'ногайська',
    'non'   => 'давньонорвезька',
    'nqo'   => 'нко',
    'nr'    => "ндебелє\ південна",
    'nso'   => "сото\ північна",
    'nub'   => "нубійські\ мови",
    'nv'    => 'навахо',
    'nwc'   => "неварі\ класична",
    'ny'    => 'ньянджа',
    'nym'   => 'ньямвезі',
    'nyn'   => 'ньянколе',
    'nyo'   => 'ньоро',
    'nzi'   => 'нзіма',
    'oc'    => 'окитан',
    'oj'    => 'оджібва',
    'om'    => 'оромо',
    'or'    => 'орія',
    'os'    => 'осетинська',
    'osa'   => 'осейдж',
    'ota'   => 'османська',
    'oto'   => "отомі\ мови",
    'pa'    => 'панджабі',
    'paa'   => "папуаські\ мови",
    'pag'   => 'пангасінанська',
    'pal'   => 'пехлеві',
    'pam'   => 'пампанга',
    'pap'   => 'пап’яменто',
    'pau'   => 'палауанська',
    'peo'   => 'давньоперська',
    'phi'   => "філіппінські\ мови",
    'phn'   => "фінікійсько\-пунічна",
    'pi'    => 'палі',
    'pl'    => 'польська',
    'pon'   => 'понапе',
    'pra'   => "пракріті\ мови",
    'pro'   => 'давньопровансальська',
    'ps'    => 'пушту',
    'pt'    => 'португальська',
    'pt_br' => "португальська\ бразильська",
    'pt_pt' => "португальська\ іберійська",
    'qu'    => 'кечуа',
    'raj'   => 'раджастхані',
    'rap'   => 'рапануї',
    'rar'   => 'раротонга',
    'rm'    => 'ретороманська',
    'rn'    => 'рунді',
    'ro'    => 'румунська',
    'roa'   => "романські\ мови",
    'rom'   => 'циганська',
    'ru'    => 'російська',
    'rup'   => 'арумунська',
    'rw'    => 'кіньяруанда',
    'sa'    => 'санскрит',
    'sad'   => 'сандаве',
    'sah'   => 'якутська',
    'sai'   => "південноамериканських\ індіанців\ мови",
    'sal'   => "салішські\ мови",
    'sam'   => "самаритянська\ арамейська",
    'sas'   => 'сасакська',
    'sat'   => 'сантальська',
    'sc'    => 'сардинська',
    'scn'   => 'сицилійська',
    'sco'   => 'шотландська',
    'sd'    => 'сіндхі',
    'se'    => "саамська\ північна",
    'sel'   => 'селькупська',
    'sem'   => "семітські\ мови",
    'sg'    => 'санго',
    'sga'   => 'давньоірландська',
    'sgn'   => "знакові\ мови",
    'sh'    => "сербсько\-хорватська",
    'shn'   => 'шанська',
    'si'    => 'сингальська',
    'sid'   => 'сідамо',
    'sio'   => "сіу\ мови",
    'sit'   => "китайсько\-тибетські\ мови",
    'sk'    => 'словацька',
    'sl'    => 'словенська',
    'sla'   => "слов’янські\ мови",
    'sm'    => 'самоанська',
    'sma'   => "саамська\ південна",
    'smi'   => "саамські\ мови",
    'smj'   => "саамська\ луле",
    'smn'   => "саамська\ інарі",
    'sms'   => "саамська\ скольт",
    'sn'    => 'шона',
    'snk'   => 'сонінке',
    'so'    => 'сомалі',
    'sog'   => 'согдійська',
    'son'   => 'сонгай',
    'sq'    => 'албанська',
    'sr'    => 'сербська',
    'srn'   => "сранан\ тонго",
    'srr'   => 'серер',
    'ss'    => 'сісваті',
    'ssa'   => "ніло\-сахарські\ мови",
    'st'    => "сото\ південна",
    'su'    => 'сунданська',
    'suk'   => 'сукума',
    'sus'   => 'сусу',
    'sux'   => 'шумерська',
    'sv'    => 'шведська',
    'sw'    => 'суахілі',
    'syc'   => "сирійська\ класична",
    'syr'   => 'сирійська',
    'ta'    => 'тамільська',
    'tai'   => "тайські\ мови",
    'te'    => 'телугу',
    'tem'   => 'темне',
    'ter'   => 'терено',
    'tet'   => 'тетум',
    'tg'    => 'таджицька',
    'th'    => 'тайська',
    'ti'    => 'тигріні',
    'tig'   => 'тигре',
    'tiv'   => 'тів',
    'tk'    => 'туркменська',
    'tkl'   => 'токелау',
    'tl'    => 'тагальська',
    'tlh'   => 'клінгон',
    'tli'   => 'тлінгіт',
    'tmh'   => 'тамашек',
    'tn'    => 'тсвана',
    'to'    => 'Тонга',
    'tog'   => "ньяса\ тонга",
    'tpi'   => "ток\-пісін",
    'tr'    => 'турецька',
    'trv'   => 'Taroko',
    'ts'    => 'тсонга',
    'tsi'   => 'цимшиан',
    'tt'    => 'татарська',
    'tum'   => 'тумбука',
    'tup'   => 'тупі',
    'tut'   => "алтайська\ мова",
    'tvl'   => 'тувалу',
    'tw'    => 'тві',
    'ty'    => 'таїтянська',
    'tyv'   => 'тувинська',
    'udm'   => 'удмуртська',
    'ug'    => 'уйгурська',
    'uga'   => 'угаритська',
    'uk'    => 'українська',
    'umb'   => 'умбунду',
    'und'   => "невизначена\ мова",
    'ur'    => 'урду',
    'uz'    => 'узбецька',
    'vai'   => 'ваї',
    've'    => 'венда',
    'vi'    => 'вʼєтнамська',
    'vo'    => 'волап’юк',
    'vot'   => 'водська',
    'wa'    => 'валлонська',
    'wak'   => "вакашські\ мови",
    'wal'   => 'валамо',
    'war'   => 'варай',
    'was'   => 'вашо',
    'wen'   => "лужицькі\ мови",
    'wo'    => 'волоф',
    'xal'   => 'калмицька',
    'xh'    => 'кхоса',
    'yao'   => 'яо',
    'yap'   => 'яп',
    'yi'    => 'ідиш',
    'yo'    => 'йоруба',
    'ypk'   => "юпік\ мови",
    'za'    => 'чжуан',
    'zap'   => 'сапотекська',
    'zbl'   => "блісса\ мова",
    'zen'   => 'зенага',
    'zh'    => 'китайська',
    'znd'   => 'занде',
    'zu'    => 'зулуська',
    'zun'   => 'зуньї',
    'zxx'   => "немає\ мовного\ вмісту",
    'zza'   => 'зазакі',
);

%Locales::DB::Language::uk::name_to_code = (
    'morisyen'                                                                                                       => 'mfe',
    'taroko'                                                                                                         => 'trv',
    'Тонга'                                                                                                     => 'to',
    'абхазька'                                                                                               => 'ab',
    'авадхі'                                                                                                   => 'awa',
    'аварська'                                                                                               => 'av',
    'авестійська'                                                                                         => 'ae',
    'австралійськімови'                                                                             => 'aus',
    'австронезійськамова'                                                                         => 'map',
    'адангме'                                                                                                 => 'ada',
    'адигейська'                                                                                           => 'ady',
    'азербайджанська'                                                                                 => 'az',
    'аймара'                                                                                                   => 'ay',
    'айнська'                                                                                                 => 'ain',
    'акан'                                                                                                       => 'ak',
    'аккадська'                                                                                             => 'akk',
    'албанська'                                                                                             => 'sq',
    'алгонкінськімови'                                                                               => 'alg',
    'алеутська'                                                                                             => 'ale',
    'алтайськамова'                                                                                     => 'tut',
    'амхарська'                                                                                             => 'am',
    'англокреольськітапіджінізованіанглійськімови'                       => 'cpe',
    'англійська'                                                                                           => 'en',
    'англійськаСША'                                                                                     => 'en_us',
    'англійськаавстралійська'                                                                 => 'en_au',
    'англійськабританська'                                                                       => 'en_gb',
    'англійськаканадська'                                                                         => 'en_ca',
    'ангіка'                                                                                                   => 'anp',
    'апачімови'                                                                                             => 'apa',
    'арабська'                                                                                               => 'ar',
    'аравакська'                                                                                           => 'arw',
    'арагонська'                                                                                           => 'an',
    'арамейська'                                                                                           => 'arc',
    'арапахо'                                                                                                 => 'arp',
    'арауканська'                                                                                         => 'arn',
    'арумунська'                                                                                           => 'rup',
    'ассамська'                                                                                             => 'as',
    'астурська'                                                                                             => 'ast',
    'атапаскськімови'                                                                                 => 'ath',
    'атсам'                                                                                                     => 'cch',
    'афарська'                                                                                               => 'aa',
    'африкаанс'                                                                                             => 'af',
    'африхілі'                                                                                               => 'afh',
    'афроазійськамова'                                                                               => 'afa',
    'ачехська'                                                                                               => 'ace',
    'ачолі'                                                                                                     => 'ach',
    'балтійськамова'                                                                                   => 'bat',
    'балучі'                                                                                                   => 'bal',
    'балійська'                                                                                             => 'ban',
    'бамбара'                                                                                                 => 'bm',
    'бамілекемови'                                                                                       => 'bai',
    'банда'                                                                                                     => 'bad',
    'банту'                                                                                                     => 'bnt',
    'баса'                                                                                                       => 'bas',
    'басків'                                                                                                   => 'eu',
    'батак'                                                                                                     => 'btk',
    'башкирська'                                                                                           => 'ba',
    'беджа'                                                                                                     => 'bej',
    'бемба'                                                                                                     => 'bem',
    'бенгальська'                                                                                         => 'bn',
    'берберська'                                                                                           => 'ber',
    'блін'                                                                                                       => 'byn',
    'бліссамова'                                                                                           => 'zbl',
    'болгарська'                                                                                           => 'bg',
    'боснійська'                                                                                           => 'bs',
    'брадж'                                                                                                     => 'bra',
    'бретонська'                                                                                           => 'br',
    'бугійська'                                                                                             => 'bug',
    'бурятська'                                                                                             => 'bua',
    'бходжпурі'                                                                                             => 'bho',
    'бікольська'                                                                                           => 'bik',
    'білоруська'                                                                                           => 'be',
    'біні'                                                                                                       => 'bin',
    'бірманська'                                                                                           => 'my',
    'біслама'                                                                                                 => 'bi',
    'біхарі'                                                                                                   => 'bh',
    'вʼєтнамська'                                                                                         => 'vi',
    'вакашськімови'                                                                                     => 'wak',
    'валамо'                                                                                                   => 'wal',
    'валлонська'                                                                                           => 'wa',
    'валлійська'                                                                                           => 'cy',
    'варай'                                                                                                     => 'war',
    'вашо'                                                                                                       => 'was',
    'ваї'                                                                                                         => 'vai',
    'венда'                                                                                                     => 've',
    'верхньолужицька'                                                                                 => 'hsb',
    'верхньонімецькашвейцарська'                                                           => 'de_ch',
    'водська'                                                                                                 => 'vot',
    'волап’юк'                                                                                              => 'vo',
    'волоф'                                                                                                     => 'wo',
    'вірменська'                                                                                           => 'hy',
    'га'                                                                                                           => 'gaa',
    'гавайська'                                                                                             => 'haw',
    'гаельська'                                                                                             => 'gd',
    'гайо'                                                                                                       => 'gay',
    'галісійська'                                                                                         => 'gl',
    'ганда'                                                                                                     => 'lg',
    'гаїтянська'                                                                                           => 'ht',
    'гбайя'                                                                                                     => 'gba',
    'гереро'                                                                                                   => 'hz',
    'германськамова'                                                                                   => 'gem',
    'голландська'                                                                                         => 'nl',
    'гонді'                                                                                                     => 'gon',
    'горонтало'                                                                                             => 'gor',
    'готська'                                                                                                 => 'got',
    'гребо'                                                                                                     => 'grb',
    'грецька'                                                                                                 => 'el',
    'грузинська'                                                                                           => 'ka',
    'гуарані'                                                                                                 => 'gn',
    'гуджараті'                                                                                             => 'gu',
    'гєез'                                                                                                       => 'gez',
    'гільбертська'                                                                                       => 'gil',
    'гінді'                                                                                                     => 'hi',
    'давньоанглійська'                                                                               => 'ang',
    'давньоверхньонімецька'                                                                     => 'goh',
    'давньогрецька'                                                                                     => 'grc',
    'давньонорвезька'                                                                                 => 'non',
    'давньоперська'                                                                                     => 'peo',
    'давньопровансальська'                                                                       => 'pro',
    'давньофранцузька'                                                                               => 'fro',
    'давньоєгипетська'                                                                               => 'egy',
    'давньоірландська'                                                                               => 'sga',
    'дакота'                                                                                                   => 'dak',
    'данська'                                                                                                 => 'da',
    'даргінська'                                                                                           => 'dar',
    'даяк'                                                                                                       => 'day',
    'декількамов'                                                                                         => 'mul',
    'делаварська'                                                                                         => 'del',
    'дзонгке'                                                                                                 => 'dz',
    'догрибська'                                                                                           => 'dgr',
    'догрі'                                                                                                     => 'doi',
    'дравідійськамова'                                                                               => 'dra',
    'дуала'                                                                                                     => 'dua',
    'дівехі'                                                                                                   => 'dv',
    'дінка'                                                                                                     => 'din',
    'діула'                                                                                                     => 'dyu',
    'еве'                                                                                                         => 'ee',
    'евондо'                                                                                                   => 'ewo',
    'екаджук'                                                                                                 => 'eka',
    'еламська'                                                                                               => 'elx',
    'ерзя'                                                                                                       => 'myv',
    'есперанто'                                                                                             => 'eo',
    'естонська'                                                                                             => 'et',
    'ефік'                                                                                                       => 'efi',
    'зазакі'                                                                                                   => 'zza',
    'занде'                                                                                                     => 'znd',
    'зенага'                                                                                                   => 'zen',
    'знаковімови'                                                                                         => 'sgn',
    'зулуська'                                                                                               => 'zu',
    'зуньї'                                                                                                     => 'zun',
    'йоруба'                                                                                                   => 'yo',
    'йю'                                                                                                           => 'kaj',
    'кабардинська'                                                                                       => 'kbd',
    'кабильська'                                                                                           => 'kab',
    'кавказькамова'                                                                                     => 'cau',
    'каві'                                                                                                       => 'kaw',
    'каддо'                                                                                                     => 'cad',
    'казахська'                                                                                             => 'kk',
    'калааллісут'                                                                                         => 'kl',
    'калмицька'                                                                                             => 'xal',
    'камба'                                                                                                     => 'kam',
    'каннада'                                                                                                 => 'kn',
    'канурі'                                                                                                   => 'kr',
    'каракалпацька'                                                                                     => 'kaa',
    'карачаєвобалкарська'                                                                         => 'krc',
    'карельська'                                                                                           => 'krl',
    'каренська'                                                                                             => 'kar',
    'карібська'                                                                                             => 'car',
    'каталонська'                                                                                         => 'ca',
    'качін'                                                                                                     => 'kac',
    'кашмірська'                                                                                           => 'ks',
    'кашубська'                                                                                             => 'csb',
    'кельтськамова'                                                                                     => 'cel',
    'кечуа'                                                                                                     => 'qu',
    'киргизька'                                                                                             => 'ky',
    'китайська'                                                                                             => 'zh',
    'китайськотибетськімови'                                                                   => 'sit',
    'клінгон'                                                                                                 => 'tlh',
    'койсанськімови'                                                                                   => 'khi',
    'комі'                                                                                                       => 'kv',
    'конкані'                                                                                                 => 'kok',
    'конґолезька'                                                                                         => 'kg',
    'коптська'                                                                                               => 'cop',
    'корейська'                                                                                             => 'ko',
    'корнійська'                                                                                           => 'kw',
    'коро'                                                                                                       => 'kfo',
    'корсиканська'                                                                                       => 'co',
    'косрае'                                                                                                   => 'kos',
    'кпеллє'                                                                                                   => 'kpe',
    'креольськітапіджінізованімови'                                                     => 'crp',
    'кримськотатарська'                                                                             => 'crh',
    'кру'                                                                                                         => 'kro',
    'крі'                                                                                                         => 'cr',
    'крік'                                                                                                       => 'mus',
    'кумицька'                                                                                               => 'kum',
    'кунама'                                                                                                   => 'kj',
    'курдська'                                                                                               => 'ku',
    'курукх'                                                                                                   => 'kru',
    'кутенаї'                                                                                                 => 'kut',
    'кучін'                                                                                                     => 'gwi',
    'кушітськамова'                                                                                     => 'cus',
    'кхасі'                                                                                                     => 'kha',
    'кхмерська'                                                                                             => 'km',
    'кхоса'                                                                                                     => 'xh',
    'кікуйю'                                                                                                   => 'ki',
    'кімбунду'                                                                                               => 'kmb',
    'кіньяруанда'                                                                                         => 'rw',
    'ладіно'                                                                                                   => 'lad',
    'ламба'                                                                                                     => 'lam',
    'ланда'                                                                                                     => 'lah',
    'лаоська'                                                                                                 => 'lo',
    'латвійська'                                                                                           => 'lv',
    'латинська'                                                                                             => 'la',
    'лезгінська'                                                                                           => 'lez',
    'литовська'                                                                                             => 'lt',
    'ложбан'                                                                                                   => 'jbo',
    'лозі'                                                                                                       => 'loz',
    'лубакатанга'                                                                                         => 'lu',
    'лубалулуа'                                                                                             => 'lua',
    'лужицькімови'                                                                                       => 'wen',
    'лунда'                                                                                                     => 'lun',
    'луо'                                                                                                         => 'luo',
    'лушей'                                                                                                     => 'lus',
    'луїсеньо'                                                                                               => 'lui',
    'люксембурзька'                                                                                     => 'lb',
    'лімбургійська'                                                                                     => 'li',
    'лінгала'                                                                                                 => 'ln',
    'магавк'                                                                                                   => 'moh',
    'магадхі'                                                                                                 => 'mag',
    'мадурська'                                                                                             => 'mad',
    'майтхілі'                                                                                               => 'mai',
    'майямови'                                                                                               => 'myn',
    'макасарська'                                                                                         => 'mak',
    'македонська'                                                                                         => 'mk',
    'малагасійська'                                                                                     => 'mg',
    'малайська'                                                                                             => 'ms',
    'малайялам'                                                                                             => 'ml',
    'мальтійська'                                                                                         => 'mt',
    'мандарська'                                                                                           => 'mdr',
    'мандінго'                                                                                               => 'man',
    'манобомови'                                                                                           => 'mno',
    'манчжурська'                                                                                         => 'mnc',
    'маніпурі'                                                                                               => 'mni',
    'маорі'                                                                                                     => 'mi',
    'маратхі'                                                                                                 => 'mr',
    'марварі'                                                                                                 => 'mwr',
    'маршалльська'                                                                                       => 'mh',
    'марійська'                                                                                             => 'chm',
    'масаї'                                                                                                     => 'mas',
    'менде'                                                                                                     => 'men',
    'менкська'                                                                                               => 'gv',
    'мокша'                                                                                                     => 'mdf',
    'молдавська'                                                                                           => 'mo',
    'монго'                                                                                                     => 'lol',
    'монгольська'                                                                                         => 'mn',
    'монкхмерськімови'                                                                               => 'mkh',
    'моссі'                                                                                                     => 'mos',
    'мундамови'                                                                                             => 'mun',
    'мікмак'                                                                                                   => 'mic',
    'мінангкабау'                                                                                         => 'min',
    'мірандська'                                                                                           => 'mwl',
    'навахо'                                                                                                   => 'nv',
    'науру'                                                                                                     => 'na',
    'нахуатль'                                                                                               => 'nah',
    'ндебелєпівденна'                                                                                 => 'nr',
    'ндебелєпівнічна'                                                                                 => 'nd',
    'ндонга'                                                                                                   => 'ng',
    'неаполітанська'                                                                                   => 'nap',
    'неварі'                                                                                                   => 'new',
    'неварікласична'                                                                                   => 'nwc',
    'невизначенамова'                                                                                 => 'und',
    'немаємовноговмісту'                                                                           => 'zxx',
    'непальська'                                                                                           => 'ne',
    'нзіма'                                                                                                     => 'nzi',
    'нижньолужицька'                                                                                   => 'dsb',
    'нижньонімецька'                                                                                   => 'nds',
    'нко'                                                                                                         => 'nqo',
    'ногайська'                                                                                             => 'nog',
    'норвезька'                                                                                             => 'no',
    'норвезькабукмол'                                                                                 => 'nb',
    'норвезьканюнорськ'                                                                             => 'nn',
    'нубійськімови'                                                                                     => 'nub',
    'ньоро'                                                                                                     => 'nyo',
    'ньямвезі'                                                                                               => 'nym',
    'ньянджа'                                                                                                 => 'ny',
    'ньянколе'                                                                                               => 'nyn',
    'ньясатонга'                                                                                           => 'tog',
    'ніаська'                                                                                                 => 'nia',
    'нілосахарськімови'                                                                             => 'ssa',
    'німецька'                                                                                               => 'de',
    'німецькаавстрійська'                                                                         => 'de_at',
    'німецькашвейцарська'                                                                         => 'gsw',
    'ніуе'                                                                                                       => 'niu',
    'ніґерокордофанськімови'                                                                   => 'nic',
    'оджібва'                                                                                                 => 'oj',
    'окитан'                                                                                                   => 'oc',
    'оромо'                                                                                                     => 'om',
    'орія'                                                                                                       => 'or',
    'осейдж'                                                                                                   => 'osa',
    'осетинська'                                                                                           => 'os',
    'османська'                                                                                             => 'ota',
    'отомімови'                                                                                             => 'oto',
    'палауанська'                                                                                         => 'pau',
    'палі'                                                                                                       => 'pi',
    'пампанга'                                                                                               => 'pam',
    'пангасінанська'                                                                                   => 'pag',
    'панджабі'                                                                                               => 'pa',
    'папуаськімови'                                                                                     => 'paa',
    'пап’яменто'                                                                                          => 'pap',
    'перська'                                                                                                 => 'fa',
    'пехлеві'                                                                                                 => 'pal',
    'польська'                                                                                               => 'pl',
    'понапе'                                                                                                   => 'pon',
    'португальська'                                                                                     => 'pt',
    'португальськабразильська'                                                               => 'pt_br',
    'португальськаіберійська'                                                                 => 'pt_pt',
    'португальськокреольськітапіджінізованіпортугальськімови' => 'cpp',
    'пракрітімови'                                                                                       => 'pra',
    'пушту'                                                                                                     => 'ps',
    'південноалтайська'                                                                             => 'alt',
    'південноамериканськихіндіанцівмови'                                           => 'sai',
    'північноамериканськихіндіанцівмови'                                           => 'nai',
    'раджастхані'                                                                                         => 'raj',
    'рапануї'                                                                                                 => 'rap',
    'раротонга'                                                                                             => 'rar',
    'ретороманська'                                                                                     => 'rm',
    'романськімови'                                                                                     => 'roa',
    'російська'                                                                                             => 'ru',
    'румунська'                                                                                             => 'ro',
    'рунді'                                                                                                     => 'rn',
    'саамськалуле'                                                                                       => 'smj',
    'саамськапівденна'                                                                               => 'sma',
    'саамськапівнічна'                                                                               => 'se',
    'саамськаскольт'                                                                                   => 'sms',
    'саамськаінарі'                                                                                     => 'smn',
    'саамськімови'                                                                                       => 'smi',
    'салішськімови'                                                                                     => 'sal',
    'самаритянськаарамейська'                                                                 => 'sam',
    'самоанська'                                                                                           => 'sm',
    'санго'                                                                                                     => 'sg',
    'сандаве'                                                                                                 => 'sad',
    'санскрит'                                                                                               => 'sa',
    'сантальська'                                                                                         => 'sat',
    'сапотекська'                                                                                         => 'zap',
    'сардинська'                                                                                           => 'sc',
    'сасакська'                                                                                             => 'sas',
    'себуанська'                                                                                           => 'ceb',
    'селькупська'                                                                                         => 'sel',
    'семітськімови'                                                                                     => 'sem',
    'сербська'                                                                                               => 'sr',
    'сербськохорватська'                                                                           => 'sh',
    'середньоанглійська'                                                                           => 'enm',
    'середньоверхньонімецька'                                                                 => 'gmh',
    'середньонідерландська'                                                                     => 'dum',
    'середньофранцузька'                                                                           => 'frm',
    'середньоірландська'                                                                           => 'mga',
    'серер'                                                                                                     => 'srr',
    'сингальська'                                                                                         => 'si',
    'сирійська'                                                                                             => 'syr',
    'сирійськакласична'                                                                             => 'syc',
    'сицилійська'                                                                                         => 'scn',
    'сичуань'                                                                                                 => 'ii',
    'слейв'                                                                                                     => 'den',
    'словацька'                                                                                             => 'sk',
    'словенська'                                                                                           => 'sl',
    'слов’янськімови'                                                                                => 'sla',
    'согдійська'                                                                                           => 'sog',
    'сомалі'                                                                                                   => 'so',
    'сонгай'                                                                                                   => 'son',
    'сонінке'                                                                                                 => 'snk',
    'сотопівденна'                                                                                       => 'st',
    'сотопівнічна'                                                                                       => 'nso',
    'сранантонго'                                                                                         => 'srn',
    'суахілі'                                                                                                 => 'sw',
    'сукума'                                                                                                   => 'suk',
    'сунданська'                                                                                           => 'su',
    'сусу'                                                                                                       => 'sus',
    'сідамо'                                                                                                   => 'sid',
    'сіксіка'                                                                                                 => 'bla',
    'сіндхі'                                                                                                   => 'sd',
    'сісваті'                                                                                                 => 'ss',
    'сіумови'                                                                                                 => 'sio',
    'тагальська'                                                                                           => 'tl',
    'таджицька'                                                                                             => 'tg',
    'тайська'                                                                                                 => 'th',
    'тайськімови'                                                                                         => 'tai',
    'тамашек'                                                                                                 => 'tmh',
    'тамільська'                                                                                           => 'ta',
    'татарська'                                                                                             => 'tt',
    'таїтянська'                                                                                           => 'ty',
    'тві'                                                                                                         => 'tw',
    'телугу'                                                                                                   => 'te',
    'темне'                                                                                                     => 'tem',
    'терено'                                                                                                   => 'ter',
    'тетум'                                                                                                     => 'tet',
    'тибетська'                                                                                             => 'bo',
    'тигре'                                                                                                     => 'tig',
    'тигріні'                                                                                                 => 'ti',
    'тлінгіт'                                                                                                 => 'tli',
    'токелау'                                                                                                 => 'tkl',
    'токпісін'                                                                                               => 'tpi',
    'тсвана'                                                                                                   => 'tn',
    'тсонга'                                                                                                   => 'ts',
    'тувалу'                                                                                                   => 'tvl',
    'тувинська'                                                                                             => 'tyv',
    'тумбука'                                                                                                 => 'tum',
    'тупі'                                                                                                       => 'tup',
    'турецька'                                                                                               => 'tr',
    'туркменська'                                                                                         => 'tk',
    'тіап'                                                                                                       => 'kcg',
    'тів'                                                                                                         => 'tiv',
    'угаритська'                                                                                           => 'uga',
    'угорська'                                                                                               => 'hu',
    'удмуртська'                                                                                           => 'udm',
    'узбецька'                                                                                               => 'uz',
    'уйгурська'                                                                                             => 'ug',
    'українська'                                                                                           => 'uk',
    'умбунду'                                                                                                 => 'umb',
    'урду'                                                                                                       => 'ur',
    'фанг'                                                                                                       => 'fan',
    'фанті'                                                                                                     => 'fat',
    'фарерська'                                                                                             => 'fo',
    'фламандська'                                                                                         => 'nl_be',
    'фон'                                                                                                         => 'fon',
    'франкокреольськітапіджінізованіфранкофоннімови'                   => 'cpf',
    'французька'                                                                                           => 'fr',
    'французькаканадська'                                                                         => 'fr_ca',
    'французькашвейцарська'                                                                     => 'fr_ch',
    'фризька'                                                                                                 => 'fy',
    'фризькапівнічна'                                                                                 => 'frr',
    'фризькасхідна'                                                                                     => 'frs',
    'фріульська'                                                                                           => 'fur',
    'фула'                                                                                                       => 'ff',
    'фіджі'                                                                                                     => 'fj',
    'філіппінська'                                                                                       => 'fil',
    'філіппінськімови'                                                                               => 'phi',
    'фінноугорськімови'                                                                             => 'fiu',
    'фінська'                                                                                                 => 'fi',
    'фінікійськопунічна'                                                                           => 'phn',
    'хайда'                                                                                                     => 'hai',
    'хамітськімови'                                                                                     => 'cmc',
    'хауса'                                                                                                     => 'ha',
    'хмонг'                                                                                                     => 'hmn',
    'хорватська'                                                                                           => 'hr',
    'хотаносакська'                                                                                     => 'kho',
    'хупа'                                                                                                       => 'hup',
    'хілігайнон'                                                                                           => 'hil',
    'хімачалі'                                                                                               => 'him',
    'хірімоту'                                                                                               => 'ho',
    'хітіті'                                                                                                   => 'hit',
    'центральноамериканьскихіндіанцівмова'                                       => 'cai',
    'церковнослов’янська'                                                                        => 'cu',
    'циганська'                                                                                             => 'rom',
    'цимшиан'                                                                                                 => 'tsi',
    'чагатайська'                                                                                         => 'chg',
    'чаморро'                                                                                                 => 'ch',
    'чейєнн'                                                                                                   => 'chy',
    'черокі'                                                                                                   => 'chr',
    'чеська'                                                                                                   => 'cs',
    'чеченська'                                                                                             => 'ce',
    'чжуан'                                                                                                     => 'za',
    'чинукжаргон'                                                                                         => 'chn',
    'чокто'                                                                                                     => 'cho',
    'чуваська'                                                                                               => 'cv',
    'чуукська'                                                                                               => 'chk',
    'чібча'                                                                                                     => 'chb',
    'чіпев’ян'                                                                                              => 'chp',
    'шанська'                                                                                                 => 'shn',
    'шведська'                                                                                               => 'sv',
    'шона'                                                                                                       => 'sn',
    'шотландська'                                                                                         => 'sco',
    'штучнамова'                                                                                           => 'art',
    'шумерська'                                                                                             => 'sux',
    'юпікмови'                                                                                               => 'ypk',
    'яванська'                                                                                               => 'jv',
    'якутська'                                                                                               => 'sah',
    'яо'                                                                                                           => 'yao',
    'яп'                                                                                                           => 'yap',
    'японська'                                                                                               => 'ja',
    'ібанська'                                                                                               => 'iba',
    'іберійськаіспанська'                                                                         => 'es_es',
    'іврит'                                                                                                     => 'he',
    'ігбо'                                                                                                       => 'ig',
    'іджо'                                                                                                       => 'ijo',
    'ідиш'                                                                                                       => 'yi',
    'ідо'                                                                                                         => 'io',
    'ілоканська'                                                                                           => 'ilo',
    'інгуська'                                                                                               => 'inh',
    'індонезійська'                                                                                     => 'id',
    'індоєвропейськімови'                                                                         => 'ine',
    'індійськімови'                                                                                     => 'inc',
    'інтерлінгва'                                                                                         => 'ia',
    'інтерлінгве'                                                                                         => 'ie',
    'інуктітут'                                                                                             => 'iu',
    'інупіак'                                                                                                 => 'ik',
    'іншімови'                                                                                               => 'mis',
    'іранська'                                                                                               => 'ira',
    'ірландська'                                                                                           => 'ga',
    'ірокезькімови'                                                                                     => 'iro',
    'ісландська'                                                                                           => 'is',
    'іспанська'                                                                                             => 'es',
    'італійська'                                                                                           => 'it',
    'іудеоарабська'                                                                                     => 'jrb',
    'іудеоперська'                                                                                       => 'jpr',
);

1;
