/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */



#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#ifdef WIN32
#  define DllExport   __declspec( dllexport )
#else
#  define DllExport  
#endif 



#ifdef SWIGPERL
/* for perl, these are passed in by MakeMaker derived makefile */
#undef PACKAGE
#undef VERSION
#endif

/* SWIG BUG - no SWIGTCL is defined - duh */
#ifdef TCL_MAJOR_VERSION
  /* want symbols starting librdf_ not _librdf_ */
#undef SWIG_prefix
#define SWIG_prefix
#endif

#ifdef SWIGRUBY
/* Ruby pollutes the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <rdf_config.h>
#include <redland.h>

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);

#ifdef SWIGPYTHON
void librdf_python_world_init(librdf_world *world);
#endif
#ifdef SWIGPERL
void librdf_perl_world_init(librdf_world *world);
void librdf_perl_world_finish(void);
#endif


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#ifdef SWIGPYTHON
/* swig doesn't declare all prototypes */
static PyObject *_wrap_redland_copyright_string_get(void);
static PyObject *_wrap_redland_version_string_get(void);

static PyObject *_wrap_redland_version_major_get(void);
static PyObject *_wrap_redland_version_minor_get(void);
static PyObject *_wrap_redland_version_release_get(void);


static PyObject *librdf_python_callback = NULL;

static PyObject * librdf_python_set_callback(PyObject *dummy, PyObject *args);

/*
 * set the Python function object callback
 */
static PyObject *
librdf_python_set_callback(dummy, args)
  PyObject *dummy, *args;
{
  PyObject *result = NULL;
  PyObject *temp;
  
  if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
    if (!PyCallable_Check(temp)) {
      PyErr_SetString(PyExc_TypeError, "parameter must be callable");
      return NULL;
    }
    Py_XINCREF(temp);         /* Add a reference to new callback */
    Py_XDECREF(librdf_python_callback);  /* Dispose of previous callback */
    librdf_python_callback = temp;       /* Remember new callback */
    /* Boilerplate to return "None" */
    Py_INCREF(Py_None);
    result = Py_None;
  }
  return result;
}


/* Declare a table of methods that python can call */
static PyMethodDef librdf_python_methods [] = {
    {"set_callback",  librdf_python_set_callback, METH_VARARGS,
     "Set python message callback."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


/*
 * calls a python function defined as:
 *   RDF.message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_python_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
#ifdef PYTHON_EXCEPTIONS_WORKING
  PyObject *arglist;
  PyObject *result;
#endif
  char *buffer;
  int len;
  va_list args_copy;

  if(!librdf_python_callback) {
    fprintf(stderr, "librdf_call_python_message: No message callback registered\n");
    return;
  }

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_python_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    if(type == 0) {
#ifdef PYTHON_EXCEPTIONS_WORKING
      PyObject *error = PyErr_NewException("Redland.error", NULL, NULL);
      /* error */
      PyErr_SetString(error, buffer);
#else
      PyErr_Warn(NULL, buffer);
#endif
    } else {
      /* warning */
       PyErr_Warn(NULL, buffer);
    }

#ifdef PYTHON_EXCEPTIONS_WORKING
    /* call the callback */
    arglist = Py_BuildValue("(is)", type, buffer);
    if(!arglist) {
      fprintf(stderr, "librdf_call_python_message: Out of memory\n");
      free(buffer);
      return;
    }
    result = PyEval_CallObject(librdf_python_callback, arglist);
    Py_DECREF(arglist);
    if (result == NULL) {
      free(buffer);
      return;
    }
    
    /* no result */
    Py_DECREF(result);
#endif
    free(buffer);
  }
}

static void
librdf_python_error_handler(void *user_data, 
                            const char *message, va_list arguments)
{
  librdf_call_python_message(0, message, arguments);
}


static void
librdf_python_warning_handler(void *user_data,
                              const char *message, va_list arguments)
{
  librdf_call_python_message(1, message, arguments);
}

void
librdf_python_world_init(librdf_world *world)
{
  (void) Py_InitModule("Redland_python", librdf_python_methods);
  librdf_world_set_error(world, NULL, librdf_python_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_python_warning_handler);
}
 

#endif

#ifdef SWIGPERL
/*
 * calls a perl subroutine defined as:
 *   RDF::Redland::World::message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_perl_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
  dSP;
  char *buffer;
  int len;
  va_list args_copy;
  
  ENTER;
  SAVETMPS;

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_perl_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    PUSHMARK(SP) ;
    XPUSHs(sv_2mortal(newSViv(type)));
    XPUSHs(sv_2mortal(newSVpv(buffer, 0)));
    PUTBACK;
  
    call_pv("RDF::Redland::World::message", G_DISCARD);

    free(buffer);
  }
  
  FREETMPS;
  LEAVE;
}

static void
librdf_perl_error_handler(void *user_data, 
                          const char *message, va_list arguments)
{
  librdf_call_perl_message(0, message, arguments);
}


static void
librdf_perl_warning_handler(void *user_data,
                            const char *message, va_list arguments)
{
  librdf_call_perl_message(1, message, arguments);
}

static librdf_world* librdf_perl_world=NULL;

void
librdf_perl_world_init(librdf_world *world)
{
  librdf_world_set_error(world, NULL, librdf_perl_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_perl_warning_handler);

  librdf_perl_world=world;
}

void
librdf_perl_world_finish(void)
{
  librdf_free_world(librdf_perl_world);
}
#endif


/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_error(world, "test error message number %d.", 1);
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_warning(world, "test warning message number %d.", 2);
}


extern char const *redland_copyright_string;
extern char const *redland_version_string;
extern int redland_version_major;
extern int redland_version_minor;
extern int redland_version_release;

#ifdef __cplusplus
extern "C" {
#endif

DllExport int CSharp_librdf_new_world() {
    int jresult = 0 ;
    librdf_world *result;
    
    result = (librdf_world *)librdf_new_world();
    
    *(librdf_world **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_world(int jarg1) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    arg1 = *(librdf_world **)&jarg1; 
    librdf_free_world(arg1);
    
}


DllExport void CSharp_librdf_world_open(int jarg1) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    arg1 = *(librdf_world **)&jarg1; 
    librdf_world_open(arg1);
    
}


DllExport void CSharp_librdf_init_world(char * jarg1, int jarg2) {
    char *arg1 ;
    librdf_hash *arg2 = (librdf_hash *) 0 ;
    
    {
        arg1 = jarg1;
    }
    arg2 = *(librdf_hash **)&jarg2; 
    librdf_init_world(arg1,arg2);
    
}


DllExport void CSharp_librdf_destroy_world() {
    librdf_destroy_world();
    
}


DllExport void CSharp_librdf_free_iterator(int jarg1) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    librdf_free_iterator(arg1);
    
}


DllExport int CSharp_librdf_iterator_have_elements(int jarg1) {
    int jresult = 0 ;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    result = (int)librdf_iterator_have_elements(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_iterator_end(int jarg1) {
    int jresult = 0 ;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    result = (int)librdf_iterator_end(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_iterator_get_object(int jarg1) {
    int jresult = 0 ;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    result = (librdf_node *)librdf_iterator_get_object(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_iterator_get_context(int jarg1) {
    int jresult = 0 ;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    result = (librdf_node *)librdf_iterator_get_context(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_iterator_next(int jarg1) {
    int jresult = 0 ;
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    
    arg1 = *(librdf_iterator **)&jarg1; 
    result = (int)librdf_iterator_next(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_uri(int jarg1, char * jarg2) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    result = (librdf_uri *)librdf_new_uri(arg1,arg2);
    
    *(librdf_uri **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_uri_from_uri(int jarg1) {
    int jresult = 0 ;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *result;
    
    arg1 = *(librdf_uri **)&jarg1; 
    result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
    
    *(librdf_uri **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_uri_from_filename(int jarg1, char * jarg2) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
    
    *(librdf_uri **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_uri(int jarg1) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    
    arg1 = *(librdf_uri **)&jarg1; 
    librdf_free_uri(arg1);
    
}


DllExport char * CSharp_librdf_uri_to_string(int jarg1) {
    char * jresult = 0 ;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    char *result;
    
    arg1 = *(librdf_uri **)&jarg1; 
    result = (char *)librdf_uri_to_string(arg1);
    
    *(char **)&jresult = result; 
    free(result);
    return jresult;
}


DllExport int CSharp_librdf_uri_equals(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    int result;
    
    arg1 = *(librdf_uri **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    result = (int)librdf_uri_equals(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node(int jarg1) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    result = (librdf_node *)librdf_new_node(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_uri_string(int jarg1, char * jarg2) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    result = (librdf_node *)librdf_new_node_from_uri_string(arg1,arg2);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_uri(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_literal(int jarg1, char * jarg2, char * jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int arg4 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    {
        arg3 = jarg3;
    }
    arg4 = (int)jarg4; 
    result = (librdf_node *)librdf_new_node_from_literal(arg1,arg2,arg3,arg4);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_typed_literal(int jarg1, char * jarg2, char * jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    {
        arg3 = jarg3;
    }
    arg4 = *(librdf_uri **)&jarg4; 
    result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_node(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (librdf_node *)librdf_new_node_from_node(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_node_from_blank_identifier(int jarg1, char * jarg2) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_node(int jarg1) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    
    arg1 = *(librdf_node **)&jarg1; 
    librdf_free_node(arg1);
    
}


DllExport int CSharp_librdf_node_get_uri(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (librdf_uri *)librdf_node_get_uri(arg1);
    
    *(librdf_uri **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_get_type(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (int)librdf_node_get_type(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_node_get_literal_value(int jarg1) {
    char * jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (char *)librdf_node_get_literal_value(arg1);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_node_get_literal_value_as_latin1(int jarg1) {
    char * jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_node_get_literal_value_language(int jarg1) {
    char * jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (char *)librdf_node_get_literal_value_language(arg1);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_get_literal_value_datatype_uri(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
    
    *(librdf_uri **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_get_literal_value_is_wf_xml(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_node_to_string(int jarg1) {
    char * jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (char *)librdf_node_to_string(arg1);
    
    *(char **)&jresult = result; 
    free(result);
    return jresult;
}


DllExport char * CSharp_librdf_node_get_blank_identifier(int jarg1) {
    char * jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (char *)librdf_node_get_blank_identifier(arg1);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_is_resource(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (int)librdf_node_is_resource(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_is_literal(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (int)librdf_node_is_literal(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_is_blank(int jarg1) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    result = (int)librdf_node_is_blank(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_node_equals(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_node **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    result = (int)librdf_node_equals(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_statement(int jarg1) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_statement *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    result = (librdf_statement *)librdf_new_statement(arg1);
    
    *(librdf_statement **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_statement_from_statement(int jarg1) {
    int jresult = 0 ;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *result;
    
    arg1 = *(librdf_statement **)&jarg1; 
    result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
    
    *(librdf_statement **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_statement_from_nodes(int jarg1, int jarg2, int jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    librdf_statement *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    arg4 = *(librdf_node **)&jarg4; 
    result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
    
    *(librdf_statement **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_statement(int jarg1) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    
    arg1 = *(librdf_statement **)&jarg1; 
    librdf_free_statement(arg1);
    
}


DllExport int CSharp_librdf_statement_get_subject(int jarg1) {
    int jresult = 0 ;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_statement **)&jarg1; 
    result = (librdf_node *)librdf_statement_get_subject(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_statement_set_subject(int jarg1, int jarg2) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    arg1 = *(librdf_statement **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    librdf_statement_set_subject(arg1,arg2);
    
}


DllExport int CSharp_librdf_statement_get_predicate(int jarg1) {
    int jresult = 0 ;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_statement **)&jarg1; 
    result = (librdf_node *)librdf_statement_get_predicate(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_statement_set_predicate(int jarg1, int jarg2) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    arg1 = *(librdf_statement **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    librdf_statement_set_predicate(arg1,arg2);
    
}


DllExport int CSharp_librdf_statement_get_object(int jarg1) {
    int jresult = 0 ;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_statement **)&jarg1; 
    result = (librdf_node *)librdf_statement_get_object(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_statement_set_object(int jarg1, int jarg2) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    
    arg1 = *(librdf_statement **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    librdf_statement_set_object(arg1,arg2);
    
}


DllExport char * CSharp_librdf_statement_to_string(int jarg1) {
    char * jresult = 0 ;
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    char *result;
    
    arg1 = *(librdf_statement **)&jarg1; 
    result = (char *)librdf_statement_to_string(arg1);
    
    *(char **)&jresult = result; 
    free(result);
    return jresult;
}


DllExport int CSharp_librdf_new_model(int jarg1, int jarg2, char * jarg3) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    char *arg3 ;
    librdf_model *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    arg2 = *(librdf_storage **)&jarg2; 
    {
        arg3 = jarg3;
    }
    result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
    
    *(librdf_model **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_model_with_options(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    librdf_hash *arg3 = (librdf_hash *) 0 ;
    librdf_model *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    arg2 = *(librdf_storage **)&jarg2; 
    arg3 = *(librdf_hash **)&jarg3; 
    result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
    
    *(librdf_model **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_model_from_model(int jarg1) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_model *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    result = (librdf_model *)librdf_new_model_from_model(arg1);
    
    *(librdf_model **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_model(int jarg1) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    arg1 = *(librdf_model **)&jarg1; 
    librdf_free_model(arg1);
    
}


DllExport int CSharp_librdf_model_size(int jarg1) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    result = (int)librdf_model_size(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_add(int jarg1, int jarg2, int jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    arg4 = *(librdf_node **)&jarg4; 
    result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_add_typed_literal_statement(int jarg1, int jarg2, int jarg3, char * jarg4, char * jarg5, int jarg6) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    char *arg4 ;
    char *arg5 ;
    librdf_uri *arg6 = (librdf_uri *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    {
        arg4 = jarg4;
    }
    {
        arg5 = jarg5;
    }
    arg6 = *(librdf_uri **)&jarg6; 
    result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_add_statement(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_statement **)&jarg2; 
    result = (int)librdf_model_add_statement(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_add_statements(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *arg2 = (librdf_stream *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_stream **)&jarg2; 
    result = (int)librdf_model_add_statements(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_remove_statement(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_statement **)&jarg2; 
    result = (int)librdf_model_remove_statement(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_contains_statement(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_statement **)&jarg2; 
    result = (int)librdf_model_contains_statement(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_as_stream(int jarg1) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    result = (librdf_stream *)librdf_model_as_stream(arg1);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_serialise(int jarg1) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    result = (librdf_stream *)librdf_model_serialise(arg1);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_find_statements(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_statement **)&jarg2; 
    result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_sources(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
    
    *(librdf_iterator **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_arcs(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
    
    *(librdf_iterator **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_targets(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
    
    *(librdf_iterator **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_source(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_arc(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_get_target(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_node **)&jarg3; 
    result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_add_statement(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_statement **)&jarg3; 
    result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_add_statements(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *arg3 = (librdf_stream *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_stream **)&jarg3; 
    result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_remove_statement(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    arg3 = *(librdf_statement **)&jarg3; 
    result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_remove_statements(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    result = (int)librdf_model_context_remove_statements(arg1,arg2);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_as_stream(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_model_context_serialize(int jarg1, int jarg2) {
    int jresult = 0 ;
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_model **)&jarg1; 
    arg2 = *(librdf_node **)&jarg2; 
    result = (librdf_stream *)librdf_model_context_serialize(arg1,arg2);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_model_sync(int jarg1) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    
    arg1 = *(librdf_model **)&jarg1; 
    librdf_model_sync(arg1);
    
}


DllExport int CSharp_librdf_new_storage(int jarg1, char * jarg2, char * jarg3, char * jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    librdf_storage *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    {
        arg3 = jarg3;
    }
    {
        arg4 = jarg4;
    }
    result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
    
    *(librdf_storage **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_storage_from_storage(int jarg1) {
    int jresult = 0 ;
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    librdf_storage *result;
    
    arg1 = *(librdf_storage **)&jarg1; 
    result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
    
    *(librdf_storage **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_storage(int jarg1) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    
    arg1 = *(librdf_storage **)&jarg1; 
    librdf_free_storage(arg1);
    
}


DllExport int CSharp_librdf_new_parser(int jarg1, char * jarg2, char * jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_parser *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    {
        arg3 = jarg3;
    }
    arg4 = *(librdf_uri **)&jarg4; 
    result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    *(librdf_parser **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_parser(int jarg1) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    
    arg1 = *(librdf_parser **)&jarg1; 
    librdf_free_parser(arg1);
    
}


DllExport int CSharp_librdf_parser_parse_as_stream(int jarg1, int jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    arg3 = *(librdf_uri **)&jarg3; 
    result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_parser_parse_into_model(int jarg1, int jarg2, int jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    arg3 = *(librdf_uri **)&jarg3; 
    arg4 = *(librdf_model **)&jarg4; 
    result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_parser_parse_string_as_stream(int jarg1, char * jarg2, int jarg3) {
    int jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    {
        arg2 = jarg2;
    }
    arg3 = *(librdf_uri **)&jarg3; 
    result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
    
    *(librdf_stream **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_parser_parse_string_into_model(int jarg1, char * jarg2, int jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    {
        arg2 = jarg2;
    }
    arg3 = *(librdf_uri **)&jarg3; 
    arg4 = *(librdf_model **)&jarg4; 
    result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
    
    jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_parser_get_feature(int jarg1, int jarg2) {
    char * jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    result = (char *)librdf_parser_get_feature(arg1,arg2);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_parser_set_feature(int jarg1, int jarg2, char * jarg3) {
    int jresult = 0 ;
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    
    arg1 = *(librdf_parser **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    {
        arg3 = jarg3;
    }
    result = (int)librdf_parser_set_feature(arg1,arg2,(char const *)arg3);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_new_serializer(int jarg1, char * jarg2, char * jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_serializer *result;
    
    arg1 = *(librdf_world **)&jarg1; 
    {
        arg2 = jarg2;
    }
    {
        arg3 = jarg3;
    }
    arg4 = *(librdf_uri **)&jarg4; 
    result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    *(librdf_serializer **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_serializer(int jarg1) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    
    arg1 = *(librdf_serializer **)&jarg1; 
    librdf_free_serializer(arg1);
    
}


DllExport int CSharp_librdf_serializer_serialize_model_to_file(int jarg1, char * jarg2, int jarg3, int jarg4) {
    int jresult = 0 ;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    
    arg1 = *(librdf_serializer **)&jarg1; 
    {
        arg2 = jarg2;
    }
    arg3 = *(librdf_uri **)&jarg3; 
    arg4 = *(librdf_model **)&jarg4; 
    result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
    
    jresult = result; 
    return jresult;
}


DllExport char * CSharp_librdf_serializer_get_feature(int jarg1, int jarg2) {
    char * jresult = 0 ;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    
    arg1 = *(librdf_serializer **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    result = (char *)librdf_serializer_get_feature(arg1,arg2);
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_serializer_set_feature(int jarg1, int jarg2, char * jarg3) {
    int jresult = 0 ;
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    
    arg1 = *(librdf_serializer **)&jarg1; 
    arg2 = *(librdf_uri **)&jarg2; 
    {
        arg3 = jarg3;
    }
    result = (int)librdf_serializer_set_feature(arg1,arg2,(char const *)arg3);
    
    jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_free_stream(int jarg1) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    
    arg1 = *(librdf_stream **)&jarg1; 
    librdf_free_stream(arg1);
    
}


DllExport int CSharp_librdf_stream_end(int jarg1) {
    int jresult = 0 ;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    
    arg1 = *(librdf_stream **)&jarg1; 
    result = (int)librdf_stream_end(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_stream_next(int jarg1) {
    int jresult = 0 ;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    
    arg1 = *(librdf_stream **)&jarg1; 
    result = (int)librdf_stream_next(arg1);
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_stream_get_object(int jarg1) {
    int jresult = 0 ;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_statement *result;
    
    arg1 = *(librdf_stream **)&jarg1; 
    result = (librdf_statement *)librdf_stream_get_object(arg1);
    
    *(librdf_statement **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_librdf_stream_get_context(int jarg1) {
    int jresult = 0 ;
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_node *result;
    
    arg1 = *(librdf_stream **)&jarg1; 
    result = (librdf_node *)librdf_stream_get_context(arg1);
    
    *(librdf_node **)&jresult = result; 
    return jresult;
}


DllExport void CSharp_librdf_internal_test_error(int jarg1) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    arg1 = *(librdf_world **)&jarg1; 
    librdf_internal_test_error(arg1);
    
}


DllExport void CSharp_librdf_internal_test_warning(int jarg1) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    
    arg1 = *(librdf_world **)&jarg1; 
    librdf_internal_test_warning(arg1);
    
}


DllExport char * CSharp_get_redland_copyright_string() {
    char * jresult = 0 ;
    char *result;
    
    result = (char *)redland_copyright_string;
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport char * CSharp_get_redland_version_string() {
    char * jresult = 0 ;
    char *result;
    
    result = (char *)redland_version_string;
    
    *(char **)&jresult = result; 
    return jresult;
}


DllExport int CSharp_get_redland_version_major() {
    int jresult = 0 ;
    int result;
    
    result = (int)redland_version_major;
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_get_redland_version_minor() {
    int jresult = 0 ;
    int result;
    
    result = (int)redland_version_minor;
    
    jresult = result; 
    return jresult;
}


DllExport int CSharp_get_redland_version_release() {
    int jresult = 0 ;
    int result;
    
    result = (int)redland_version_release;
    
    jresult = result; 
    return jresult;
}


#ifdef __cplusplus
}
#endif

#ifdef TCL_MAJOR_VERSION
Tcl_PkgProvide(interp, PACKAGE, (char*)redland_version_string);
#endif


