package Catan::Asset::Settlement;
$Catan::Asset::Settlement::VERSION = '0.03';
use strict;
use warnings;
use Catan::Resource::Brick;
use Catan::Resource::Grain;
use Catan::Resource::Lumber;
use Catan::Resource::Wool;

sub new
{
  my ($class, $location) = @_;

  die "$class new requires a location argument"
    unless $location && $location->isa('Catan::Map::Intersection');

  return bless {
    location => $location,
    code     => 'S',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Catan::Resource::Brick->new(-1),
    Catan::Resource::Grain->new(-1),
    Catan::Resource::Lumber->new(-1),
    Catan::Resource::Wool->new(-1),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Asset::Settlement

=head1 VERSION

version 0.03

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
