#!perl 
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;
use HTTP::PublicKeyPins qw(pin_sha256);

plan tests => 5;

SKIP: {
	`openssl version`;
	if ($? != 0) {
		skip("openssl binary is not available", 3);
	}
	my $temp_pub_path = 't/test.pub';
	foreach my $path ('t/certs/duckduckgo.pem', 't/certs/dsa.pem', 't/certs/google.pem') {
		my $test_pin_sha256 = pin_sha256($path);
		`openssl x509 -noout -in $path -pubkey | openssl asn1parse -noout -inform pem -out $temp_pub_path`;
		my $rfc_7469_pin_sha256 = `openssl dgst -sha256 -binary $temp_pub_path | openssl enc -base64`;
		chomp $rfc_7469_pin_sha256;
		ok($test_pin_sha256 eq $rfc_7469_pin_sha256, "$path produced the correct HPKP pin:$rfc_7469_pin_sha256");
	}
	unlink $temp_pub_path or die "Failed to unlink $temp_pub_path";
}
eval {
	pin_sha256('t/certs/missing.pem');
};
chomp $@;
ok($@ =~ /Failed to open/, "Correctly threw an exception:$@");
eval {
	pin_sha256('t/certs/corrupt.pem');
};
chomp $@;
ok($@ =~ /is not a PEM encoded SSL Certificate/, "Correctly threw an exception:$@");
