# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172131;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '007',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20[1-9]\\d{7}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00(?:
            (?:
              37|
              66
            )\\d{6,13}|
            (?:
              777(?:
                [01]|
                (?:
                  5|
                  8\\d
                )\\d
              )|
              882[1245]\\d\\d
            )\\d\\d
          )|
          (?:
            120|
            800\\d
          )\\d{6}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"811546", "釧路",
"812477", "三春",
"815736", "中津川",
"819912", "中之島",
"819577", "島原",
"814792", "銚子",
"81172", "弘前",
"811542", "釧路",
"81728", "寝屋川",
"8188094", "窪川",
"814796", "八日市場",
"811363", "倶知安",
"815732", "恵那",
"811365", "倶知安",
"811632", "天塩",
"81562", "尾張横須賀",
"81925", "福岡",
"811978", "北上",
"817947", "三木",
"811636", "北見枝幸",
"812544", "新発田",
"818378", "下関",
"812419", "田島",
"812897", "鹿沼",
"81774", "宇治",
"81863", "玉野",
"812793", "渋川",
"81243", "二本松",
"815972", "尾鷲",
"81537", "掛川",
"812795", "渋川",
"818463", "竹原",
"8112399", "栗山",
"812977", "竜ケ崎",
"815393", "浜松",
"81427", "相模原",
"81277", "桐生",
"815395", "浜松",
"811866", "鷹巣",
"8112397", "栗山",
"812833", "宇都宮",
"812835", "佐野",
"81886", "徳島",
"8153961", "天竜",
"811583", "紋別",
"819944", "鹿屋",
"8186552", "倉敷",
"818677", "新見",
"811862", "鹿角",
"811738", "鰺ケ沢",
"811585", "遠軽",
"81964", "松橋",
"818397", "小郡",
"818796", "土庄",
"818584", "倉吉",
"812389", "米沢",
"818208", "久賀",
"81179", "三戸",
"812878", "烏山",
"818792", "三本松",
"81463", "平塚",
"8188098", "土佐清水",
"819969", "中甑",
"817687", "能都",
"81183", "湯沢",
"817715", "亀岡",
"818836", "脇町",
"817713", "亀岡",
"81569", "半田",
"811464", "静内",
"815994", "阿児",
"818832", "鴨島",
"819598", "福江",
"81948", "飯塚",
"8168", "大阪",
"81280", "古河",
"81827", "岩国",
"818698", "備前",
"817352", "新宮",
"811935", "釜石",
"811933", "釜石",
"817356", "串本",
"812962", "下館",
"81236", "山形",
"818295", "廿日市",
"814223", "武蔵野三鷹",
"818293", "廿日市",
"814225", "武蔵野三鷹",
"812569", "巻",
"818557", "川本",
"811877", "大曲",
"818662", "高梁",
"819787", "国東",
"818364", "宇部",
"81166", "旭川",
"81486", "浦和",
"812998", "潮来",
"81998", "鹿児島",
"819684", "山鹿",
"818804", "土佐中村",
"818666", "井原",
"815978", "熊野",
"81482", "川口",
"81162", "稚内",
"812474", "石川",
"819574", "諫早",
"811553", "帯広",
"811555", "帯広",
"814705", "館山",
"818875", "土佐山田",
"814703", "館山",
"818873", "安芸",
"811337", "石狩",
"811736", "五所川原",
"818493", "尾道",
"81764", "富山",
"817944", "加古川",
"812547", "村上",
"811868", "鷹巣",
"811732", "五所川原",
"815363", "新城",
"812894", "宇都宮",
"81572", "多治見",
"817916", "竜野",
"814798", "八日市場",
"81928", "福岡",
"812974", "水海道",
"817912", "相生",
"812695", "中野",
"811548", "弟子屈",
"812693", "中野",
"815738", "中津川",
"815585", "下田",
"815583", "下田",
"811638", "利尻礼文",
"818376", "美祢",
"811972", "水沢",
"818372", "長門",
"811395", "江差",
"819947", "志布志",
"811393", "松前",
"818674", "久世",
"81725", "和泉",
"811235", "夕張",
"811233", "千歳",
"811976", "北上",
"8199347", "鹿児島",
"818692", "邑久",
"818587", "郡家",
"81583", "岐阜",
"818696", "備前",
"812968", "笠間",
"81489", "草加",
"812373", "村山",
"817684", "輪島",
"812375", "村山",
"81798", "西宮",
"812996", "潮来",
"818668", "井原",
"818263", "加計",
"81473", "市川",
"815997", "阿児",
"8188092", "窪川",
"818265", "安芸吉田",
"817613", "小松",
"812992", "石岡",
"817615", "小松",
"812872", "大田原",
"818202", "柳井",
"818798", "土庄",
"812876", "黒磯",
"818206", "柳井",
"81566", "刈谷",
"818554", "浜田",
"81176", "十和田",
"819596", "福江",
"811874", "角館",
"819784", "豊後高田",
"818367", "宇部",
"819592", "大瀬戸",
"819687", "玉名",
"817969", "浜坂",
"818838", "阿波池田",
"818807", "宿毛",
"814777", "船橋",
"817958", "丹波柏原",
"81462", "厚木",
"81182", "横手",
"812837", "佐野",
"819956", "加治木",
"815768", "下呂",
"818249", "東広島",
"811234", "千歳",
"811394", "松前",
"818673", "福渡",
"819952", "大口",
"81935", "北九州",
"818675", "久世",
"811587", "中湧別",
"812236", "仙台",
"812973", "水海道",
"81738", "御坊",
"812975", "水海道",
"818467", "木江",
"812797", "渋川",
"814297", "飯能",
"815584", "下田",
"812232", "岩沼",
"815397", "浜松",
"812694", "中野",
"8125481", "村上",
"817943", "加古川",
"817945", "加古川",
"817458", "大和榛原",
"8112398", "栗山",
"812556", "糸魚川",
"812893", "宇都宮",
"812895", "宇都宮",
"8125486", "津川",
"812552", "上越",
"819573", "諫早",
"812475", "石川",
"817482", "八日市",
"812473", "石川",
"819575", "諫早",
"814704", "館山",
"818874", "安芸",
"817486", "水口",
"811367", "寿都",
"81249", "郡山",
"812588", "長岡",
"811554", "帯広",
"811875", "角館",
"818892", "佐川",
"819785", "豊後高田",
"811873", "角館",
"819783", "豊後高田",
"818553", "浜田",
"81563", "西尾",
"8188097", "土佐清水",
"818555", "江津",
"818896", "須崎",
"8198291", "延岡",
"814994", "三宅",
"81862", "岡山",
"818476", "府中",
"8188099", "土佐清水",
"811937", "宮古",
"81292", "水戸",
"818297", "廿日市",
"818472", "甲山",
"814227", "武蔵野三鷹",
"81554", "大月",
"819679", "高森",
"812938", "水戸",
"817717", "園部",
"812672", "小諸",
"817685", "輪島",
"818548", "石見大田",
"8175", "京都",
"812374", "村山",
"817683", "輪島",
"81270", "伊勢崎",
"8167", "大阪",
"81420", "所沢",
"817614", "小松",
"81586", "一宮",
"812676", "佐久",
"818264", "安芸吉田",
"819742", "三重",
"81226", "気仙沼",
"81242", "会津若松",
"81476", "成田",
"818976", "新居浜",
"81952", "佐賀",
"811372", "鹿部",
"818972", "新居浜",
"8112394", "夕張",
"819746", "竹田",
"8198296", "日向",
"811376", "八雲",
"817452", "大和高田",
"812834", "宇都宮",
"81956", "佐世保",
"811237", "栗山",
"81246", "いわき",
"817456", "大和高田",
"81222", "仙台",
"811397", "奥尻",
"817239", "寝屋川",
"819945", "鹿屋",
"819943", "鹿屋",
"811584", "遠軽",
"812558", "新井",
"817488", "水口",
"818464", "竹原",
"812794", "渋川",
"81582", "岐阜",
"812586", "長岡",
"815587", "修善寺大仁",
"818689", "岡山",
"819809", "八重山",
"815394", "浜松",
"812697", "飯山",
"812582", "長岡",
"8186993", "備前",
"817952", "西脇",
"815762", "下呂",
"811333", "当別",
"812489", "須賀川",
"817956", "三田",
"812545", "村上",
"815367", "設楽",
"8112392", "夕張",
"815766", "下呂",
"812543", "新発田",
"81721", "富田林",
"812570", "小出",
"812571", "六日町",
"818877", "嶺北",
"814707", "大原",
"81984", "小林",
"812238", "仙台",
"811364", "倶知安",
"81938", "北九州",
"811557", "十勝池田",
"81547", "島田",
"818363", "宇部",
"818365", "宇部",
"812932", "高萩",
"81233", "新庄",
"812649", "長野",
"814280", "立川",
"818542", "安来",
"812678", "佐久",
"814281", "相模原",
"81229", "古川",
"812780", "前橋",
"818803", "土佐中村",
"819683", "山鹿",
"812936", "水戸",
"818805", "土佐中村",
"819685", "玉名",
"814775", "船橋",
"818546", "掛合",
"811934", "釜石",
"811378", "今金",
"818294", "廿日市",
"818978", "伯方",
"814224", "武蔵野三鷹",
"818949", "宇和",
"817714", "亀岡",
"81260", "阿南町",
"8166", "大阪",
"812377", "寒河江",
"817617", "加賀",
"815993", "鳥羽",
"811465", "静内",
"815995", "阿児",
"818267", "千代田",
"811463", "浦河",
"818583", "倉吉",
"818585", "倉吉",
"818478", "東城",
"818514", "海士",
"81466", "藤沢",
"817677", "七尾",
"811648", "焼尻",
"812852", "小山",
"817902", "福崎",
"81591", "津",
"819937", "加世田",
"817906", "播磨山崎",
"81947", "田川",
"8182942", "広島",
"812856", "真岡",
"818660", "岡山瀬戸",
"81495", "本庄",
"811854", "男鹿",
"81989", "那覇",
"8153974", "天竜",
"817465", "吉野",
"817463", "吉野",
"811538", "根室標津",
"814757", "東金",
"815748", "美濃白川",
"811655", "名寄",
"811653", "士別",
"8186996", "岡山瀬戸",
"81763", "福野",
"819437", "田主丸",
"819674", "熊本一の宮",
"812618", "大町",
"818947", "宇和",
"819728", "臼杵",
"812647", "長野",
"81828", "広島",
"817726", "峰山",
"812744", "藤岡",
"817963", "豊岡",
"817965", "豊岡",
"817722", "宮津",
"815755", "関",
"815753", "関",
"819668", "水俣",
"818388", "田万川",
"818879", "室戸",
"814709", "鴨川",
"818848", "牟岐",
"8178", "神戸",
"817364", "和歌山橋本",
"811559", "帯広",
"8112395", "栗山",
"8124197", "柳津",
"811952", "二戸",
"812487", "須賀川",
"818654", "鴨方",
"81727", "池田",
"811956", "岩手",
"818596", "米子",
"815958", "亀山",
"819554", "伊万里",
"81474", "船橋",
"818592", "米子",
"818687", "美作",
"819807", "沖縄宮古",
"815589", "修善寺大仁",
"815982", "松阪",
"81538", "磐田",
"811541", "弟子屈",
"811452", "早来",
"81584", "大垣",
"818244", "三次",
"81845", "因島",
"815986", "松阪",
"818568", "津和野",
"811456", "門別富川",
"81797", "西宮",
"812385", "米沢",
"817674", "羽咋",
"81825", "広島",
"812383", "米沢",
"812616", "大町",
"81963", "熊本",
"819934", "指宿",
"817995", "洲本",
"812612", "大町",
"817993", "洲本",
"819722", "佐伯",
"81244", "原町",
"819965", "川内",
"819963", "川内",
"811857", "能代",
"819726", "臼杵",
"8125480", "村上",
"814754", "茂原",
"81191", "一関",
"817728", "峰山",
"81986", "都城",
"811939", "宮古",
"811642", "石狩深川",
"8186691", "倉敷",
"817908", "播磨山崎",
"8199345", "鹿児島",
"812858", "真岡",
"811753", "むつ",
"819434", "八女",
"81930", "行橋",
"818299", "広島",
"8125483", "村上",
"811646", "羽幌",
"814229", "武蔵野三鷹",
"819677", "矢部",
"817493", "彦根",
"81864", "倉敷",
"817495", "長浜",
"818944", "八幡浜",
"81294", "常陸太田",
"812644", "木曾福島",
"811536", "厚岸",
"812565", "三条",
"81853", "出雲",
"815746", "美濃加茂",
"812563", "三条",
"812747", "富岡",
"811532", "根室",
"818690", "岡山",
"815742", "美濃加茂",
"81552", "甲府",
"815952", "上野",
"81535", "浜松",
"812957", "大子",
"81848", "尾道",
"8198290", "延岡",
"815956", "上野",
"818598", "根雨",
"81425", "立川",
"81281", "宇都宮",
"817367", "岩出",
"819208", "対馬佐賀",
"815988", "三瀬谷",
"811943", "岩泉",
"811945", "久慈",
"812484", "白河",
"818657", "笠岡",
"812415", "柳津",
"812413", "喜多方",
"818562", "益田",
"81464", "厚木",
"819662", "人吉",
"81184", "本荘",
"819557", "唐津",
"818846", "丹生谷",
"811982", "花巻",
"81138", "函館",
"812799", "長野原",
"819804", "名護",
"818684", "津山",
"819666", "水俣",
"815399", "天竜",
"81898", "今治",
"818382", "萩",
"811986", "遠野",
"818842", "阿南",
"81559", "沼津",
"812839", "佐野",
"811958", "岩手",
"818247", "庄原",
"81268", "上田",
"81927", "福岡",
"812913", "鉾田",
"8183767", "下関",
"817703", "敦賀",
"8198293", "延岡",
"817705", "小浜",
"811589", "興部",
"812564", "三条",
"812643", "木曾福島",
"818369", "宇部",
"81776", "福井",
"812645", "木曾福島",
"815757", "郡上八幡",
"81983", "高鍋",
"812248", "大河原",
"817967", "八鹿",
"8145", "横浜",
"811562", "本別",
"818943", "八幡浜",
"811566", "十勝清水",
"817494", "彦根",
"818945", "八幡浜",
"819435", "八女",
"811754", "むつ",
"819433", "八女",
"812788", "前橋",
"814288", "青梅",
"81979", "中津",
"819964", "川内",
"81545", "富士",
"8188095", "土佐清水",
"812658", "伊那",
"814755", "東金",
"815999", "津",
"814753", "茂原",
"817673", "羽咋",
"812384", "米沢",
"817675", "七尾",
"818958", "御荘",
"817994", "洲本",
"819828", "高千穂",
"819933", "指宿",
"819935", "加世田",
"81737", "湯浅",
"8165", "大阪",
"81250", "新津",
"819949", "大根占",
"81940", "宗像",
"811528", "美幌",
"819978", "徳之島",
"812914", "鉾田",
"817704", "敦賀",
"81125", "滝川",
"819542", "武雄",
"8153977", "天竜",
"812550", "安塚",
"812551", "上越",
"819546", "鹿島",
"819805", "名護",
"818685", "津山",
"819803", "名護",
"818683", "津山",
"81484", "川口",
"812230", "仙台",
"812483", "白河",
"819738", "玖珠",
"817472", "五条",
"811944", "岩泉",
"812485", "白河",
"81438", "木更津",
"817736", "舞鶴",
"817476", "下市",
"812549", "津川",
"817732", "福知山",
"812414", "柳津",
"812578", "六日町",
"81234", "酒田",
"81288", "今市",
"81762", "金沢",
"812567", "巻",
"8153963", "天竜",
"818559", "川本",
"815562", "鰍沢青柳",
"819789", "杵築",
"812652", "飯田",
"815754", "関",
"812656", "伊那",
"81766", "高岡",
"812745", "藤岡",
"812743", "藤岡",
"817964", "豊岡",
"815566", "身延",
"819826", "日向",
"818956", "宇和島",
"8147950", "八日市場",
"81548", "榛原",
"811654", "名寄",
"81969", "天草",
"811352", "余市",
"819675", "熊本一の宮",
"819822", "延岡",
"817497", "長浜",
"819673", "熊本一の宮",
"81835", "防府",
"818952", "宇和島",
"811356", "岩内",
"811757", "野辺地",
"819967", "出水",
"811853", "男鹿",
"811855", "能代",
"812246", "大河原",
"812242", "白石",
"817464", "吉野",
"81779", "大野",
"8153960", "天竜",
"812387", "長井",
"814286", "相模原",
"812786", "沼田",
"812930", "水戸",
"817997", "津名",
"814282", "青梅",
"812782", "沼田",
"818243", "東広島",
"819732", "日田",
"818245", "三次",
"812576", "十日町",
"818679", "新見",
"81531", "田原",
"812572", "柏崎",
"812917", "水戸",
"817738", "舞鶴",
"817707", "小浜",
"819555", "唐津",
"819553", "伊万里",
"812979", "竜ケ崎",
"81962", "熊本",
"817950", "三田",
"811526", "網走",
"811947", "久慈",
"819233", "前原",
"81740", "今津",
"819976", "名瀬",
"81852", "松江",
"817949", "加古川",
"812580", "十日町",
"811522", "斜里",
"81174", "蟹田",
"818655", "鴨方",
"812417", "会津山口",
"8183768", "下関",
"81553", "山梨",
"812899", "鹿沼",
"819972", "種子島",
"81937", "北九州",
"812955", "常陸大宮",
"81564", "岡崎",
"817363", "和歌山橋本",
"8182920", "廿日市",
"817365", "和歌山橋本",
"81834", "徳山",
"818942", "八幡浜",
"8188091", "窪川",
"819432", "八女",
"81888", "高知",
"818946", "宇和",
"811563", "本別",
"811644", "留萌",
"8198297", "日向",
"817727", "峰山",
"815744", "美濃加茂",
"812646", "長野",
"811534", "中標津",
"818391", "小郡",
"81792", "姫路",
"8198299", "日向",
"811858", "能代",
"818549", "石見大田",
"812939", "水戸",
"812642", "木曾福島",
"812614", "大町",
"81929", "福岡",
"819678", "矢部",
"817676", "七尾",
"81557", "伊東",
"81933", "北九州",
"819932", "指宿",
"812857", "真岡",
"817907", "播磨山崎",
"819936", "加世田",
"81144", "苫小牧",
"817672", "羽咋",
"814752", "茂原",
"8188096", "土佐清水",
"8199331", "鹿児島",
"812748", "富岡",
"81726", "茨木",
"81742", "奈良",
"814756", "東金",
"819724", "佐伯",
"817368", "岩出",
"812589", "長岡",
"817940", "加古川",
"818844", "阿南",
"818597", "根雨",
"819802", "南大東",
"818682", "津山",
"818384", "萩",
"8125489", "津川",
"812890", "宇都宮",
"81488", "浦和",
"811984", "花巻",
"819543", "武雄",
"81434", "千葉",
"819806", "沖縄宮古",
"818686", "津山",
"819664", "人吉",
"81578", "神岡",
"811457", "門別富川",
"817459", "大和榛原",
"815987", "三瀬谷",
"8125487", "津川",
"81284", "足利",
"819558", "唐津",
"815954", "上野",
"81565", "豊田",
"81946", "甘木",
"81922", "福岡",
"812486", "須賀川",
"818564", "益田",
"817735", "福知山",
"817733", "福知山",
"817473", "五条",
"818248", "庄原",
"815769", "荘川",
"817475", "下市",
"812482", "白河",
"811957", "岩手",
"817959", "三田",
"819672", "熊本一の宮",
"819823", "延岡",
"818953", "宇和島",
"819825", "日向",
"818955", "宇和島",
"819938", "加世田",
"818479", "東城",
"819676", "高森",
"811647", "羽幌",
"811353", "余市",
"817678", "七尾",
"81729", "八尾",
"817724", "宮津",
"815747", "美濃白川",
"814758", "東金",
"81926", "福岡",
"812742", "藤岡",
"811537", "中標津",
"81942", "久留米",
"81252", "新潟",
"81594", "桑名",
"812653", "飯田",
"815565", "鰍沢青柳",
"812746", "富岡",
"812655", "飯田",
"815563", "鰍沢青柳",
"818948", "宇和",
"818360", "小郡",
"812617", "大町",
"814285", "相模原",
"812785", "沼田",
"814283", "青梅",
"819438", "田主丸",
"812783", "沼田",
"814771", "市川",
"812854", "小山",
"814770", "市川",
"817904", "福崎",
"812245", "大河原",
"811856", "能代",
"81157", "北見",
"812243", "白石",
"81992", "鹿児島",
"81885", "小松島",
"812679", "佐久",
"811852", "男鹿",
"81544", "富士宮",
"812648", "長野",
"819727", "臼杵",
"81722", "堺",
"819556", "唐津",
"818847", "牟岐",
"81178", "八戸",
"81987", "日南",
"818594", "米子",
"818387", "田万川",
"812239", "仙台",
"819552", "伊万里",
"811987", "遠野",
"819667", "水俣",
"818246", "三次",
"812573", "柏崎",
"812575", "十日町",
"81124", "芦別",
"812488", "須賀川",
"819733", "日田",
"811454", "鵡川",
"81949", "直方",
"819735", "日田",
"818242", "東広島",
"81259", "佐渡",
"815984", "松阪",
"819204", "郷ノ浦",
"81568", "春日井",
"817362", "和歌山橋本",
"812956", "常陸大宮",
"818688", "美作",
"819808", "八重山",
"81581", "高富",
"8153962", "天竜",
"817366", "岩出",
"81235", "鶴岡",
"815957", "上野",
"819940", "志布志",
"811525", "網走",
"812559", "安塚",
"811523", "斜里",
"818567", "津和野",
"817238", "寝屋川",
"818652", "倉敷",
"819973", "種子島",
"819975", "名瀬",
"81485", "熊谷",
"81471", "柏",
"811954", "二戸",
"819232", "前原",
"818656", "笠岡",
"812999", "潮来",
"812244", "白石",
"81245", "福島",
"817466", "十津川",
"814220", "国分寺",
"81878", "高松",
"818290", "広島",
"812568", "巻",
"814284", "立川",
"812784", "沼田",
"8125484", "村上",
"817498", "長浜",
"8198298", "日向",
"812855", "小山",
"817903", "福崎",
"817905", "福崎",
"812853", "小山",
"817962", "豊岡",
"819599", "大瀬戸",
"817725", "宮津",
"815752", "関",
"817723", "宮津",
"817966", "八鹿",
"815564", "鰍沢青柳",
"812654", "飯田",
"819968", "出水",
"815756", "郡上八幡",
"811656", "美深",
"8186995", "岡山瀬戸",
"817998", "津名",
"819824", "延岡",
"818954", "宇和島",
"811652", "士別",
"811354", "余市",
"812388", "長井",
"812879", "烏山",
"81939", "北九州",
"81923", "福岡",
"811567", "十勝清水",
"81228", "築館",
"817737", "舞鶴",
"814291", "飯能",
"81478", "佐原",
"819974", "屋久島",
"811524", "網走",
"8198294", "延岡",
"8112396", "栗山",
"8125488", "津川",
"81793", "姫路",
"811953", "二戸",
"811955", "二戸",
"81424", "武蔵野三鷹",
"812830", "宇都宮",
"8147957", "八日市場",
"81534", "浜松",
"81550", "御殿場",
"812418", "会津山口",
"812574", "柏崎",
"81561", "瀬戸",
"8182943", "広島",
"815985", "松阪",
"819205", "厳原",
"815983", "松阪",
"81743", "奈良",
"811455", "鵡川",
"819734", "日田",
"811453", "早来",
"818595", "米子",
"818593", "米子",
"8112391", "夕張",
"81932", "北九州",
"81465", "小田原",
"819547", "鹿島",
"81857", "鳥取",
"817968", "浜坂",
"812247", "大河原",
"819966", "出水",
"815758", "郡上八幡",
"819723", "佐伯",
"819725", "佐伯",
"819962", "川内",
"81936", "北九州",
"81494", "秩父",
"814287", "青梅",
"812787", "沼田",
"81723", "堺",
"8198292", "延岡",
"812386", "長井",
"81739", "田辺",
"817992", "洲本",
"812615", "大町",
"812613", "大町",
"812382", "米沢",
"81298", "土浦",
"811658", "上川",
"817996", "津名",
"811535", "厚岸",
"817468", "上北山",
"811533", "根室",
"815745", "美濃加茂",
"815743", "美濃加茂",
"812566", "三条",
"818669", "総社",
"812657", "伊那",
"812562", "三条",
"811752", "むつ",
"817492", "彦根",
"819827", "高千穂",
"818957", "御荘",
"811756", "野辺地",
"811645", "留萌",
"81958", "長崎",
"811357", "岩内",
"811643", "石狩深川",
"817496", "長浜",
"811564", "上士幌",
"81875", "観音寺",
"817734", "福知山",
"812412", "喜多方",
"8125482", "村上",
"819977", "瀬戸内",
"811527", "美幌",
"818563", "益田",
"811946", "久慈",
"81253", "新潟",
"818565", "益田",
"81188", "秋田",
"812416", "田島",
"81977", "別府",
"81468", "横須賀",
"817474", "五条",
"81134", "小樽",
"811942", "岩泉",
"811639", "利尻礼文",
"811549", "釧路",
"815955", "上野",
"815953", "上野",
"812577", "六日町",
"817702", "敦賀",
"811869", "大館",
"817706", "小浜",
"811551", "十勝池田",
"81585", "揖斐川",
"814700", "鴨川",
"819737", "玖珠",
"814701", "鴨川",
"818383", "萩",
"81225", "石巻",
"818385", "萩",
"818843", "阿南",
"818490", "尾道",
"818845", "丹生谷",
"819663", "人吉",
"819665", "人吉",
"811983", "花巻",
"819544", "武雄",
"815979", "熊野",
"812233", "岩沼",
"812976", "竜ケ崎",
"812235", "仙台",
"817914", "相生",
"81577", "高山",
"81543", "静岡",
"812972", "水海道",
"815977", "熊野",
"812579", "小出",
"818374", "長門",
"819955", "加治木",
"818672", "福渡",
"819953", "大口",
"811867", "鷹巣",
"811974", "水沢",
"81487", "浦和",
"81167", "富良野",
"818676", "久世",
"8186994", "岡山瀬戸",
"819576", "島原",
"81892", "久万",
"81985", "宮崎",
"812476", "三春",
"815737", "中津川",
"811547", "白糠",
"812472", "石川",
"817485", "八日市",
"819572", "諫早",
"817230", "寝屋川",
"817483", "八日市",
"814797", "八日市場",
"81593", "四日市",
"817946", "三木",
"812892", "宇都宮",
"819979", "徳之島",
"811734", "五所川原",
"812555", "糸魚川",
"8199343", "鹿児島",
"819948", "志布志",
"812553", "上越",
"812896", "鹿沼",
"8125485", "津川",
"81734", "和歌山",
"817942", "加古川",
"81262", "長野",
"811637", "北見枝幸",
"818680", "岡山",
"8186998", "岡山瀬戸",
"818473", "甲山",
"818475", "府中",
"812967", "笠間",
"812874", "大田原",
"818204", "柳井",
"81276", "太田",
"818588", "郡家",
"81426", "八王子",
"817357", "串本",
"81849", "福山",
"819594", "有川",
"811876", "大曲",
"819786", "杵築",
"8162", "大阪",
"818556", "江津",
"81220", "迫",
"815998", "阿児",
"818895", "須崎",
"818667", "井原",
"819782", "豊後高田",
"818893", "佐川",
"812659", "伊那",
"818552", "浜田",
"812789", "前橋",
"814289", "青梅",
"818975", "新居浜",
"818973", "新居浜",
"812640", "長野",
"8128798", "大田原",
"818797", "土庄",
"8198295", "日向",
"819743", "三重",
"81899", "松山",
"811375", "八雲",
"818694", "岡山",
"81492", "川越",
"819688", "玉名",
"818808", "土佐清水",
"818837", "阿波池田",
"812994", "石岡",
"817686", "能都",
"818368", "宇部",
"812675", "佐久",
"817682", "輪島",
"812673", "小諸",
"817917", "竜野",
"812585", "長岡",
"812583", "長岡",
"819578", "島原",
"812478", "三春",
"81567", "津島",
"8169", "大阪",
"815974", "尾鷲",
"81988", "那覇",
"81177", "青森",
"812898", "鹿沼",
"818377", "下関",
"81934", "北九州",
"819942", "大根占",
"811864", "大館",
"817455", "大和高田",
"817948", "三木",
"811977", "北上",
"817453", "大和高田",
"819946", "鹿屋",
"81143", "室蘭",
"818240", "東広島",
"815734", "恵那",
"811544", "釧路",
"812978", "竜ケ崎",
"814794", "銚子",
"81950", "平戸",
"8164", "大阪",
"81240", "磐城富岡",
"8161", "大阪",
"81833", "下松",
"811737", "鰺ケ沢",
"812542", "新発田",
"818678", "新見",
"811336", "石狩",
"81272", "前橋",
"817953", "西脇",
"81532", "豊橋",
"817955", "三田",
"815765", "下呂",
"811332", "当別",
"811634", "浜頓別",
"815763", "下呂",
"812546", "村上",
"81555", "吉田",
"812964", "下館",
"81266", "諏訪",
"8112393", "夕張",
"812877", "黒磯",
"8186992", "備前",
"818207", "久賀",
"817354", "新宮",
"818398", "小郡",
"818366", "宇部",
"819597", "福江",
"8182941", "広島",
"818802", "窪川",
"814772", "市川",
"819682", "山鹿",
"819686", "玉名",
"814776", "船橋",
"818806", "宿毛",
"812933", "高萩",
"818664", "高梁",
"818362", "宇部",
"812935", "水戸",
"81896", "伊予三島",
"818543", "安来",
"818545", "木次",
"817688", "能都",
"81460", "小田原",
"818794", "三本松",
"818586", "倉吉",
"8126177", "長野",
"818697", "備前",
"818582", "倉吉",
"814240", "国分寺",
"818834", "鴨島",
"812997", "潮来",
"811462", "浦河",
"815992", "鳥羽",
"8186698", "倉敷",
"8112390", "夕張",
"8144", "川崎",
"81822", "広島",
"819788", "国東",
"81429", "所沢",
"811878", "大曲",
"815996", "阿児",
"818558", "川本",
"81433", "千葉",
"811466", "えりも",
"812557", "新井",
"811398", "熊石",
"811238", "栗山",
"815764", "下呂",
"811635", "浜頓別",
"81765", "魚津",
"81587", "一宮",
"817954", "西脇",
"811543", "釧路",
"811545", "釧路",
"812698", "飯山",
"81227", "仙台",
"81549", "静岡",
"815733", "恵那",
"815588", "修善寺大仁",
"815735", "恵那",
"811362", "倶知安",
"81196", "盛岡",
"8152", "名古屋",
"819913", "硫黄島",
"817487", "水口",
"811366", "寿都",
"814793", "銚子",
"815959", "亀山",
"814795", "銚子",
"8124196", "柳津",
"819957", "加治木",
"811863", "鹿角",
"811865", "大館",
"815368", "設楽",
"811582", "紋別",
"81724", "岸和田貝塚",
"812836", "佐野",
"811586", "中湧別",
"81975", "大分",
"817454", "大和高田",
"812832", "佐野",
"812796", "渋川",
"812584", "長岡",
"811558", "広尾",
"8147955", "八日市場",
"818466", "木江",
"812237", "仙台",
"81778", "武生",
"818878", "嶺北",
"814708", "大原",
"815392", "浜松",
"815973", "尾鷲",
"818462", "竹原",
"812792", "渋川",
"815396", "浜松",
"81493", "東松山",
"8186999", "岡山瀬戸",
"814998", "小笠原",
"818835", "脇町",
"81286", "宇都宮",
"818833", "鴨島",
"817716", "園部",
"812677", "佐久",
"8163", "大阪",
"817712", "亀岡",
"812619", "大町",
"818795", "三本松",
"8186553", "倉敷",
"818793", "三本松",
"8186997", "岡山瀬戸",
"818512", "西郷",
"818977", "伯方",
"81436", "市原",
"811377", "八雲",
"81542", "静岡",
"817960", "八鹿",
"819747", "竹田",
"81877", "丸亀",
"81480", "久喜",
"818268", "千代田",
"817618", "加賀",
"811539", "根室標津",
"812378", "寒河江",
"818544", "木次",
"818665", "高梁",
"81263", "松本",
"818663", "総社",
"812934", "高萩",
"812965", "下館",
"81893", "大洲",
"812963", "下館",
"818292", "広島",
"8111", "札幌",
"818477", "東城",
"81944", "瀬高",
"811936", "宮古",
"814222", "武蔵野三鷹",
"817353", "新宮",
"817355", "新宮",
"81592", "津",
"811932", "釜石",
"814226", "武蔵野三鷹",
"818296", "広島",
"811588", "興部",
"812554", "上越",
"8188090", "窪川",
"811735", "五所川原",
"815362", "新城",
"81596", "伊勢",
"811733", "五所川原",
"81775", "大津",
"815767", "下呂",
"815366", "設楽",
"81924", "福岡",
"812838", "佐野",
"8183766", "下関",
"817957", "丹波柏原",
"811552", "帯広",
"815398", "浜松",
"814702", "館山",
"818872", "室戸",
"81467", "藤沢",
"814298", "飯能",
"811556", "帯広",
"812798", "長野原",
"812911", "鉾田",
"817484", "八日市",
"818876", "土佐山田",
"814706", "大原",
"818375", "美祢",
"811392", "木古内",
"81199", "盛岡",
"819954", "加治木",
"818373", "長門",
"81965", "八代",
"81546", "静岡",
"811232", "千歳",
"81823", "呉",
"811396", "江差",
"817457", "大和高田",
"811975", "水沢",
"81839", "山口",
"81432", "千葉",
"811236", "千歳",
"811973", "水沢",
"8188093", "窪川",
"817915", "相生",
"812692", "中野",
"812587", "長岡",
"815582", "下田",
"812234", "仙台",
"812696", "飯山",
"815586", "下田",
"81282", "栃木",
"812376", "寒河江",
"818262", "加計",
"812993", "石岡",
"817612", "小松",
"812995", "石岡",
"812674", "小諸",
"818266", "千代田",
"812372", "村山",
"817616", "小松",
"81126", "岩見沢",
"81142", "伊達",
"81551", "韮崎",
"814228", "武蔵野三鷹",
"818974", "新居浜",
"818298", "廿日市",
"812560", "糸魚川",
"811374", "森",
"818693", "邑久",
"812859", "小山",
"81744", "大和高田",
"818695", "岡山瀬戸",
"819744", "三重",
"811938", "宮古",
"813", "東京",
"81832", "下関",
"814992", "伊豆大島",
"81439", "木更津",
"8186697", "倉敷",
"819593", "大瀬戸",
"81423", "国分寺",
"819595", "有川",
"81273", "高崎",
"814996", "八丈島",
"81533", "豊橋",
"818547", "掛合",
"81192", "大船渡",
"818894", "須崎",
"817718", "園部",
"812937", "水戸",
"818474", "府中",
"812873", "大田原",
"818203", "柳井",
"812875", "大田原",
"818205", "柳井",};
$areanames{en} = {"812934", "Takahagi\,\ Ibaraki",
"818663", "Soja\,\ Okayama",
"81263", "Matsumoto\,\ Nagano",
"818665", "Takahashi\,\ Okayama",
"812414", "Yanaizu\,\ Fukushima",
"812578", "Muika\,\ Niigata",
"817732", "Fukuchiyama\,\ Kyoto",
"818544", "Kisuki\,\ Shimane",
"812549", "Tsugawa\,\ Niigata",
"812378", "Sagae\,\ Yamagata",
"817476", "Shimonoseki\,\ Yamaguchi",
"817736", "Maizuru\,\ Kyoto",
"81438", "Kisarazu\,\ Chiba",
"817618", "Kaga\,\ Ishikawa",
"812485", "Shirakawa\,\ Fukushima",
"811944", "Iwaizumi\,\ Iwate",
"812483", "Shirakawa\,\ Fukushima",
"819738", "Kusu\,\ Oita",
"81484", "Kawaguchi\,\ Saitama",
"812230", "Sendai\,\ Miyagi",
"818296", "Hiroshima\,\ Hiroshima",
"811932", "Kamaishi\,\ Iwate",
"81592", "Tsu\,\ Mie",
"817355", "Shingu\,\ Fukuoka",
"817353", "Shingu\,\ Fukuoka",
"81944", "Setaka\,\ Fukuoka",
"811936", "Miyako\,\ Iwate",
"81762", "Kanazawa\,\ Ishikawa",
"818477", "Tojo\,\ Hiroshima",
"8111", "Sapporo\,\ Hokkaido",
"8126172", "Omachi\,\ Nagano",
"81288", "Imabari\,\ Ehime",
"818292", "Hiroshima\,\ Hiroshima",
"812963", "Shimodate\,\ Ibaraki",
"81234", "Sakata\,\ Yamagata",
"81893", "Ozu\,\ Ehime",
"812965", "Shimodate\,\ Ibaraki",
"817704", "Tsuruga\,\ Fukui",
"81125", "Takikawa\,\ Hokkaido",
"812914", "Hokota\,\ Ibaraki",
"817712", "Kameoka\,\ Kyoto",
"819978", "Tokunoshima\,\ Kagoshima",
"8163", "Osaka\,\ Osaka",
"811528", "Bihoro\,\ Hokkaido",
"81940", "Munakata\,\ Fukuoka",
"8165", "Osaka\,\ Osaka",
"812677", "Saku\,\ Nagano",
"81250", "Niitsu\,\ Niigata",
"817716", "Sonobe\,\ Kyoto",
"818833", "Kamojima\,\ Tokushima",
"818835", "Mima\,\ Tokushima",
"81286", "Utsunomiya\,\ Tochigi",
"8153979", "Hamamatsu\,\ Shizuoka",
"81737", "Yuasa\,\ Wakayama",
"814998", "Ogasawara\,\ Tokyo",
"8186999", "Seto\,\ Okayama",
"818683", "Tsuyama\,\ Okayama",
"819803", "Nago\,\ Okinawa",
"819805", "Nago\,\ Okinawa",
"81877", "Marugame\,\ Kagawa",
"818685", "Tsuyama\,\ Okayama",
"81480", "Kuki\,\ Saitama",
"819747", "Taketa\,\ Oita",
"819546", "Kashima\,\ Saga",
"811377", "Yakumo\,\ Hokkaido",
"81542", "Shizuoka\,\ Shizuoka",
"812551", "Joetsu\,\ Niigata",
"812550", "Yasuzuka\,\ Niigata",
"81436", "Ichihara\,\ Chiba",
"818977", "Hakata\,\ Ehime",
"8186997", "Seto\,\ Okayama",
"818512", "Nishigo\,\ Fukushima",
"8186553", "Kurashiki\,\ Okayama",
"812619", "Omachi\,\ Nagano",
"819542", "Takeo\,\ Saga",
"812832", "Sano\,\ Tochigi",
"817454", "Yamatotakada\,\ Nara",
"815999", "Tsu\,\ Mie",
"814753", "Mobara\,\ Chiba",
"811586", "Nakayubetsu\,\ Hokkaido",
"814755", "Togane\,\ Chiba",
"81975", "Oita\,\ Oita",
"812658", "Ina\,\ Nagano",
"812836", "Sano\,\ Tochigi",
"8188095", "Tosashimizu\,\ Kochi",
"811865", "Odate\,\ Akita",
"815368", "Shitara\,\ Aichi",
"811582", "Monbetsu\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"819957", "Kajiki\,\ Kagoshima",
"811863", "Kazuno\,\ Akita",
"8124196", "Yanaizu\,\ Fukushima",
"819964", "Satsumasendai\,\ Kagoshima",
"819935", "Kaseda\,\ Kagoshima",
"81493", "Higashimatsuyama\,\ Saitama",
"819933", "Ibusuki\,\ Kagoshima",
"812792", "Shibukawa\,\ Gunma",
"819828", "Takachiho\,\ Miyazaki",
"817994", "Sumoto\,\ Hyogo",
"818462", "Takehara\,\ Hiroshima",
"818958", "Misho\,\ Ehime",
"815973", "Owase\,\ Mie",
"815392", "Hamamatsu\,\ Shizuoka",
"81778", "Takefu\,\ Fukui",
"812237", "Sendai\,\ Miyagi",
"817675", "Nanao\,\ Ishikawa",
"812384", "Yonezawa\,\ Yamagata",
"817673", "Hakui\,\ Ishikawa",
"818466", "Mima\,\ Tokushima",
"8147955", "Yokaichiba\,\ Chiba",
"812584", "Nagaoka\,\ Niigata",
"811558", "Hiroo\,\ Hokkaido",
"812796", "Shibukawa\,\ Gunma",
"817954", "Nishiwaki\,\ Hyogo",
"81587", "Ichinomiya\,\ Aichi",
"81765", "Uozu\,\ Toyama",
"81983", "Takanabe\,\ Miyazaki",
"812248", "Ogawara\,\ Miyagi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"815764", "Gero\,\ Gifu",
"811238", "Kuriyama\,\ Hokkaido",
"818369", "Ube\,\ Yamaguchi",
"81776", "Fukui\,\ Fukui",
"811398", "Kumaishi\,\ Hokkaido",
"812564", "Sanjo\,\ Niigata",
"814288", "Ome\,\ Tokyo",
"814795", "Choshi\,\ Chiba",
"81979", "Nakatsu\,\ Oita",
"819433", "Yame\,\ Fukuoka",
"811754", "Mutsu\,\ Aomori",
"812788", "Maebashi\,\ Gunma",
"811366", "Suttsu\,\ Hokkaido",
"817487", "Minakuchi\,\ Shiga",
"815959", "Kameyama\,\ Mie",
"814793", "Choshi\,\ Chiba",
"819435", "Yame\,\ Fukuoka",
"818945", "Yawatahama\,\ Ehime",
"817494", "Hikone\,\ Shiga",
"818943", "Yawatahama\,\ Ehime",
"8152", "Nagoya\,\ Aichi",
"815735", "Ena\,\ Gifu",
"81196", "Morioka\,\ Iwate",
"811362", "Kutchan\,\ Hokkaido",
"815733", "Ena\,\ Gifu",
"81549", "Shizuoka\,\ Shizuoka",
"812698", "Iiyama\,\ Nagano",
"811562", "Honbetsu\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"811545", "Kushiro\,\ Hokkaido",
"8145", "Yokohama\,\ Kanagawa",
"8153965", "Hamamatsu\,\ Shizuoka",
"811543", "Kushiro\,\ Hokkaido",
"812899", "Kanuma\,\ Tochigi",
"81937", "Kitakyushu\,\ Fukuoka",
"812937", "Mito\,\ Ibaraki",
"81553", "Yamanashi\,\ Yamanashi",
"817718", "Sonobe\,\ Kyoto",
"8183768", "Shimonoseki\,\ Yamaguchi",
"818894", "Susaki\,\ Kochi",
"818655", "Kamogata\,\ Okayama",
"81192", "Ofunato\,\ Iwate",
"81174", "Kanita\,\ Aomori",
"818547", "Kakeya\,\ Shimane",
"81533", "Toyohashi\,\ Aichi",
"811522", "Shari\,\ Hokkaido",
"812580", "Tokamachi\,\ Niigata",
"81273", "Takasaki\,\ Gunma",
"817949", "Kakogawa\,\ Hyogo",
"81423", "Kokubunji\,\ Tokyo",
"819976", "Naze\,\ Kagoshima",
"81852", "Matsue\,\ Shimane",
"819593", "Oseto\,\ Nagasaki",
"819233", "Maebaru\,\ Fukuoka",
"81740", "Imazu\,\ Shiga",
"811947", "Kuji\,\ Iwate",
"811526", "Abashiri\,\ Hokkaido",
"8186697", "Kurashiki\,\ Okayama",
"81439", "Kisarazu\,\ Chiba",
"81832", "Shimonoseki\,\ Yamaguchi",
"813", "Tokyo",
"818205", "Yanai\,\ Yamaguchi",
"812875", "Otawara\,\ Tochigi",
"8126178", "Omachi\,\ Nagano",
"818203", "Yanai\,\ Yamaguchi",
"812873", "Otawara\,\ Tochigi",
"8182920", "Hatsukaichi\,\ Hiroshima",
"818474", "Fuchu\,\ Hiroshima",
"81564", "Okazaki\,\ Aichi",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"817707", "Obama\,\ Fukui",
"817738", "Maizuru\,\ Kyoto",
"81551", "Nirasaki\,\ Yamanashi",
"81142", "Date\,\ Hokkaido",
"812917", "Mito\,\ Ibaraki",
"812572", "Kashiwazaki\,\ Niigata",
"81126", "Iwamizawa\,\ Hokkaido",
"817616", "Komatsu\,\ Ishikawa",
"818679", "Niimi\,\ Okayama",
"81531", "Tahara\,\ Aichi",
"812372", "Murayama\,\ Yamagata",
"812674", "Komoro\,\ Nagano",
"817612", "Komatsu\,\ Ishikawa",
"812995", "Ishioka\,\ Ibaraki",
"812993", "Ishioka\,\ Ibaraki",
"812576", "Tokamachi\,\ Niigata",
"818262", "Kake\,\ Hiroshima",
"819732", "Hita\,\ Oita",
"818245", "Miyoshi\,\ Hiroshima",
"818243", "Higashi\-ku\,\ Hiroshima",
"812376", "Sagae\,\ Yamagata",
"811938", "Miyako\,\ Iwate",
"819744", "Mie\,\ Oita",
"818695", "Seto\,\ Okayama",
"81962", "Kumamoto\,\ Kumamoto",
"812859", "Oyama\,\ Tochigi",
"817950", "Sanda\,\ Hyogo",
"81744", "Yamatotakada\,\ Nara",
"811374", "Mori\,\ Hokkaido",
"818693", "Oku\,\ Okayama",
"818298", "Hatsukaichi\,\ Hiroshima",
"812560", "Itoigawa\,\ Niigata",
"818974", "Niihama\,\ Ehime",
"819553", "Imari\,\ Saga",
"819555", "Karatsu\,\ Saga",
"811973", "Mizusawa\,\ Iwate",
"81432", "Chiba\,\ Chiba",
"811236", "Chitose\,\ Hokkaido",
"811975", "Mizusawa\,\ Iwate",
"81839", "Yamaguchi\,\ Yamaguchi",
"817464", "Yoshino\,\ Nara",
"817457", "Yamatotakada\,\ Nara",
"8126171", "Omachi\,\ Nagano",
"811396", "Esashi\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"812242", "Shiroishi\,\ Miyagi",
"811232", "Chitose\,\ Hokkaido",
"81965", "Yatsushiro\,\ Kumamoto",
"81546", "Shizuoka\,\ Shizuoka",
"811855", "Noshiro\,\ Akita",
"8126174", "Omachi\,\ Nagano",
"818373", "Nagato\,\ Yamaguchi",
"812246", "Ogawara\,\ Miyagi",
"819954", "Kajiki\,\ Kagoshima",
"819967", "Izumi\,\ Kagoshima",
"818375", "Mine\,\ Yamaguchi",
"811853", "Oga\,\ Akita",
"81199", "Morioka\,\ Iwate",
"811392", "Kikonai\,\ Hokkaido",
"81282", "Tochigi\,\ Tochigi",
"815586", "Shimoda\,\ Shizuoka",
"812782", "Numata\,\ Gunma",
"814282", "Ome\,\ Tokyo",
"812696", "Iiyama\,\ Nagano",
"817997", "Tsuna\,\ Hyogo",
"812930", "Mito\,\ Ibaraki",
"812786", "Numata\,\ Gunma",
"814286", "Sagamihara\,\ Kanagawa",
"812234", "Sendai\,\ Miyagi",
"812387", "Nagai\,\ Yamagata",
"815582", "Shimoda\,\ Shizuoka",
"81779", "Ono\,\ Gifu",
"812587", "Nagaoka\,\ Niigata",
"812692", "Nakano\,\ Nagano",
"817915", "Aioi\,\ Hyogo",
"812743", "Fujioka\,\ Gunma",
"8183766", "Shimonoseki\,\ Yamaguchi",
"815566", "Minobu\,\ Yamanashi",
"817964", "Toyooka\,\ Hyogo",
"81924", "Fukuoka\,\ Fukuoka",
"812838", "Sano\,\ Tochigi",
"812656", "Ina\,\ Nagano",
"81766", "Takaoka\,\ Toyama",
"812745", "Fujioka\,\ Gunma",
"815366", "Shitara\,\ Aichi",
"815754", "Sekigahara\,\ Gifu",
"815767", "Gero\,\ Gifu",
"81775", "Otsu\,\ Shiga",
"812652", "Iida\,\ Nagano",
"819789", "Kitsuki\,\ Oita",
"818559", "Kawamoto\,\ Shimane",
"811733", "Goshogawara\,\ Aomori",
"811588", "Okoppe\,\ Hokkaido",
"815362", "Shinshiro\,\ Aichi",
"81596", "Ise\,\ Mie",
"811735", "Goshogawara\,\ Aomori",
"812554", "Joetsu\,\ Niigata",
"811757", "Noheji\,\ Aomori",
"8126176", "Omachi\,\ Nagano",
"817484", "Yokaichi\,\ Shiga",
"811356", "Iwanai\,\ Hokkaido",
"818952", "Uwajima\,\ Ehime",
"81835", "Hofu\,\ Yamaguchi",
"819822", "Nobeoka\,\ Miyazaki",
"817497", "Nagahama\,\ Shiga",
"812911", "Hokota\,\ Ibaraki",
"812798", "Naganohara\,\ Gunma",
"81467", "Fujisawa\,\ Kanagawa",
"811556", "Obihiro\,\ Hokkaido",
"814298", "Hanno\,\ Saitama",
"811352", "Yoichi\,\ Hokkaido",
"81969", "Amakusa\,\ Kumamoto",
"811654", "Nayoro\,\ Hokkaido",
"815398", "Hamamatsu\,\ Shizuoka",
"818872", "Muroto\,\ Kochi",
"814702", "Tateyama\,\ Chiba",
"81548", "Haibara\,\ Shizuoka",
"811552", "Obihiro\,\ Hokkaido",
"818956", "Uwajima\,\ Ehime",
"8147950", "Yokaichiba\,\ Chiba",
"819826", "Hyuga\,\ Miyazaki",
"81492", "Kawagoe\,\ Saitama",
"818694", "Okayama\,\ Okayama",
"81899", "Matsuyama\,\ Ehime",
"811375", "Yakumo\,\ Hokkaido",
"819743", "Mie\,\ Oita",
"8198295", "Hyuga\,\ Miyazaki",
"818687", "Mimasaka\,\ Okayama",
"81474", "Funabashi\,\ Chiba",
"818592", "Yonago\,\ Tottori",
"812640", "Nagano\,\ Nagano",
"819554", "Imari\,\ Saga",
"8128798", "Otawara\,\ Tochigi",
"818797", "Tonosho\,\ Kagawa",
"818973", "Niihama\,\ Ehime",
"815958", "Kameyama\,\ Mie",
"818596", "Yonago\,\ Tottori",
"818975", "Niihama\,\ Ehime",
"814289", "Ome\,\ Tokyo",
"812789", "Maebashi\,\ Gunma",
"812673", "Komoro\,\ Nagano",
"817682", "Wajima\,\ Ishikawa",
"818568", "Tsuwano\,\ Shimane",
"812675", "Saku\,\ Nagano",
"815986", "Matsusaka\,\ Mie",
"81845", "Innoshima\,\ Hiroshima",
"818368", "Ube\,\ Yamaguchi",
"817686", "Noto\,\ Ishikawa",
"818244", "Miyoshi\,\ Hiroshima",
"811452", "Hayakita\,\ Hokkaido",
"81584", "Ogaki\,\ Gifu",
"812994", "Ishioka\,\ Ibaraki",
"815982", "Matsusaka\,\ Mie",
"81538", "Iwata\,\ Shizuoka",
"811541", "Teshikaga\,\ Hokkaido",
"818808", "Tosashimizu\,\ Kochi",
"819688", "Tamana\,\ Kumamoto",
"811559", "Obihiro\,\ Hokkaido",
"81849", "Fukuyama\,\ Hiroshima",
"8178", "Kobe\,\ Hyogo",
"817357", "Kushimoto\,\ Wakayama",
"81426", "Hachioji\,\ Tokyo",
"81276", "Ota\,\ Gunma",
"818588", "Koge\,\ Tottori",
"818204", "Yanai\,\ Yamaguchi",
"812874", "Otawara\,\ Tochigi",
"818879", "Muroto\,\ Kochi",
"814709", "Kamogawa\,\ Chiba",
"818388", "Tamagawa\,\ Yamaguchi",
"8153978", "Hamamatsu\,\ Shizuoka",
"812967", "Kasama\,\ Ibaraki",
"818475", "Fuchu\,\ Hiroshima",
"8186998", "Seto\,\ Okayama",
"819668", "Minamata\,\ Kumamoto",
"818552", "Hamada\,\ Shimane",
"811956", "Iwate\,\ Iwate",
"812659", "Ina\,\ Nagano",
"818893", "Sakawa\,\ Kochi",
"819782", "Bungotakada\,\ Oita",
"81727", "Ikeda\,\ Osaka",
"818667", "Ibara\,\ Okayama",
"818654", "Kamogata\,\ Okayama",
"818895", "Susaki\,\ Kochi",
"812487", "Sukagawa\,\ Fukushima",
"811952", "Ninohe\,\ Iwate",
"8124197", "Yanaizu\,\ Fukushima",
"815998", "Ago\,\ Mie",
"818556", "Gotsu\,\ Shimane",
"8162", "Osaka\,\ Osaka",
"8112395", "Kuriyama\,\ Hokkaido",
"819786", "Kitsuki\,\ Oita",
"811876", "Omagari\,\ Akita",
"818947", "Uwajima\,\ Ehime",
"812618", "Omachi\,\ Nagano",
"814797", "Yokaichiba\,\ Chiba",
"817483", "Yokaichi\,\ Shiga",
"81593", "Yokkaichi\,\ Mie",
"817230", "Neyagawa\,\ Osaka",
"819572", "Isahaya\,\ Nagasaki",
"817485", "Yokaichi\,\ Shiga",
"819437", "Tanushimaru\,\ Fukuoka",
"812472", "Ishikawa\,\ Fukushima",
"81763", "Fukuno\,\ Toyama",
"8153976", "Hamamatsu\,\ Shizuoka",
"811547", "Shiranuka\,\ Hokkaido",
"815737", "Nakatsugawa\,\ Gifu",
"8186996", "Seto\,\ Okayama",
"811653", "Shibetsu\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"81985", "Miyazaki\,\ Miyazaki",
"819576", "Shimabara\,\ Nagasaki",
"81892", "Kumakogen\,\ Ehime",
"811655", "Nayoro\,\ Hokkaido",
"818680", "Okayama\,\ Okayama",
"815753", "Sekigahara\,\ Gifu",
"815755", "Sekigahara\,\ Gifu",
"81262", "Nagano\,\ Nagano",
"817722", "Miyazu\,\ Kyoto",
"81734", "Wakayama\,\ Wakayama",
"817942", "Kakogawa\,\ Hyogo",
"8125485", "Tsugawa\,\ Niigata",
"817965", "Toyooka\,\ Hyogo",
"812744", "Fujioka\,\ Gunma",
"812896", "Kanuma\,\ Tochigi",
"817963", "Toyooka\,\ Hyogo",
"819948", "Shibushi\,\ Kagoshima",
"812553", "Joetsu\,\ Niigata",
"8199343", "Kagoshima\,\ Kagoshima",
"811734", "Goshogawara\,\ Aomori",
"812555", "Itoigawa\,\ Niigata",
"812647", "Nagano\,\ Nagano",
"812892", "Utsunomiya\,\ Tochigi",
"819979", "Tokunoshima\,\ Kagoshima",
"81828", "Hiroshima\,\ Hiroshima",
"819728", "Usuki\,\ Oita",
"817946", "Miki\,\ Hyogo",
"818660", "Seto\,\ Okayama",
"815977", "Kumano\,\ Mie",
"812856", "Mooka\,\ Tochigi",
"81947", "Tagawa\,\ Fukuoka",
"8182942", "Hiroshima\,\ Hiroshima",
"819937", "Kaseda\,\ Kagoshima",
"81591", "Tsu\,\ Mie",
"81543", "Shizuoka\,\ Shizuoka",
"817902", "Fukusaki\,\ Hyogo",
"81577", "Takayama\,\ Gifu",
"812852", "Oyama\,\ Tochigi",
"817914", "Aioi\,\ Hyogo",
"817677", "Nanao\,\ Ishikawa",
"812235", "Sendai\,\ Miyagi",
"812233", "Iwanuma\,\ Miyagi",
"814757", "Togane\,\ Chiba",
"8186994", "Seto\,\ Okayama",
"818676", "Kuse\,\ Okayama",
"81167", "Furano\,\ Hokkaido",
"817463", "Yoshino\,\ Nara",
"81487", "Urawa\,\ Saitama",
"817465", "Yoshino\,\ Nara",
"811974", "Mizusawa\,\ Iwate",
"81989", "Naha\,\ Okinawa",
"819953", "Okuchi\,\ Kagoshima",
"811867", "Takanosu\,\ Akita",
"811854", "Oga\,\ Akita",
"819955", "Kajiki\,\ Kagoshima",
"81495", "Honjo\,\ Saitama",
"818374", "Nagato\,\ Yamaguchi",
"8153971", "Hamamatsu\,\ Shizuoka",
"818582", "Kurayoshi\,\ Tottori",
"814240", "Kokubunji\,\ Tokyo",
"818697", "Bizen\,\ Okayama",
"818842", "Anan\,\ Tokushima",
"811986", "Tono\,\ Iwate",
"81898", "Imabari\,\ Ehime",
"818382", "Hagi\,\ Yamaguchi",
"818684", "Tsuyama\,\ Okayama",
"819804", "Nago\,\ Okinawa",
"819666", "Minamata\,\ Kumamoto",
"812799", "Naganohara\,\ Gunma",
"81138", "Hakodate\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"818586", "Kurayoshi\,\ Tottori",
"819557", "Karatsu\,\ Saga",
"819662", "Hitoyoshi\,\ Kumamoto",
"81184", "Yurihonjo\,\ Akita",
"81464", "Atsugi\,\ Kanagawa",
"811466", "Erimo\,\ Hokkaido",
"81433", "Chiba\,\ Chiba",
"8126179", "Omachi\,\ Nagano",
"811589", "Okoppe\,\ Hokkaido",
"818558", "Kawamoto\,\ Shimane",
"815996", "Ago\,\ Mie",
"817705", "Obama\,\ Fukui",
"811878", "Omagari\,\ Akita",
"819788", "Kunisaki\,\ Oita",
"81429", "Tokorozawa\,\ Saitama",
"817703", "Tsuruga\,\ Fukui",
"8198293", "Nobeoka\,\ Miyazaki",
"81822", "Hiroshima\,\ Hiroshima",
"812913", "Hokota\,\ Ibaraki",
"8183767", "Shimonoseki\,\ Yamaguchi",
"8186698", "Kurashiki\,\ Okayama",
"81927", "Fukuoka\,\ Fukuoka",
"8144", "Kawasaki\,\ Kanagawa",
"8112390", "Yubari\,\ Hokkaido",
"815992", "Toba\,\ Mie",
"818247", "Shobara\,\ Hiroshima",
"81268", "Ueda\,\ Nagano",
"811462", "Urakawa\,\ Hokkaido",
"811958", "Iwate\,\ Iwate",
"812839", "Sano\,\ Tochigi",
"812997", "Itako\,\ Ibaraki",
"81559", "Numazu\,\ Shizuoka",
"818834", "Kamojima\,\ Tokushima",
"817367", "Iwade\,\ Wakayama",
"818398", "Ogori\,\ Yamaguchi",
"81281", "Utsunomiya\,\ Tochigi",
"817354", "Shingu\,\ Fukuoka",
"8153972", "Hamamatsu\,\ Shizuoka",
"81425", "Tachikawa\,\ Tokyo",
"8186992", "Bizen\,\ Okayama",
"812877", "Kuroiso\,\ Tochigi",
"8198290", "Nobeoka\,\ Miyazaki",
"81848", "Onomichi\,\ Hiroshima",
"8112393", "Yubari\,\ Hokkaido",
"81266", "Suwa\,\ Nagano",
"812957", "Daigo\,\ Ibaraki",
"81555", "Fujiyoshida\,\ Yamanashi",
"812964", "Shimodate\,\ Ibaraki",
"81535", "Hamamatsu\,\ Shizuoka",
"81460", "Odawara\,\ Kanagawa",
"818562", "Masuda\,\ Shimane",
"817688", "Noto\,\ Ishikawa",
"818545", "Kisuki\,\ Shimane",
"818543", "Yasugi\,\ Shimane",
"818362", "Ube\,\ Yamaguchi",
"81896", "Iyomishima\,\ Ehime",
"812935", "Mito\,\ Ibaraki",
"812413", "Kitakata\,\ Fukushima",
"819686", "Tamana\,\ Kumamoto",
"818806", "Sukumo\,\ Kochi",
"814776", "Funabashi\,\ Chiba",
"818664", "Takahashi\,\ Okayama",
"812415", "Yanaizu\,\ Fukushima",
"812933", "Takahagi\,\ Ibaraki",
"818657", "Kasaoka\,\ Okayama",
"811945", "Kuji\,\ Iwate",
"812484", "Shirakawa\,\ Fukushima",
"811943", "Iwaizumi\,\ Iwate",
"814772", "Ichikawa\,\ Chiba",
"819682", "Yamaga\,\ Kumamoto",
"8182941", "Hiroshima\,\ Hiroshima",
"819597", "Fukue\,\ Nagasaki",
"818366", "Ube\,\ Yamaguchi",
"818944", "Yawatahama\,\ Ehime",
"8161", "Osaka\,\ Osaka",
"8164", "Osaka\,\ Osaka",
"817495", "Nagahama\,\ Shiga",
"81864", "Kurashiki\,\ Okayama",
"81950", "Hirado\,\ Nagasaki",
"817493", "Hikone\,\ Shiga",
"814794", "Choshi\,\ Chiba",
"811646", "Haboro\,\ Hokkaido",
"8125483", "Murakami\,\ Niigata",
"818299", "Hiroshima\,\ Hiroshima",
"811753", "Mutsu\,\ Aomori",
"819434", "Yame\,\ Fukuoka",
"81930", "Yukuhashi\,\ Fukuoka",
"812858", "Mooka\,\ Tochigi",
"811544", "Kushiro\,\ Hokkaido",
"8199345", "Kagoshima\,\ Kagoshima",
"815734", "Ena\,\ Gifu",
"8186691", "Kurashiki\,\ Okayama",
"811939", "Miyako\,\ Iwate",
"81986", "Miyakonojo\,\ Miyazaki",
"818240", "Higashi\-ku\,\ Hiroshima",
"811634", "Hamatonbetsu\,\ Hokkaido",
"815763", "Gero\,\ Gifu",
"81552", "Kofu\,\ Yamanashi",
"812546", "Murakami\,\ Niigata",
"815742", "Minokamo\,\ Gifu",
"811332", "Tobetsu\,\ Hokkaido",
"815765", "Gero\,\ Gifu",
"817955", "Sanda\,\ Hyogo",
"81532", "Toyohashi\,\ Aichi",
"817953", "Nishiwaki\,\ Hyogo",
"812747", "Tomioka\,\ Gunma",
"811532", "Nemuro\,\ Hokkaido",
"818690", "Okayama\,\ Okayama",
"815746", "Minokamo\,\ Gifu",
"81272", "Maebashi\,\ Gunma",
"812563", "Sanjo\,\ Niigata",
"811336", "Ishikari\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"81853", "Izumo\,\ Shimane",
"818678", "Niimi\,\ Okayama",
"812542", "Shibata\,\ Niigata",
"811536", "Akkeshi\,\ Hokkaido",
"81833", "Kudamatsu\,\ Yamaguchi",
"81294", "Hitachiota\,\ Ibaraki",
"817993", "Sumoto\,\ Hyogo",
"815974", "Owase\,\ Mie",
"8169", "Osaka\,\ Osaka",
"817995", "Sumoto\,\ Hyogo",
"812612", "Omachi\,\ Nagano",
"81567", "Tsushima\,\ Aichi",
"819934", "Ibusuki\,\ Kagoshima",
"812478", "Miharu\,\ Fukushima",
"819578", "Shimabara\,\ Nagasaki",
"81963", "Kumamoto\,\ Kumamoto",
"812583", "Nagaoka\,\ Niigata",
"812616", "Omachi\,\ Nagano",
"812585", "Nagaoka\,\ Niigata",
"81825", "Hiroshima\,\ Hiroshima",
"812383", "Yonezawa\,\ Yamagata",
"817674", "Hakui\,\ Ishikawa",
"812385", "Yonezawa\,\ Yamagata",
"81797", "Nishinomiya\,\ Hyogo",
"819946", "Kanoya\,\ Kagoshima",
"81143", "Muroran\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"814754", "Mobara\,\ Chiba",
"817453", "Yamatotakada\,\ Nara",
"811977", "Kitakami\,\ Iwate",
"8125480", "Murakami\,\ Niigata",
"819726", "Usuki\,\ Oita",
"817455", "Yamatotakada\,\ Nara",
"817948", "Miki\,\ Hyogo",
"811864", "Odate\,\ Akita",
"819963", "Satsumasendai\,\ Kagoshima",
"811857", "Noshiro\,\ Akita",
"81934", "Kitakyushu\,\ Fukuoka",
"819965", "Satsumasendai\,\ Kagoshima",
"818377", "Shimonoseki\,\ Yamaguchi",
"81244", "Hobara\,\ Fukushima",
"819722", "Saiki\,\ Oita",
"81177", "Aomori\,\ Aomori",
"812898", "Kanuma\,\ Tochigi",
"81988", "Naha\,\ Okinawa",
"812676", "Saku\,\ Nagano",
"811453", "Hayakita\,\ Hokkaido",
"819734", "Hita\,\ Oita",
"81586", "Ichinomiya\,\ Aichi",
"811455", "Mukawa\,\ Hokkaido",
"815983", "Matsusaka\,\ Mie",
"817614", "Komatsu\,\ Ishikawa",
"81743", "Nara\,\ Nara",
"81420", "Tokorozawa\,\ Saitama",
"815985", "Matsusaka\,\ Mie",
"81270", "Isesaki\,\ Gunma",
"8167", "Osaka\,\ Osaka",
"817683", "Wajima\,\ Ishikawa",
"8182943", "Hiroshima\,\ Hiroshima",
"812374", "Murayama\,\ Yamagata",
"8175", "Kyoto\,\ Kyoto",
"817685", "Wajima\,\ Ishikawa",
"81561", "Seto\,\ Aichi",
"812672", "Komoro\,\ Nagano",
"812574", "Kashiwazaki\,\ Niigata",
"8153969", "Hamamatsu\,\ Shizuoka",
"81550", "Gotenba\,\ Shizuoka",
"817717", "Sonobe\,\ Kyoto",
"812938", "Mito\,\ Ibaraki",
"811376", "Yakumo\,\ Hokkaido",
"81857", "Tottori\,\ Tottori",
"819547", "Kashima\,\ Saga",
"8198296", "Hyuga\,\ Miyazaki",
"81465", "Odawara\,\ Kanagawa",
"819746", "Taketa\,\ Oita",
"8112394", "Yubari\,\ Hokkaido",
"818972", "Niihama\,\ Ehime",
"81932", "Kitakyushu\,\ Fukuoka",
"8153967", "Hamamatsu\,\ Shizuoka",
"811372", "Shikabe\,\ Hokkaido",
"8112391", "Yubari\,\ Hokkaido",
"818976", "Niihama\,\ Ehime",
"81952", "Saga\,\ Saga",
"818593", "Yonago\,\ Tottori",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81476", "Narita\,\ Chiba",
"819742", "Mie\,\ Oita",
"81226", "Kesennuma\,\ Miyagi",
"818595", "Yonago\,\ Tottori",
"81862", "Okayama\,\ Okayama",
"811955", "Ninohe\,\ Iwate",
"8198291", "Nobeoka\,\ Miyazaki",
"811953", "Ninohe\,\ Iwate",
"818896", "Susaki\,\ Kochi",
"8125488", "Tsugawa\,\ Niigata",
"81793", "Himeji\,\ Hyogo",
"818555", "Gotsu\,\ Shimane",
"8112396", "Kuriyama\,\ Hokkaido",
"811524", "Abashiri\,\ Hokkaido",
"818553", "Hamada\,\ Shimane",
"81563", "Nishio\,\ Aichi",
"8188097", "Tosashimizu\,\ Kochi",
"8198294", "Nobeoka\,\ Miyazaki",
"819783", "Bungotakada\,\ Oita",
"819974", "Yakushima\,\ Kagoshima",
"811873", "Kakunodate\,\ Akita",
"81478", "Sawara\,\ Chiba",
"819785", "Bungotakada\,\ Oita",
"817737", "Maizuru\,\ Kyoto",
"811875", "Kakunodate\,\ Akita",
"818892", "Sakawa\,\ Kochi",
"814291", "Hanno\,\ Saitama",
"819679", "Takamori\,\ Kumamoto",
"81554", "Otsuki\,\ Yamanashi",
"818297", "Hatsukaichi\,\ Hiroshima",
"81534", "Hamamatsu\,\ Shizuoka",
"8147957", "Yokaichiba\,\ Chiba",
"812830", "Utsunomiya\,\ Tochigi",
"81292", "Mito\,\ Ibaraki",
"8188099", "Tosashimizu\,\ Kochi",
"811937", "Miyako\,\ Iwate",
"818476", "Fuchu\,\ Hiroshima",
"819968", "Izumi\,\ Kagoshima",
"812552", "Joetsu\,\ Niigata",
"8125486", "Tsugawa\,\ Niigata",
"812654", "Iida\,\ Nagano",
"812895", "Utsunomiya\,\ Tochigi",
"812893", "Utsunomiya\,\ Tochigi",
"8112398", "Kuriyama\,\ Hokkaido",
"817723", "Miyazu\,\ Kyoto",
"812556", "Itoigawa\,\ Niigata",
"815752", "Sekigahara\,\ Gifu",
"817725", "Miyazu\,\ Kyoto",
"817945", "Kakogawa\,\ Hyogo",
"819599", "Oseto\,\ Nagasaki",
"817962", "Toyooka\,\ Hyogo",
"817943", "Kakogawa\,\ Hyogo",
"81923", "Fukuoka\,\ Fukuoka",
"812588", "Nagaoka\,\ Niigata",
"811554", "Obihiro\,\ Hokkaido",
"81249", "Koriyama\,\ Fukushima",
"811367", "Suttsu\,\ Hokkaido",
"817486", "Minakuchi\,\ Shiga",
"812879", "Nasukarasuyama\,\ Tochigi",
"81939", "Kitakyushu\,\ Fukuoka",
"811354", "Yoichi\,\ Hokkaido",
"812388", "Nagai\,\ Yamagata",
"818874", "Aki\,\ Kochi",
"814704", "Tateyama\,\ Chiba",
"811652", "Shibetsu\,\ Hokkaido",
"818954", "Uwajima\,\ Ehime",
"819824", "Nobeoka\,\ Miyazaki",
"8153975", "Hamamatsu\,\ Shizuoka",
"817998", "Tsuna\,\ Hyogo",
"811656", "Bifuka\,\ Hokkaido",
"8186995", "Seto\,\ Okayama",
"819575", "Isahaya\,\ Nagasaki",
"812473", "Ishikawa\,\ Fukushima",
"817482", "Yokaichi\,\ Shiga",
"819573", "Isahaya\,\ Nagasaki",
"812475", "Ishikawa\,\ Fukushima",
"811587", "Nakayubetsu\,\ Hokkaido",
"81878", "Takamatsu\,\ Kagawa",
"818290", "Hiroshima\,\ Hiroshima",
"818675", "Kuse\,\ Okayama",
"814220", "Kokubunji\,\ Tokyo",
"81935", "Kitakyushu\,\ Fukuoka",
"819952", "Okuchi\,\ Kagoshima",
"811394", "Matsumae\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"817466", "Totsukawa\,\ Nara",
"811234", "Chitose\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"819956", "Kajiki\,\ Kagoshima",
"818249", "Higashi\-ku\,\ Hiroshima",
"812244", "Shiroishi\,\ Miyagi",
"812999", "Itako\,\ Ibaraki",
"812837", "Sano\,\ Tochigi",
"81182", "Yokote\,\ Akita",
"81462", "Atsugi\,\ Kanagawa",
"817905", "Fukusaki\,\ Hyogo",
"812853", "Oyama\,\ Tochigi",
"8125481", "Murakami\,\ Niigata",
"812694", "Nakano\,\ Nagano",
"812855", "Oyama\,\ Tochigi",
"817903", "Fukusaki\,\ Hyogo",
"812232", "Iwanuma\,\ Miyagi",
"815584", "Shimoda\,\ Shizuoka",
"8198298", "Hyuga\,\ Miyazaki",
"814297", "Hanno\,\ Saitama",
"812797", "Shibukawa\,\ Gunma",
"818467", "Mima\,\ Tokushima",
"817498", "Nagahama\,\ Shiga",
"8125484", "Murakami\,\ Niigata",
"81738", "Gobo\,\ Wakayama",
"812784", "Numata\,\ Gunma",
"814284", "Tachikawa\,\ Tokyo",
"812236", "Sendai\,\ Miyagi",
"814701", "Kamogawa\,\ Chiba",
"811463", "Urakawa\,\ Hokkaido",
"814700", "Kamogawa\,\ Chiba",
"815995", "Ago\,\ Mie",
"819737", "Kusu\,\ Oita",
"811465", "Shizunai\,\ Hokkaido",
"81585", "Ibigawa\,\ Gifu",
"815993", "Toba\,\ Mie",
"817617", "Kaga\,\ Ishikawa",
"817706", "Obama\,\ Fukui",
"812377", "Sagae\,\ Yamagata",
"811869", "Odate\,\ Akita",
"817702", "Tsuruga\,\ Fukui",
"81260", "Anan\,\ Nagano",
"8166", "Osaka\,\ Osaka",
"812577", "Muika\,\ Niigata",
"817714", "Kameoka\,\ Kyoto",
"815979", "Kumano\,\ Mie",
"819544", "Takeo\,\ Saga",
"811983", "Hanamaki\,\ Iwate",
"81466", "Fujisawa\,\ Kanagawa",
"819665", "Hitoyoshi\,\ Kumamoto",
"818478", "Tojo\,\ Hiroshima",
"819663", "Hitoyoshi\,\ Kumamoto",
"818514", "Ama\,\ Shimane",
"818585", "Kurayoshi\,\ Tottori",
"818583", "Kurayoshi\,\ Tottori",
"818490", "Onomichi\,\ Hiroshima",
"818843", "Anan\,\ Tokushima",
"818385", "Hagi\,\ Yamaguchi",
"818383", "Hagi\,\ Yamaguchi",
"81225", "Ishinomaki\,\ Miyagi",
"81134", "Otaru\,\ Hokkaido",
"811942", "Iwaizumi\,\ Iwate",
"818546", "Kakeya\,\ Shimane",
"812416", "Tajima\,\ Fukushima",
"81977", "Beppu\,\ Oita",
"819685", "Tamana\,\ Kumamoto",
"814775", "Funabashi\,\ Chiba",
"81468", "Yokosuka\,\ Kanagawa",
"81188", "Akita\,\ Akita",
"819683", "Yamaga\,\ Kumamoto",
"812936", "Mito\,\ Ibaraki",
"812678", "Saku\,\ Nagano",
"814281", "Sagamihara\,\ Kanagawa",
"818565", "Masuda\,\ Shimane",
"81253", "Niigata\,\ Niigata",
"812780", "Maebashi\,\ Gunma",
"814280", "Tachikawa\,\ Tokyo",
"818542", "Yasugi\,\ Shimane",
"818563", "Masuda\,\ Shimane",
"811946", "Kuji\,\ Iwate",
"811527", "Bihoro\,\ Hokkaido",
"819977", "Setouchi\,\ Kagoshima",
"818365", "Ube\,\ Yamaguchi",
"812932", "Takahagi\,\ Ibaraki",
"81233", "Shinjo\,\ Yamagata",
"812649", "Nagano\,\ Nagano",
"8125482", "Murakami\,\ Niigata",
"818363", "Ube\,\ Yamaguchi",
"812412", "Kitakata\,\ Fukushima",
"817734", "Fukuchiyama\,\ Kyoto",
"81547", "Shimada\,\ Shizuoka",
"818949", "Uwajima\,\ Ehime",
"818978", "Hakata\,\ Ehime",
"818294", "Hatsukaichi\,\ Hiroshima",
"811378", "Imakane\,\ Hokkaido",
"811549", "Kushiro\,\ Hokkaido",
"811934", "Kamaishi\,\ Iwate",
"815766", "Gero\,\ Gifu",
"812543", "Shibata\,\ Niigata",
"812562", "Sanjo\,\ Niigata",
"815367", "Shitara\,\ Aichi",
"812545", "Murakami\,\ Niigata",
"8112392", "Yubari\,\ Hokkaido",
"812657", "Ina\,\ Nagano",
"817956", "Sanda\,\ Hyogo",
"818669", "Soja\,\ Okayama",
"815743", "Minokamo\,\ Gifu",
"812566", "Sanjo\,\ Niigata",
"811333", "Tobetsu\,\ Hokkaido",
"812489", "Sukagawa\,\ Fukushima",
"8153973", "Hamamatsu\,\ Shizuoka",
"815745", "Minokamo\,\ Gifu",
"815762", "Gero\,\ Gifu",
"817952", "Nishiwaki\,\ Hyogo",
"811533", "Nemuro\,\ Hokkaido",
"817468", "Kamikitayama\,\ Nara",
"8186993", "Bizen\,\ Okayama",
"811535", "Akkeshi\,\ Hokkaido",
"81875", "Kan\'onji\,\ Kagawa",
"811564", "Kamishihoro\,\ Hokkaido",
"81938", "Kitakyushu\,\ Fukuoka",
"817496", "Nagahama\,\ Shiga",
"811364", "Kutchan\,\ Hokkaido",
"811357", "Iwanai\,\ Hokkaido",
"81984", "Kobayashi\,\ Miyazaki",
"812238", "Sendai\,\ Miyagi",
"811756", "Noheji\,\ Aomori",
"811645", "Rumoi\,\ Hokkaido",
"81958", "Nagasaki\,\ Nagasaki",
"818957", "Misho\,\ Ehime",
"817492", "Hikone\,\ Shiga",
"819827", "Takachiho\,\ Miyazaki",
"812571", "Muika\,\ Niigata",
"811752", "Mutsu\,\ Aomori",
"81721", "Tondabayashi\,\ Osaka",
"811584", "Engaru\,\ Hokkaido",
"819943", "Kanoya\,\ Kagoshima",
"817239", "Neyagawa\,\ Osaka",
"819945", "Kanoya\,\ Kagoshima",
"81494", "Chichibu\,\ Saitama",
"811397", "Okushiri\,\ Hokkaido",
"819962", "Satsumasendai\,\ Kagoshima",
"81936", "Kitakyushu\,\ Fukuoka",
"81222", "Sendai\,\ Miyagi",
"817456", "Yamatotakada\,\ Nara",
"819725", "Saiki\,\ Oita",
"81246", "Iwaki\,\ Fukushima",
"819723", "Saiki\,\ Oita",
"81956", "Sasebo\,\ Nagasaki",
"811237", "Kuriyama\,\ Hokkaido",
"819966", "Izumi\,\ Kagoshima",
"812247", "Ogawara\,\ Miyagi",
"812834", "Utsunomiya\,\ Tochigi",
"817968", "Hamasaka\,\ Hyogo",
"817452", "Yamatotakada\,\ Nara",
"817996", "Tsuna\,\ Hyogo",
"812582", "Nagaoka\,\ Niigata",
"812697", "Iiyama\,\ Nagano",
"811658", "Kamikawa\,\ Hokkaido",
"815394", "Hamamatsu\,\ Shizuoka",
"812382", "Yonezawa\,\ Yamagata",
"81298", "Tsuchiura\,\ Ibaraki",
"818689", "Okayama\,\ Okayama",
"819809", "Yaeyama\ District\,\ Okinawa",
"812586", "Nagaoka\,\ Niigata",
"812613", "Omachi\,\ Nagano",
"812794", "Shibukawa\,\ Gunma",
"81582", "Gifu\,\ Gifu",
"818464", "Takehara\,\ Hiroshima",
"81739", "Tanabe\,\ Wakayama",
"817992", "Sumoto\,\ Hyogo",
"8153970", "Hamamatsu\,\ Shizuoka",
"812615", "Omachi\,\ Nagano",
"812386", "Nagai\,\ Yamagata",
"817488", "Minakuchi\,\ Shiga",
"8198292", "Nobeoka\,\ Miyazaki",
"812787", "Numata\,\ Gunma",
"81723", "Sakai\,\ Osaka",
"814287", "Ome\,\ Tokyo",
"81922", "Fukuoka\,\ Fukuoka",
"81946", "Amagi\,\ Fukuoka",
"81565", "Toyota\,\ Aichi",
"818293", "Hatsukaichi\,\ Hiroshima",
"818295", "Hatsukaichi\,\ Hiroshima",
"819558", "Karatsu\,\ Saga",
"817356", "Kushimoto\,\ Wakayama",
"812962", "Shimodate\,\ Ibaraki",
"81236", "Yamagata\,\ Yamagata",
"811933", "Kamaishi\,\ Iwate",
"811935", "Kamaishi\,\ Iwate",
"8153968", "Hamamatsu\,\ Shizuoka",
"817352", "Shingu\,\ Fukuoka",
"81827", "Iwakuni\,\ Yamaguchi",
"818698", "Bizen\,\ Okayama",
"8168", "Osaka\,\ Osaka",
"81280", "Koga\,\ Ibaraki",
"819684", "Yamaga\,\ Kumamoto",
"818666", "Ibara\,\ Okayama",
"817959", "Sanda\,\ Hyogo",
"81998", "Kagoshima\,\ Kagoshima",
"812998", "Itako\,\ Ibaraki",
"812482", "Shirakawa\,\ Fukushima",
"811957", "Iwate\,\ Iwate",
"817475", "Shimonoseki\,\ Yamaguchi",
"818248", "Shobara\,\ Hiroshima",
"81486", "Urawa\,\ Saitama",
"815769", "Shokawa\,\ Gifu",
"81166", "Asahikawa\,\ Hokkaido",
"818364", "Ube\,\ Yamaguchi",
"817733", "Fukuchiyama\,\ Kyoto",
"818662", "Takahashi\,\ Okayama",
"819787", "Kunisaki\,\ Oita",
"811877", "Omagari\,\ Akita",
"817735", "Fukuchiyama\,\ Kyoto",
"818564", "Masuda\,\ Shimane",
"818557", "Kawamoto\,\ Shimane",
"812486", "Sukagawa\,\ Fukushima",
"818686", "Tsuyama\,\ Okayama",
"819664", "Hitoyoshi\,\ Kumamoto",
"81434", "Chiba\,\ Chiba",
"819543", "Takeo\,\ Saga",
"811984", "Hanamaki\,\ Iwate",
"81488", "Urawa\,\ Saitama",
"8125489", "Tsugawa\,\ Niigata",
"812890", "Utsunomiya\,\ Tochigi",
"818384", "Hagi\,\ Yamaguchi",
"81179", "Sannohe\,\ Aomori",
"819802", "Minamidaito\,\ Okinawa",
"812878", "Nasukarasuyama\,\ Tochigi",
"818682", "Tsuyama\,\ Okayama",
"812389", "Yonezawa\,\ Yamagata",
"818584", "Kurayoshi\,\ Tottori",
"818844", "Anan\,\ Tokushima",
"818796", "Tonosho\,\ Kagawa",
"817940", "Kakogawa\,\ Hyogo",
"817368", "Iwade\,\ Wakayama",
"818397", "Ogori\,\ Yamaguchi",
"812589", "Nagaoka\,\ Niigata",
"81948", "Iizuka\,\ Fukuoka",
"819598", "Fukue\,\ Nagasaki",
"81284", "Ashikaga\,\ Tochigi",
"8125487", "Tsugawa\,\ Niigata",
"818832", "Kamojima\,\ Tokushima",
"815994", "Ago\,\ Mie",
"811464", "Shizunai\,\ Hokkaido",
"81569", "Handa\,\ Aichi",
"817713", "Kameoka\,\ Kyoto",
"818836", "Mima\,\ Tokushima",
"817715", "Kameoka\,\ Kyoto",
"81578", "Kamioka\,\ Akita",
"8188098", "Tosashimizu\,\ Kochi",
"817687", "Noto\,\ Ishikawa",
"81183", "Yuzawa\,\ Akita",
"81463", "Hiratsuka\,\ Kanagawa",
"81277", "Kiryu\,\ Gunma",
"8126170", "Omachi\,\ Nagano",
"815395", "Hamamatsu\,\ Shizuoka",
"817672", "Hakui\,\ Ishikawa",
"81427", "Sagamihara\,\ Kanagawa",
"819936", "Kaseda\,\ Kagoshima",
"815393", "Hamamatsu\,\ Shizuoka",
"81144", "Tomakomai\,\ Hokkaido",
"812857", "Mooka\,\ Tochigi",
"819932", "Ibusuki\,\ Kagoshima",
"81933", "Kitakyushu\,\ Fukuoka",
"81557", "Ito\,\ Shizuoka",
"8112399", "Kuriyama\,\ Hokkaido",
"817676", "Nanao\,\ Ishikawa",
"81929", "Fukuoka\,\ Fukuoka",
"818463", "Takehara\,\ Hiroshima",
"815972", "Owase\,\ Mie",
"81537", "Kakegawa\,\ Shizuoka",
"812795", "Shibukawa\,\ Gunma",
"81243", "Nihonmatsu\,\ Fukushima",
"812614", "Omachi\,\ Nagano",
"812793", "Shibukawa\,\ Gunma",
"819724", "Saiki\,\ Oita",
"8153964", "Hamamatsu\,\ Shizuoka",
"811862", "Kazuno\,\ Akita",
"81742", "Nara\,\ Nara",
"814756", "Togane\,\ Chiba",
"811585", "Engaru\,\ Hokkaido",
"818677", "Niimi\,\ Okayama",
"81726", "Ibaraki\,\ Osaka",
"811583", "Monbetsu\,\ Hokkaido",
"819944", "Kanoya\,\ Kagoshima",
"8186552", "Kurashiki\,\ Okayama",
"8199331", "Kagoshima\,\ Kagoshima",
"812748", "Tomioka\,\ Gunma",
"812835", "Sano\,\ Tochigi",
"81886", "Tokushima\,\ Tokushima",
"812833", "Utsunomiya\,\ Tochigi",
"8112397", "Kuriyama\,\ Hokkaido",
"8188096", "Tosashimizu\,\ Kochi",
"814752", "Mobara\,\ Chiba",
"811866", "Takanosu\,\ Akita",
"811365", "Kutchan\,\ Hokkaido",
"815732", "Ena\,\ Gifu",
"8198297", "Hyuga\,\ Miyazaki",
"811363", "Kutchan\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"811644", "Rumoi\,\ Hokkaido",
"811542", "Kushiro\,\ Hokkaido",
"81728", "Neyagawa\,\ Osaka",
"818946", "Uwajima\,\ Ehime",
"811563", "Honbetsu\,\ Hokkaido",
"81172", "Hirosaki\,\ Aomori",
"814792", "Choshi\,\ Chiba",
"819577", "Shimabara\,\ Nagasaki",
"81888", "Kochi\,\ Kochi",
"815736", "Nakatsugawa\,\ Gifu",
"819432", "Yame\,\ Fukuoka",
"812477", "Miharu\,\ Fukushima",
"818942", "Yawatahama\,\ Ehime",
"81834", "Tokuyama\,\ Yamaguchi",
"8153966", "Hamamatsu\,\ Shizuoka",
"811546", "Kushiro\,\ Hokkaido",
"81774", "Uji\,\ Kyoto",
"8126173", "Omachi\,\ Nagano",
"81863", "Tamano\,\ Okayama",
"812939", "Mito\,\ Ibaraki",
"812897", "Kanuma\,\ Tochigi",
"812419", "Tajima\,\ Fukushima",
"818378", "Shimonoseki\,\ Yamaguchi",
"811858", "Noshiro\,\ Akita",
"81792", "Himeji\,\ Hyogo",
"812544", "Shibata\,\ Niigata",
"8198299", "Hyuga\,\ Miyazaki",
"818391", "Ogori\,\ Yamaguchi",
"817947", "Miki\,\ Hyogo",
"811978", "Kitakami\,\ Iwate",
"81925", "Fukuoka\,\ Fukuoka",
"812646", "Nagano\,\ Nagano",
"811534", "Nakashibetsu\,\ Hokkaido",
"811632", "Teshio\,\ Hokkaido",
"815744", "Minokamo\,\ Gifu",
"819940", "Shibushi\,\ Kagoshima",
"81566", "Kariya\,\ Aichi",
"818206", "Yanai\,\ Yamaguchi",
"812876", "Kuroiso\,\ Tochigi",
"818798", "Tonosho\,\ Kagawa",
"81235", "Tsuruoka\,\ Yamagata",
"817366", "Iwade\,\ Wakayama",
"818202", "Yanai\,\ Yamaguchi",
"819808", "Yaeyama\ District\,\ Okinawa",
"818688", "Mimasaka\,\ Okayama",
"812872", "Otawara\,\ Tochigi",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"814777", "Funabashi\,\ Chiba",
"819687", "Tamana\,\ Kumamoto",
"818807", "Sukumo\,\ Kochi",
"817969", "Hamasaka\,\ Hyogo",
"819592", "Oseto\,\ Nagasaki",
"818656", "Kasaoka\,\ Okayama",
"819232", "Maebaru\,\ Fukuoka",
"81471", "Kashiwa\,\ Chiba",
"811954", "Ninohe\,\ Iwate",
"81485", "Kumagaya\,\ Saitama",
"818367", "Ube\,\ Yamaguchi",
"819975", "Naze\,\ Kagoshima",
"819784", "Bungotakada\,\ Oita",
"818652", "Kurashiki\,\ Okayama",
"819596", "Fukue\,\ Nagasaki",
"811874", "Kakunodate\,\ Akita",
"818567", "Tsuwano\,\ Shimane",
"817238", "Neyagawa\,\ Osaka",
"81176", "Towada\,\ Aomori",
"818554", "Hamada\,\ Shimane",
"811523", "Shari\,\ Hokkaido",
"812559", "Yasuzuka\,\ Niigata",
"811525", "Abashiri\,\ Hokkaido",
"819667", "Minamata\,\ Kumamoto",
"81489", "Soka\,\ Saitama",
"812968", "Kasama\,\ Ibaraki",
"811987", "Tono\,\ Iwate",
"819552", "Imari\,\ Saga",
"818696", "Bizen\,\ Okayama",
"818387", "Tamagawa\,\ Yamaguchi",
"812239", "Sendai\,\ Miyagi",
"81583", "Gifu\,\ Gifu",
"818594", "Yonago\,\ Tottori",
"81987", "Nichinan\,\ Miyazaki",
"818587", "Koge\,\ Tottori",
"818692", "Oku\,\ Okayama",
"819556", "Karatsu\,\ Saga",
"81178", "Hachinohe\,\ Aomori",
"8199347", "Kagoshima\,\ Kagoshima",
"81722", "Sakai\,\ Osaka",
"817615", "Komatsu\,\ Ishikawa",
"812992", "Ishioka\,\ Ibaraki",
"81568", "Kasugai\,\ Aichi",
"815984", "Matsusaka\,\ Mie",
"817613", "Komatsu\,\ Ishikawa",
"81259", "Sado\,\ Niigata",
"81473", "Ichikawa\,\ Chiba",
"819735", "Hita\,\ Oita",
"815997", "Ago\,\ Mie",
"818242", "Higashi\-ku\,\ Hiroshima",
"818263", "Kake\,\ Hiroshima",
"81949", "Nogata\,\ Fukuoka",
"812488", "Sukagawa\,\ Fukushima",
"819733", "Hita\,\ Oita",
"811454", "Mukawa\,\ Hokkaido",
"81124", "Ashibetsu\,\ Hokkaido",
"812575", "Tokamachi\,\ Niigata",
"818668", "Ibara\,\ Okayama",
"812996", "Itako\,\ Ibaraki",
"812573", "Kashiwazaki\,\ Niigata",
"81798", "Nishinomiya\,\ Hyogo",
"812375", "Murayama\,\ Yamagata",
"817684", "Wajima\,\ Ishikawa",
"812373", "Murayama\,\ Yamagata",
"818246", "Miyoshi\,\ Hiroshima",
"815583", "Shimoda\,\ Shizuoka",
"815738", "Nakatsugawa\,\ Gifu",
"815585", "Shimoda\,\ Shizuoka",
"812693", "Nakano\,\ Nagano",
"817904", "Fukusaki\,\ Hyogo",
"814770", "Ichikawa\,\ Chiba",
"811548", "Teshikaga\,\ Hokkaido",
"814771", "Ichikawa\,\ Chiba",
"812695", "Nakano\,\ Nagano",
"817912", "Aioi\,\ Hyogo",
"812854", "Oyama\,\ Tochigi",
"819438", "Tanushimaru\,\ Fukuoka",
"812783", "Numata\,\ Gunma",
"814283", "Ome\,\ Tokyo",
"812785", "Numata\,\ Gunma",
"814798", "Yokaichiba\,\ Chiba",
"814285", "Sagamihara\,\ Kanagawa",
"81928", "Fukuoka\,\ Fukuoka",
"818360", "Ogori\,\ Yamaguchi",
"818948", "Uwajima\,\ Ehime",
"811976", "Kitakami\,\ Iwate",
"819727", "Usuki\,\ Oita",
"811233", "Chitose\,\ Hokkaido",
"812648", "Nagano\,\ Nagano",
"811235", "Yubari\,\ Hokkaido",
"81725", "Izumi\,\ Osaka",
"811852", "Oga\,\ Akita",
"811393", "Matsumae\,\ Hokkaido",
"818674", "Kuse\,\ Okayama",
"81544", "Fujinomiya\,\ Shizuoka",
"819947", "Shibushi\,\ Kagoshima",
"812679", "Saku\,\ Nagano",
"818372", "Nagato\,\ Yamaguchi",
"811395", "Esashi\,\ Hokkaido",
"81885", "Komatsushima\,\ Tokushima",
"81992", "Kagoshima\,\ Kagoshima",
"811972", "Mizusawa\,\ Iwate",
"812243", "Shiroishi\,\ Miyagi",
"818376", "Mine\,\ Yamaguchi",
"81157", "Kitami\,\ Hokkaido",
"812245", "Ogawara\,\ Miyagi",
"811856", "Noshiro\,\ Akita",
"818873", "Aki\,\ Kochi",
"814703", "Tateyama\,\ Chiba",
"817678", "Nanao\,\ Ishikawa",
"81729", "Yao\,\ Osaka",
"8126175", "Omachi\,\ Nagano",
"811353", "Yoichi\,\ Hokkaido",
"811647", "Haboro\,\ Hokkaido",
"814705", "Tateyama\,\ Chiba",
"811555", "Obihiro\,\ Hokkaido",
"819676", "Takamori\,\ Kumamoto",
"811553", "Obihiro\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"819574", "Isahaya\,\ Nagasaki",
"819938", "Kaseda\,\ Kagoshima",
"812474", "Ishikawa\,\ Fukushima",
"81162", "Wakkanai\,\ Hokkaido",
"818955", "Uwajima\,\ Ehime",
"819825", "Hyuga\,\ Miyazaki",
"81482", "Kawaguchi\,\ Saitama",
"818953", "Uwajima\,\ Ehime",
"815978", "Kumano\,\ Mie",
"819823", "Nobeoka\,\ Miyazaki",
"812746", "Tomioka\,\ Gunma",
"812655", "Iida\,\ Nagano",
"81572", "Tajimi\,\ Gifu",
"812894", "Utsunomiya\,\ Tochigi",
"812653", "Iida\,\ Nagano",
"815363", "Shinshiro\,\ Aichi",
"81594", "Kuwana\,\ Mie",
"811732", "Goshogawara\,\ Aomori",
"812547", "Murakami\,\ Niigata",
"811868", "Takanosu\,\ Akita",
"81252", "Niigata\,\ Niigata",
"817944", "Kakogawa\,\ Hyogo",
"81764", "Toyama\,\ Toyama",
"81942", "Kurume\,\ Fukuoka",
"818493", "Onomichi\,\ Hiroshima",
"81926", "Fukuoka\,\ Fukuoka",
"812742", "Fujioka\,\ Gunma",
"811537", "Nakashibetsu\,\ Hokkaido",
"811736", "Goshogawara\,\ Aomori",
"814758", "Togane\,\ Chiba",
"811337", "Ishikari\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;