package Module::Build::WikiDoc;
use strict;
use base qw/Module::Build/;
use IO::File;
use File::Spec;

sub ACTION_distmeta {
    my $self = shift;
    $self->depends_on('wikidoc');
    $self->SUPER::ACTION_distmeta;
}

sub ACTION_testpod {
    my $self = shift;
    $self->depends_on('wikidoc');
    $self->SUPER::ACTION_testpod;
}

sub ACTION_test {
    my $self = shift;
    my $missing_pod;
    for my $src ( keys %{ $self->find_pm_files() } ) {
        next unless _has_pod($src);
        (my $tgt = $src) =~ s{\.pm$}{.pod};
        $missing_pod = 1 if ! -e $tgt;
    }
    if ( $missing_pod ) {
        $self->depends_on('wikidoc');
        $self->depends_on('build');
    }
    $self->SUPER::ACTION_test;
}

sub ACTION_wikidoc {
    my $self = shift;
    eval "use Pod::WikiDoc";
    if ( $@ eq '' ) {
        my $parser = Pod::WikiDoc->new({ 
            comment_blocks => 1,
            keywords => { VERSION => $self->dist_version },
        });
        for my $src ( keys %{ $self->find_pm_files() } ) {
            next unless _has_pod( $src ); 
            (my $tgt = $src) =~ s{\.pm$}{.pod};
            $parser->filter( {
                input   => $src,
                output  => $tgt,
            });
            print "Creating $tgt\n";
            $tgt =~ s{\\}{/}g;
            $self->_add_to_manifest( 'MANIFEST', $tgt );
        }
        for my $src ( keys %{ $self->find_script_files() } ) {
            next unless _has_pod( $src ); 
            my $script = IO::File->new($src, "r+");
            my $mark = tell $script;
            my $text = q{};
            while (my $line = <$script>) {
                last if $line =~ m{Generated by Pod::WikiDoc}i;
                $text .= $line;
                $mark = tell $script;
            }
            truncate $script, $mark;
            seek $script, 0, 2; # EOF
            my $pod = $parser->convert( $text );
            print "Updating Pod in $src\n";
            print {$script} $pod;
        }
    }
    else {
        warn "Pod::WikiDoc not available. Skipping wikidoc.\n";
    }
}

sub _has_pod {
    my ($file) = shift;
    warn "Scanning $file...\n";
    my $fh = IO::File->new( $file );
    my $data = do {local $/; <$fh>};
    return $data =~ m{^=(?:pod|head\d|over|item|begin)\b}ms;
}

1;
