#!/usr/bin/perl
use strict;
use Device::I2C;
use IO::Handle;
use Fcntl;

package PCF8574;

our $VERSION = "0.1";

#global vars
my ($i2cbus, $addr, $gpext);
my $gpregval = 0; 	#init gpio register value to 0

my @pin_nums = (1,2,4,8,16,32,64,128); 

sub new{
	my $class = shift;
	my $self = bless {}, $class;

        #first arg is device address
        $addr = $_[0];
 
        #second arg i2c bus; optional
        $i2cbus = $_[1];
         
        if($i2cbus eq ''){
                $i2cbus = '/dev/i2c-1';
        }#end if
         
        $gpext = Device::I2C->new($i2cbus, "r+"); 
 
        #init i2c device
        $gpext->checkDevice($addr);
        $gpext->selectDevice($addr);
 
        #init gp register val to all off
        $gpregval = 255; 

	print "successfully created pcf8574 object....\n";
 
	#set gpext to 0x00
	$gpext->writeByte(0xff); 

        return $self;
}#end new:

sub write_pin{
	my $ind = $_[1];
	my $iox = $pin_nums[$ind];

	#1 or 0
	my $val = $_[2];

	#see current pin states
	my $regval = $gpext->readByte();
	#my $regval = `i2cget -y 1 0x20`;
	#print "regval: $regval\n";
	my $binout = sprintf("%08b", $regval); 
	my @pinvals = split(//, $binout); 
	@pinvals = reverse(@pinvals);
	print "@pinvals \n";
	my $already_high = $pinvals[$ind]; 

        if($val == 1 && $already_high == 0){
                $gpregval+=$iox; 
        }#end if
        if($val == 0 && $already_high == 1){
                $gpregval-=$iox;
        }#end if

	$gpext->writeByte($gpregval); 

}#end write_pin

sub read_pin{
        my $ind = $_[1];
        my $iox = $pin_nums[$ind];
        my $pinval = 0; 
 
        #read GPIO register
        my $regval = $gpext->readByte(); 
 
        #ensure 8 binary places are displayed
        my $binout = sprintf("%08b", $regval);
 
        #parse eight binary digits into an array
        my @pinvals = split(//, $binout);
         
        #reverse array to match pin #'s
        @pinvals = reverse(@pinvals);
	print "@pinvals \n";
 
        #value of pin is index of $pinvals
        $pinval = $pinvals[$ind]; 
 
        return $pinval;
}#end read_pin

1;

__END__

=head1 NAME

PINE64::PCF8574 - Perl interface to the PCF8574 GPIO extender

=head1 SYNOPSIS

	use PINE64::PCF8574; 

	my $gpext = PCF8574->new(0x20); 

	#turn on 8 LEDs in order and then turn them off
	for(my $i=0;$i<8;$i++){
		$gpext->write_pin($i, 0); 
		sleep(1); 
		$gpext->write_pin($i, 1);
	}#end for
	for(my $i=7;$i>=0;$i--){
		$gpext->write_pin($i, 0); 
		sleep(1); 
		$gpext->write_pin($i, 1); 
	}#end for

=head1 METHODS

=head2 write_pin($pin, $value)

Sets GPIO $pin to $value.  

=head2 read_pin($pin)

Returns the value of $pin. 
