// Generated by CoffeeScript 1.12.8

/*
 * 2ndFA Session explorer
 */

(function() {
  var categories, displayError, hiddenAttributes, llapp, max, menu, overScheme, schemes, setMsg;

  setMsg = function(msg, level) {
    $('#msg').html(window.translate(msg));
    $('#color').removeClass('message-positive message-warning alert-success alert-warning');
    $('#color').addClass("message-" + level);
    if (level === 'positive') {
      level = 'success';
    }
    return $('#color').addClass("alert-" + level);
  };

  displayError = function(j, status, err) {
    var res;
    console.log('Error', err);
    res = JSON.parse(j.responseText);
    if (res && res.error) {
      res = res.error.replace(/.* /, '');
      console.log('Returned error', res);
      return setMsg(res, 'warning');
    }
  };

  max = 25;

  schemes = {
    _whatToTrace: [
      function(t, v) {
        return "groupBy=substr(" + t + ",1)";
      }, function(t, v) {
        return t + "=" + v + "*";
      }
    ]
  };

  overScheme = {
    _whatToTrace: function(t, v, level, over) {
      console.log('overSchema => level', level, 'over', over);
      if (level === 1 && v.length > over) {
        return t + "=" + v + "*&groupBy=substr(" + t + "," + (level + over + 1) + ")";
      } else {
        return null;
      }
    }
  };

  hiddenAttributes = '_password';

  categories = {
    dateTitle: ['_utime', '_startTime', '_updateTime'],
    sfaTitle: ['_2fDevices']
  };

  menu = {
    home: []
  };


  /*
   * AngularJS applications
   */

  llapp = angular.module('llngSessionsExplorer', ['ui.tree', 'ui.bootstrap', 'llApp']);

  llapp.controller('SessionsExplorerCtrl', [
    '$scope', '$translator', '$location', '$q', '$http', function($scope, $translator, $location, $q, $http) {
      var autoId, c, pathEvent, sessionType;
      $scope.links = links;
      $scope.menulinks = menulinks;
      $scope.staticPrefix = staticPrefix;
      $scope.scriptname = scriptname;
      $scope.formPrefix = formPrefix;
      $scope.availableLanguages = availableLanguages;
      $scope.waiting = true;
      $scope.showM = false;
      $scope.showT = true;
      $scope.data = [];
      $scope.currentScope = null;
      $scope.currentSession = null;
      $scope.menu = menu;
      $scope.searchString = '';
      $scope.U2FCheck = "1";
      $scope.TOTPCheck = "1";
      $scope.UBKCheck = "1";
      $scope.translateP = $translator.translateP;
      $scope.translate = $translator.translate;
      $scope.translateTitle = function(node) {
        return $translator.translateField(node, 'title');
      };
      sessionType = 'persistent';
      $scope.menuClick = function(button) {
        if (button.popup) {
          window.open(button.popup);
        } else {
          if (!button.action) {
            button.action = button.title;
          }
          switch (typeof button.action) {
            case 'function':
              button.action($scope.currentNode, $scope);
              $scope[button.action]();
              break;
            case 'string':
              $scope[button.action]();
              break;
            default:
              console.log(typeof button.action);
          }
        }
        return $scope.showM = false;
      };
      $scope.search2FA = function(clear) {
        if (clear) {
          $scope.searchString = '';
        }
        $scope.currentSession = null;
        $scope.data = [];
        return $scope.updateTree2('', $scope.data, 0, 0);
      };
      $scope.delete2FA = function(type, epoch) {
        var item;
        item = angular.element(".data-" + epoch);
        item.remove();
        $scope.waiting = true;
        $http['delete'](scriptname + "sfa/" + sessionType + "/" + $scope.currentSession.id + "?type=" + type + "&epoch=" + epoch).then(function(response) {
          return $scope.waiting = false;
        }, function(resp) {
          return $scope.waiting = false;
        });
        return $scope.showT = false;
      };
      $scope.stoggle = function(scope) {
        var node;
        node = scope.$modelValue;
        if (node.nodes.length === 0) {
          $scope.updateTree(node.value, node.nodes, node.level, node.over, node.query, node.count);
        }
        return scope.toggle();
      };
      $scope.displaySession = function(scope) {
        var sessionId, transformSession;
        transformSession = function(session) {
          var _insert, _stToStr, array, arrayDate, attr, attrs, category, epoch, i, id, k, key, len, len1, name, pattern, res, sfDevice, subres, time, title, value;
          _stToStr = function(s) {
            return s;
          };
          _insert = function(re, title) {
            var key, reg, tmp, value;
            tmp = [];
            reg = new RegExp(re);
            for (key in session) {
              value = session[key];
              if (key.match(reg) && value) {
                tmp.push({
                  title: key,
                  value: value
                });
                delete session[key];
              }
            }
            if (tmp.length > 0) {
              return res.push({
                title: title,
                nodes: tmp
              });
            }
          };
          time = session._utime;
          id = session._session_id;
          for (key in session) {
            value = session[key];
            if (!value) {
              delete session[key];
            } else {
              if (typeof session === 'string' && value.match(/; /)) {
                session[key] = value.split('; ');
              }
              if (typeof session[key] !== 'object') {
                if (hiddenAttributes.match(new RegExp('\b' + key + '\b'))) {
                  session[key] = '********';
                } else if (key.match(/^(_utime|_lastAuthnUTime|_lastSeen|notification)$/)) {
                  session[key] = $scope.localeDate(value);
                } else if (key.match(/^(_startTime|_updateTime)$/)) {
                  value = _stToStr(value);
                  pattern = /^(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})$/;
                  arrayDate = value.match(pattern);
                  session[key] = arrayDate[3] + "/" + arrayDate[2] + "/" + arrayDate[1] + " à " + arrayDate[4] + ":" + arrayDate[5] + ":" + arrayDate[6];
                }
              }
            }
          }
          res = [];
          for (category in categories) {
            attrs = categories[category];
            subres = [];
            for (i = 0, len = attrs.length; i < len; i++) {
              attr = attrs[i];
              if (session[attr]) {
                if (session[attr].toString().match(/"type":\s*"(?:TOTP|U2F|UBK)"/)) {
                  subres.push({
                    title: "type",
                    value: "name",
                    epoch: "date"
                  });
                  array = JSON.parse(session[attr]);
                  for (k = 0, len1 = array.length; k < len1; k++) {
                    sfDevice = array[k];
                    for (key in sfDevice) {
                      value = sfDevice[key];
                      if (key === 'type') {
                        title = value;
                      }
                      if (key === 'name') {
                        name = value;
                      }
                      if (key === 'epoch') {
                        epoch = value;
                      }
                    }
                    subres.push({
                      title: title,
                      value: name,
                      epoch: epoch
                    });
                  }
                  delete session[attr];
                } else if (session[attr].toString().match(/\w+/)) {
                  subres.push({
                    title: attr,
                    value: session[attr]
                  });
                  delete session[attr];
                } else {
                  delete session[attr];
                }
              } else {
                delete session[attr];
              }
            }
            if (subres.length > 0) {
              res.push({
                title: "__" + category + "__",
                nodes: subres
              });
            }
          }
          return {
            _utime: time,
            id: id,
            nodes: res
          };
        };
        $scope.currentScope = scope;
        sessionId = scope.$modelValue.session;
        $http.get(scriptname + "sfa/" + sessionType + "/" + sessionId).then(function(response) {
          return $scope.currentSession = transformSession(response.data);
        });
        return $scope.showT = false;
      };
      $scope.localeDate = function(s) {
        var d;
        d = new Date(s * 1000);
        return d.toLocaleString();
      };
      $scope.getLanguage = function(lang) {
        $scope.lang = lang;
        $scope.form = 'white';
        $scope.init();
        return $scope.showM = false;
      };
      pathEvent = function(event, next, current) {
        var n;
        n = next.match(/#!?\/(\w+)/);
        if (n === null || n[1].match(/^(persistent)$/)) {
          $scope.type = '_session_uid';
        }
        return $scope.init();
      };
      $scope.$on('$locationChangeSuccess', pathEvent);
      autoId = 0;
      $scope.updateTree = function(value, node, level, over, currentQuery, count) {
        var query, scheme, tmp;
        $scope.waiting = true;
        scheme = schemes[$scope.type] ? schemes[$scope.type] : schemes._whatToTrace;
        query = scheme[level]($scope.type, value, currentQuery);
        if (count > max && overScheme[$scope.type]) {
          if (tmp = overScheme[$scope.type]($scope.type, value, level, over, currentQuery)) {
            over++;
            query = tmp;
            level = level - 1;
          } else {
            over = 0;
          }
        } else {
          over = 0;
        }
        return $http.get(scriptname + "sfa/" + sessionType + "?" + query + "&U2FCheck=" + $scope.U2FCheck + "&TOTPCheck=" + $scope.TOTPCheck + "&UBKCheck=" + $scope.UBKCheck).then(function(response) {
          var data, i, len, n, ref;
          data = response.data;
          if (data.result) {
            ref = data.values;
            for (i = 0, len = ref.length; i < len; i++) {
              n = ref[i];
              autoId++;
              n.id = "node" + autoId;
              if (level < scheme.length - 1) {
                n.nodes = [];
                n.level = level + 1;
                n.query = query;
                n.over = over;
              }
              node.push(n);
            }
            if (value === '') {
              $scope.total = data.total;
            }
          }
          return $scope.waiting = false;
        }, function(resp) {
          return $scope.waiting = false;
        });
      };
      $scope.updateTree2 = function(value, node, level, over, currentQuery, count) {
        var query, scheme, tmp;
        $scope.waiting = true;
        scheme = schemes[$scope.type] ? schemes[$scope.type] : $scope.type === '_updateTime' ? schemes._startTime : schemes._whatToTrace;
        query = scheme[level]($scope.type, value, currentQuery);
        if (count > max && overScheme[$scope.type]) {
          if (tmp = overScheme[$scope.type]($scope.type, value, level, over, currentQuery)) {
            over++;
            query = tmp;
            level = level - 1;
          } else {
            over = 0;
          }
        } else {
          over = 0;
        }
        return $http.get(scriptname + "sfa/" + sessionType + "?_session_uid=" + $scope.searchString + "*&groupBy=substr(_session_uid," + $scope.searchString.length + ")&U2FCheck=" + $scope.U2FCheck + "&TOTPCheck=" + $scope.TOTPCheck + "&UBKCheck=" + $scope.UBKCheck).then(function(response) {
          var data, i, len, n, ref;
          data = response.data;
          if (data.result) {
            ref = data.values;
            for (i = 0, len = ref.length; i < len; i++) {
              n = ref[i];
              autoId++;
              n.id = "node" + autoId;
              if (level < scheme.length - 1) {
                n.nodes = [];
                n.level = level + 1;
                n.query = query;
                n.over = over;
              }
              node.push(n);
            }
            if (value === '') {
              $scope.total = data.total;
            }
          }
          return $scope.waiting = false;
        }, function(resp) {
          return $scope.waiting = false;
        });
      };
      $scope.init = function() {
        $scope.waiting = true;
        $scope.data = [];
        $q.all([$translator.init($scope.lang), $scope.updateTree('', $scope.data, 0, 0)]).then(function() {
          return $scope.waiting = false;
        }, function(resp) {
          return $scope.waiting = false;
        });
        $scope.activeModule = "2ndFA";
        return $scope.myStyle = {
          color: '#ffb84d'
        };
      };
      c = $location.path().match(/^\/(\w+)/);
      return $scope.type = c ? c[1] : '_whatToTrace';
    }
  ]);

}).call(this);
