/*
 * $Id: /mirror/trunk/compilers/bcg/src/bcg_op.c 23537 2007-12-06T17:01:16.223150Z paultcochrane  $
 * Copyright (C) 2006-2007, The Perl Foundation.
 */

/*

=head1 NAME

bcg_op.c

=head1 DESCRIPTION

RT#48264

=head2 Methods

=over 4

=cut

*/

#include <ctype.h>
#include <string.h>
#include "bcg.h"
#include "bcg_private.h"

/*

=item C<bcg_op_arg *
bcg_op_arg_create(BCG_info * bcg_info, char *name, bcg_op_arg_type type,
                  char data_type)>

RT#48260: Not yet documented!!!

=cut

*/

bcg_op_arg *
bcg_op_arg_create(BCG_info * bcg_info, char *name, bcg_op_arg_type type,
                  char data_type)
{
    bcg_op_arg *op_arg;

    UNUSED(bcg_info);
    op_arg = (bcg_op_arg *) mem_sys_allocate_zeroed(sizeof (bcg_op_arg));
    op_arg->name = name;
    op_arg->is_constant = type;
    op_arg->data_type = data_type;
    op_arg->reg_num = -1;
    return op_arg;
}

/*

=item C<void
bcg_op_arg_destroy(BCG_info * bcg_info, bcg_op_arg * op_arg)>

RT#48260: Not yet documented!!!

=cut

*/

void
bcg_op_arg_destroy(BCG_info * bcg_info, bcg_op_arg * op_arg)
{
    UNUSED(bcg_info);
    mem_sys_free(op_arg->name);
    mem_sys_free(op_arg);
}

/*

=item C<bcg_op *
bcg_op_create(BCG_info * bcg_info, char *name, bcg_op_type op_type)>

RT#48260: Not yet documented!!!

=cut

*/

bcg_op *
bcg_op_create(BCG_info * bcg_info, char *name, bcg_op_type op_type)
{
    bcg_op *op;

    UNUSED(bcg_info);
    op = (bcg_op *) mem_sys_allocate_zeroed(sizeof (bcg_op));
    op->name = name;
    op->op_arg_count = 0;
    op->type = op_type;
    return op;
}

/*

=item C<void
bcg_op_destroy(BCG_info * bcg_info, bcg_op * op)>

RT#48260: Not yet documented!!!

=cut

*/

void
bcg_op_destroy(BCG_info * bcg_info, bcg_op * op)
{
    int i;

    UNUSED(bcg_info);
    mem_sys_free(op->name);
    mem_sys_free(op->full_name);
    for (i = 0; i < (op->op_arg_count); i++) {
        bcg_op_arg_destroy(bcg_info, op->op_args[i]);
    }
    mem_sys_free(op);
}

/*

=item C<void
bcg_op_add_arg(BCG_info * bcg_info, bcg_op * op, bcg_op_arg * op_arg)>

RT#48260: Not yet documented!!!

=cut

*/

void
bcg_op_add_arg(BCG_info * bcg_info, bcg_op * op, bcg_op_arg * op_arg)
{
    /* op->op_args[op->op_arg_count]=op_arg; */
    op->op_arg_count++;

    if (op->op_arg_count == 1) {
        op->op_args =
            (bcg_op_arg **) mem_sys_allocate_zeroed(sizeof (bcg_op_arg *));
    }
    else {
        op->op_args =
            (bcg_op_arg **) mem_sys_realloc(op->op_args,
                                            sizeof (bcg_op_arg *) *
                                            (op->op_arg_count));
    }
    op->op_args[op->op_arg_count - 1] = op_arg;
}

/*

=item C<void
bcg_op_resolve_full_name(BCG_info * bcg_info, bcg_op * op)>

RT#48260: Not yet documented!!!

=cut

*/

void
bcg_op_resolve_full_name(BCG_info * bcg_info, bcg_op * op)
{
    char buffer[16];
    char *buff_ptr, *full_name;
    int len, i;

    buff_ptr = buffer;
    len = sprintf(buff_ptr, "%s", op->name);
    buff_ptr += len;

    for (i = 0; i < op->op_arg_count; i++) {
        len = sprintf(buff_ptr, "_%c", tolower((unsigned char)op->op_args[i]->data_type));
        buff_ptr += len;
        if (op->op_args[i]->is_constant) {
            len = sprintf(buff_ptr, "c");
            buff_ptr += len;
        }
    }

    full_name = (char *)mem_sys_allocate_zeroed(sizeof (char) * strlen(buffer));
    strcpy(full_name, buffer);
    op->full_name = full_name;
}

/*

=item C<bcg_op *
bcg_info_current_op(BCG_info * bcg_info)>

RT#48260: Not yet documented!!!

=cut

*/

bcg_op *
bcg_info_current_op(BCG_info * bcg_info)
{
    bcg_info_private *bcg_info_priv = BCG_INFO_PRIV(bcg_info);
    return bcg_info_priv->last_unit->last_op;
}

/*

=back

=cut

*/

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
