## $Id: Int.pir 29043 2008-07-04 05:33:44Z pmichaud $

=head1 TITLE

Int - Perl 6 integers

=head1 SUBROUTINES

=over 4

=item onload

=cut

.namespace [ 'Int' ]

.sub 'onload' :anon :init :load
    .local pmc p6meta, intproto
    p6meta = get_hll_global ['Perl6Object'], '$!P6META'
    intproto = p6meta.'new_class'('Int', 'parent'=>'Integer Any')
    p6meta.'register'('Integer', 'parent'=>intproto, 'protoobject'=>intproto)

    $P0 = get_hll_namespace ['Int']
    '!EXPORT'('abs', 'from'=>$P0)
.end


=item ACCEPTS()

=cut

.sub 'ACCEPTS' :method
    .param num topic
    .return 'infix:=='(topic, self)
.end


=item perl()

Returns a Perl representation of the Int.

=cut

.sub 'perl' :method
    $S0 = self
    .return($S0)
.end


.sub 'abs' :method :multi('Integer')
    $P0 = n_abs self
    .return ($P0)
.end


=back

=cut

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
