# Safe Perl
use strict;
use autodie;

use Module::Build;


my $builder = Module::Build->new(
    module_name         => 'HPCD-SGE',
    license             => 'perl',
    dist_author         => ['John Macdonald  <John.Macdonald@oicr.on.ca>'],

    dist_version_from   => 'lib/HPCD/SGE.pm',
    dist_abstract       => 'HPCI driver module for SGE compute cluster.',

    # Modules required to build this module
	configure_requires => {
		'Module::Build'        => 0,
		},
	build_requires => {
		'File::ShareDir'       => 0,
		'File::Temp'           => 0,
		'File::pushd'          => 0,
		'FindBin'              => 0,
		'Test::More'           => '0.10',
		'Test::Exception'      => '0',
		'Test::File::Contents' => 0,
		},

    # Modules required to use this module
    requires => {
		'File::Path'                     => 0,
		'DateTime'                       => 0,
        'HPCI'                           => 0,
        'Moose'                          => 0,
        'Moose::Role'                    => 0,
        'Moose::Util::TypeConstraints'   => 0,
        'MooseX::ClassAttribute'         => 0,
        'MooseX::Types::Path::Class'     => 0,
        'namespace::autoclean'           => 0,
    },
);

$builder->create_build_script();
