# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl BGPmon-Client.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More;
BEGIN { use_ok('BGPmon::Client::ParseTable') };
use_ok('BGPmon::Client::ParseTable');
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $xml_string = '<BGP_MESSAGE length="00002117" version="0.4" xmlns="urn:ietf:params:xml:ns:xfb-0.4" type_value="260" type="TABLE"><BGPMON_SEQ id="1339464303" seq_num="1499028916"/><TIME timestamp="1313093281" datetime="2011-08-11T20:08:01Z" precision_time="606"/><PEERING as_num_len="2"><SRC_ADDR><ADDRESS>129.82.138.6</ADDRESS><AFI value="1">IPV4</AFI></SRC_ADDR><SRC_PORT>4321</SRC_PORT><SRC_AS>6447</SRC_AS><DST_ADDR><ADDRESS>195.209.15.251</ADDRESS><AFI value="1">IPV4</AFI></DST_ADDR><DST_PORT>179</DST_PORT><DST_AS>5568</DST_AS><BGPID>0.0.0.0</BGPID></PEERING><ASCII_MSG length="70"><MARKER length="16">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF</MARKER><UPDATE withdrawn_len="0" path_attr_len="39"><WITHDRAWN count="0"/><PATH_ATTRIBUTES count="6"><ATTRIBUTE length="1"><FLAGS transitive="TRUE"/><TYPE value="1">ORIGIN</TYPE><ORIGIN value="0">IGP</ORIGIN></ATTRIBUTE><ATTRIBUTE length="4"><FLAGS transitive="TRUE"/><TYPE value="3">NEXT_HOP</TYPE><NEXT_HOP>195.209.15.251</NEXT_HOP></ATTRIBUTE><ATTRIBUTE length="0"><FLAGS transitive="TRUE"/><TYPE value="6">ATOMIC_AGGREGATE</TYPE><ATOMIC_AGGREGATE/></ATTRIBUTE><ATTRIBUTE length="6"><FLAGS optional="TRUE" transitive="TRUE"/><TYPE value="7">AGGREGATOR</TYPE><AGGREGATOR><AS>3325</AS><ADDR>4.21.192.19</ADDR></AGGREGATOR></ATTRIBUTE><ATTRIBUTE length="4"><FLAGS optional="TRUE" transitive="TRUE"/><TYPE value="8">COMMUNITIES</TYPE><COMMUNITIES><COMMUNITY><AS>5568</AS><VALUE>5049</VALUE></COMMUNITY></COMMUNITIES></ATTRIBUTE><ATTRIBUTE length="6"><FLAGS transitive="TRUE"/><TYPE value="2">AS_PATH</TYPE><AS_PATH><AS_SEG type="AS_SEQUENCE" length="2"><AS>5568</AS><AS>3325</AS></AS_SEG></AS_PATH></ATTRIBUTE></PATH_ATTRIBUTES><NLRI count="2"><PREFIX><ADDRESS>193.232.252.0/23</ADDRESS><AFI value="1">IPV4</AFI><SAFI value="1">UNICAST</SAFI></PREFIX><PREFIX><ADDRESS>194.85.240.0/21</ADDRESS><AFI value="1">IPV4</AFI><SAFI value="1">UNICAST</SAFI></PREFIX></NLRI></UPDATE></ASCII_MSG><OCTET_MSG><OCTETS length="70">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0046020000002740010100400304C3D10FFB400600C007060CFDC255F5C6C0080415C013B9400206020215C00CFD17C1E8FC15C255F0</OCTETS></OCTET_MSG></BGP_MESSAGE>';

my $xml_string2 = '<BGP_MESSAGE length="00001822" version="0.4" xmlns="urn:ietf:params:xml:ns:xfb-0.4" type_value="260" type="TABLE"><BGPMON_SEQ id="1339464303" seq_num="1584045760"/><TIME timestamp="1313175735" datetime="2011-08-12T19:02:15Z" precision_time="163"/><PEERING as_num_len="4"><SRC_ADDR><ADDRESS>2001:468:d01:33::80df:330f</ADDRESS><AFI value="2">IPV6</AFI></SRC_ADDR><SRC_PORT>179</SRC_PORT><SRC_AS>6447</SRC_AS><DST_ADDR><ADDRESS>2001:2000:3018:4d::1</ADDRESS><AFI value="2">IPV6</AFI></DST_ADDR><DST_PORT>179</DST_PORT><DST_AS>1299</DST_AS><BGPID>0.0.0.0</BGPID></PEERING><ASCII_MSG length="90"><MARKER length="16">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF</MARKER><UPDATE withdrawn_len="0" path_attr_len="67"><WITHDRAWN count="0"/><PATH_ATTRIBUTES count="3"><ATTRIBUTE length="1"><FLAGS transitive="TRUE"/><TYPE value="1">ORIGIN</TYPE><ORIGIN value="0">IGP</ORIGIN></ATTRIBUTE><ATTRIBUTE length="14"><FLAGS transitive="TRUE"/><TYPE value="2">AS_PATH</TYPE><AS_PATH><AS_SEG type="AS_SEQUENCE" length="3"><AS>1299</AS><AS>553</AS><AS>57154</AS></AS_SEG></AS_PATH></ATTRIBUTE><ATTRIBUTE length="42"><FLAGS optional="TRUE" extended="TRUE"/><TYPE value="14">MP_REACH_NLRI</TYPE><MP_REACH_NLRI><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI><NEXT_HOP_LEN>32</NEXT_HOP_LEN><NEXT_HOP><ADDRESS>2001:2000:3018:4d::1</ADDRESS><ADDRESS>fe80::2a0:a50f:fc68:e5bb</ADDRESS></NEXT_HOP><NLRI count="1"><PREFIX><ADDRESS>2a03:80::/32</ADDRESS><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI></PREFIX></NLRI></MP_REACH_NLRI></ATTRIBUTE></PATH_ATTRIBUTES><NLRI count="0"/></UPDATE></ASCII_MSG><OCTET_MSG><OCTETS length="90">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF005A02000000434001010040020E020300000513000002290000DF42900E002A00020120200120003018004D0000000000000001FE8000000000000002A0A50FFC68E5BB00202A030080</OCTETS></OCTET_MSG></BGP_MESSAGE><BGP_MESSAGE length="00001876" version="0.4" xmlns="urn:ietf:params:xml:ns:xfb-0.4" type_value="260" type="TABLE"><BGPMON_SEQ id="1339464303" seq_num="1584045761"/><TIME timestamp="1313175735" datetime="2011-08-12T19:02:15Z" precision_time="163"/><PEERING as_num_len="4"><SRC_ADDR><ADDRESS>2001:468:d01:33::80df:330f</ADDRESS><AFI value="2">IPV6</AFI></SRC_ADDR><SRC_PORT>179</SRC_PORT><SRC_AS>6447</SRC_AS><DST_ADDR><ADDRESS>2001:2000:3018:4d::1</ADDRESS><AFI value="2">IPV6</AFI></DST_ADDR><DST_PORT>179</DST_PORT><DST_AS>1299</DST_AS><BGPID>0.0.0.0</BGPID></PEERING><ASCII_MSG length="100"><MARKER length="16">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF</MARKER><UPDATE withdrawn_len="0" path_attr_len="77"><WITHDRAWN count="0"/><PATH_ATTRIBUTES count="3"><ATTRIBUTE length="1"><FLAGS transitive="TRUE"/><TYPE value="1">ORIGIN</TYPE><ORIGIN value="0">IGP</ORIGIN></ATTRIBUTE><ATTRIBUTE length="22"><FLAGS transitive="TRUE"/><TYPE value="2">AS_PATH</TYPE><AS_PATH><AS_SEG type="AS_SEQUENCE" length="5"><AS>1299</AS><AS>3356</AS><AS>9002</AS><AS>35810</AS><AS>47373</AS></AS_SEG></AS_PATH></ATTRIBUTE><ATTRIBUTE length="44"><FLAGS optional="TRUE" extended="TRUE"/><TYPE value="14">MP_REACH_NLRI</TYPE><MP_REACH_NLRI><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI><NEXT_HOP_LEN>32</NEXT_HOP_LEN><NEXT_HOP><ADDRESS>2001:2000:3018:4d::1</ADDRESS><ADDRESS>fe80::2a0:a50f:fc68:e5bb</ADDRESS></NEXT_HOP><NLRI count="1"><PREFIX><ADDRESS>2a00:1468:8::/48</ADDRESS><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI></PREFIX></NLRI></MP_REACH_NLRI></ATTRIBUTE></PATH_ATTRIBUTES><NLRI count="0"/></UPDATE></ASCII_MSG><OCTET_MSG><OCTETS length="100">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0064020000004D4001010040021602050000051300000D1C0000232A00008BE20000B90D900E002C00020120200120003018004D0000000000000001FE8000000000000002A0A50FFC68E5BB00302A0014680008</OCTETS></OCTET_MSG></BGP_MESSAGE><BGP_MESSAGE length="00001852" version="0.4" xmlns="urn:ietf:params:xml:ns:xfb-0.4" type_value="260" type="TABLE"><BGPMON_SEQ id="1339464303" seq_num="1584045762"/><TIME timestamp="1313175735" datetime="2011-08-12T19:02:15Z" precision_time="163"/><PEERING as_num_len="4"><SRC_ADDR><ADDRESS>2001:468:d01:33::80df:330f</ADDRESS><AFI value="2">IPV6</AFI></SRC_ADDR><SRC_PORT>179</SRC_PORT><SRC_AS>6447</SRC_AS><DST_ADDR><ADDRESS>2001:2000:3018:4d::1</ADDRESS><AFI value="2">IPV6</AFI></DST_ADDR><DST_PORT>179</DST_PORT><DST_AS>1299</DST_AS><BGPID>0.0.0.0</BGPID></PEERING><ASCII_MSG length="96"><MARKER length="16">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF</MARKER><UPDATE withdrawn_len="0" path_attr_len="73"><WITHDRAWN count="0"/><PATH_ATTRIBUTES count="3"><ATTRIBUTE length="1"><FLAGS transitive="TRUE"/><TYPE value="1">ORIGIN</TYPE><ORIGIN value="0">IGP</ORIGIN></ATTRIBUTE><ATTRIBUTE length="18"><FLAGS transitive="TRUE"/><TYPE value="2">AS_PATH</TYPE><AS_PATH><AS_SEG type="AS_SEQUENCE" length="4"><AS>1299</AS><AS>6939</AS><AS>9498</AS><AS>55741</AS></AS_SEG></AS_PATH></ATTRIBUTE><ATTRIBUTE length="44"><FLAGS optional="TRUE" extended="TRUE"/><TYPE value="14">MP_REACH_NLRI</TYPE><MP_REACH_NLRI><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI><NEXT_HOP_LEN>32</NEXT_HOP_LEN><NEXT_HOP><ADDRESS>2001:2000:3018:4d::1</ADDRESS><ADDRESS>fe80::2a0:a50f:fc68:e5bb</ADDRESS></NEXT_HOP><NLRI count="1"><PREFIX><ADDRESS>2001:df0:c0::/48</ADDRESS><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI></PREFIX></NLRI></MP_REACH_NLRI></ATTRIBUTE></PATH_ATTRIBUTES><NLRI count="0"/></UPDATE></ASCII_MSG><OCTET_MSG><OCTETS length="96">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF006002000000494001010040021202040000051300001B1B0000251A0000D9BD900E002C00020120200120003018004D0000000000000001FE8000000000000002A0A50FFC68E5BB003020010DF000C0</OCTETS></OCTET_MSG></BGP_MESSAGE><BGP_MESSAGE length="00001847" version="0.4" xmlns="urn:ietf:params:xml:ns:xfb-0.4" type_value="260" type="TABLE"><BGPMON_SEQ id="1339464303" seq_num="1584045763"/><TIME timestamp="1313175735" datetime="2011-08-12T19:02:15Z" precision_time="163"/><PEERING as_num_len="4"><SRC_ADDR><ADDRESS>2001:468:d01:33::80df:330f</ADDRESS><AFI value="2">IPV6</AFI></SRC_ADDR><SRC_PORT>179</SRC_PORT><SRC_AS>6447</SRC_AS><DST_ADDR><ADDRESS>2001:2000:3018:4d::1</ADDRESS><AFI value="2">IPV6</AFI></DST_ADDR><DST_PORT>179</DST_PORT><DST_AS>1299</DST_AS><BGPID>0.0.0.0</BGPID></PEERING><ASCII_MSG length="94"><MARKER length="16">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF</MARKER><UPDATE withdrawn_len="0" path_attr_len="71"><WITHDRAWN count="0"/><PATH_ATTRIBUTES count="3"><ATTRIBUTE length="1"><FLAGS transitive="TRUE"/><TYPE value="1">ORIGIN</TYPE><ORIGIN value="0">IGP</ORIGIN></ATTRIBUTE><ATTRIBUTE length="18"><FLAGS transitive="TRUE"/><TYPE value="2">AS_PATH</TYPE><AS_PATH><AS_SEG type="AS_SEQUENCE" length="4"><AS>1299</AS><AS>3257</AS><AS>39912</AS><AS>56471</AS></AS_SEG></AS_PATH></ATTRIBUTE><ATTRIBUTE length="42"><FLAGS optional="TRUE" extended="TRUE"/><TYPE value="14">MP_REACH_NLRI</TYPE><MP_REACH_NLRI><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI><NEXT_HOP_LEN>32</NEXT_HOP_LEN><NEXT_HOP><ADDRESS>2001:2000:3018:4d::1</ADDRESS><ADDRESS>fe80::2a0:a50f:fc68:e5bb</ADDRESS></NEXT_HOP><NLRI count="1"><PREFIX><ADDRESS>2001:1b98::/32</ADDRESS><AFI value="2">IPV6</AFI><SAFI value="1">UNICAST</SAFI></PREFIX></NLRI></MP_REACH_NLRI></ATTRIBUTE></PATH_ATTRIBUTES><NLRI count="0"/></UPDATE></ASCII_MSG><OCTET_MSG><OCTETS length="94">FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF005E02000000474001010040021202040000051300000CB900009BE80000DC97900E002A00020120200120003018004D0000000000000001FE8000000000000002A0A50FFC68E5BB002020011B98</OCTETS></OCTET_MSG></BGP_MESSAGE>';

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.
my $parser = BGPmon::Client::ParseTable->new();
$parser->output_file("test_file");
ok($parser->summarize_tables(),"Return cleanly on undef");
ok($parser->summarize_tables($xml_string),"Parse the given string");
ok(BGPmon::Client::ParseTable::summarize_tables($parser,$xml_string),"Parse the given string");
#ok(-e "test_file","The test file exists");

done_testing();


