/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.InsecureTrustManager;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.params.HttpParams;

final class HttpWebConnectionInsecureSSL {
    private static final Log LOG = LogFactory.getLog(HttpWebConnectionInsecureSSL.class);

    private HttpWebConnectionInsecureSSL() {
    }

    static void setUseInsecureSSL(WebClient webClient, AbstractHttpClient httpClient, boolean useInsecureSSL, final boolean ssl3Only) throws GeneralSecurityException {
        if (useInsecureSSL) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(HttpWebConnectionInsecureSSL.getKeyManagers(webClient), new TrustManager[]{new InsecureTrustManager()}, null);
            SSLSocketFactory factory = new SSLSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier()){

                public Socket createSocket(HttpParams params) throws IOException {
                    SSLSocket sslSocket = (SSLSocket)super.createSocket(params);
                    if (ssl3Only) {
                        sslSocket.setEnabledProtocols(new String[]{"SSLv3"});
                    }
                    return sslSocket;
                }
            };
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)factory);
            SchemeRegistry schemeRegistry = httpClient.getConnectionManager().getSchemeRegistry();
            schemeRegistry.register(https);
        } else {
            SchemeRegistry schemeRegistry = httpClient.getConnectionManager().getSchemeRegistry();
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)HttpWebConnection.getSSLSocketFactory(webClient)));
        }
    }

    private static KeyManager[] getKeyManagers(WebClient webClient) {
        if (webClient.getSSLClientCertificateUrl() == null) {
            return null;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(webClient.getSSLClientCertificateType());
            String password = webClient.getSSLClientCertificatePassword();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            keyStore.load(webClient.getSSLClientCertificateUrl().openStream(), passwordChars);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, passwordChars);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

