/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URLEncodedUtils;

public class UrlFetchWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(UrlFetchWebConnection.class);
    private static final String[] GAE_URL_HACKS = new String[]{"http://gaeHack_javascript/", "http://gaeHack_data/", "http://gaeHack_about/"};
    private final WebClient webClient_;

    public UrlFetchWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        WebResponse response;
        long startTime = System.currentTimeMillis();
        URL url = webRequest.getUrl();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("about to fetch URL " + url));
        }
        if ((response = this.produceWebResponseForGAEProcolHack(url)) != null) {
            return response;
        }
        try {
            byte[] byteArray;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.webClient_.getTimeout());
            connection.addRequestProperty("User-Agent", this.webClient_.getBrowserVersion().getUserAgent());
            for (Map.Entry<String, String> header : webRequest.getAdditionalHeaders().entrySet()) {
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
            HttpMethod httpMethod = webRequest.getHttpMethod();
            connection.setRequestMethod(httpMethod.name());
            if (HttpMethod.POST == httpMethod || HttpMethod.PUT == httpMethod) {
                connection.setDoOutput(true);
                String charset = webRequest.getCharset();
                connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                OutputStream outputStream = connection.getOutputStream();
                try {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                    outputStream.write(query.getBytes(charset));
                    if (webRequest.getRequestBody() != null) {
                        IOUtils.write((byte[])webRequest.getRequestBody().getBytes(charset), (OutputStream)outputStream);
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            int responseCode = connection.getResponseCode();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("fetched URL " + url));
            }
            ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
            for (Map.Entry<String, List<String>> headerEntry : connection.getHeaderFields().entrySet()) {
                String headerKey = headerEntry.getKey();
                if (headerKey == null) continue;
                StringBuilder sb = new StringBuilder();
                for (String headerValue : headerEntry.getValue()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(headerValue);
                }
                headers.add(new NameValuePair(headerKey, sb.toString()));
            }
            InputStream is = responseCode < 400 ? connection.getInputStream() : connection.getErrorStream();
            try {
                byteArray = IOUtils.toByteArray((InputStream)is);
            }
            finally {
                is.close();
            }
            long duration = System.currentTimeMillis() - startTime;
            WebResponseData responseData = new WebResponseData(byteArray, responseCode, connection.getResponseMessage(), headers);
            return new WebResponse(responseData, webRequest, duration);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while tyring to fetch " + url), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private WebResponse produceWebResponseForGAEProcolHack(URL url) {
        String externalForm = url.toExternalForm();
        for (String pattern : GAE_URL_HACKS) {
            int index = externalForm.indexOf(pattern);
            if (index != 0) continue;
            String contentString = externalForm.substring(pattern.length());
            if (contentString.startsWith("'") && contentString.endsWith("'")) {
                contentString = contentString.substring(1, contentString.length() - 1);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("special handling of URL, returning (" + contentString + ") for URL " + url));
            }
            return new StringWebResponse(contentString, url);
        }
        return null;
    }
}

