/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang.ArrayUtils;

public interface DownloadedContent
extends Serializable {
    public InputStream getInputStream() throws IOException;

    public static class OnFile
    implements DownloadedContent {
        private static final long serialVersionUID = 8385310409274828198L;
        private final File file_;

        public OnFile(File file) {
            this.file_ = file;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            return new FileInputStream(this.file_);
        }
    }

    public static class InMemory
    implements DownloadedContent {
        private static final long serialVersionUID = -3297925685606468344L;
        private final byte[] bytes_;

        public InMemory(byte[] byteArray) {
            this.bytes_ = byteArray == null ? ArrayUtils.EMPTY_BYTE_ARRAY : byteArray;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes_);
        }
    }
}

