/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement
extends DomElement
implements Element {
    private static final long serialVersionUID = -8119109851558707854L;
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    private Map<String, String> namespaces_ = new HashMap<String, String>();
    private Map<String, DomAttr> attributes_;

    protected XmlElement(String namespaceURI, String qualifiedName, Page page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page);
        this.attributes_ = attributes;
        for (DomAttr attr : attributes.values()) {
            attr.setParentNode(this);
        }
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getTagName() {
        if (this.getNamespaceURI() == null) {
            return this.getLocalName();
        }
        return this.getQualifiedName();
    }

    public final String getAttributeValue(String attributeName) {
        DomAttr attr = this.attributes_.get(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    public Map<String, DomAttr> getAttributesMap() {
        return this.attributes_;
    }

    @Override
    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeValue(namespaceURI, qualifiedName, attributeValue);
    }

    public final void setAttributeValue(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public final void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        String value = attributeValue;
        if (this.attributes_ == Collections.EMPTY_MAP) {
            this.attributes_ = XmlElement.createAttributeMap(1);
        }
        DomAttr newAttr = XmlElement.addAttributeToMap((XmlPage)this.getPage(), this.attributes_, namespaceURI, qualifiedName, value);
        if (namespaceURI != null) {
            this.namespaces_.put(namespaceURI, newAttr.getPrefix());
        }
        this.attributes_.put(newAttr.getName(), newAttr);
    }

    @Override
    public final void removeAttribute(String attributeName) {
        this.attributes_.remove(attributeName.toLowerCase());
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(this.getQualifiedName(namespaceURI, localName));
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        String qualifiedName = namespaceURI != null ? ((prefix = this.namespaces_.get(namespaceURI)) != null ? prefix + ':' + localName : localName) : localName;
        return qualifiedName;
    }

    static Map<String, DomAttr> createAttributeMap(int attributeCount) {
        return ListOrderedMap.decorate(new HashMap(attributeCount));
    }

    static DomAttr addAttributeToMap(XmlPage page, Map<String, DomAttr> attributeMap, String namespaceURI, String qualifiedName, String value) {
        DomAttr newAttr = new DomAttr(page, namespaceURI, qualifiedName, value);
        attributeMap.put(qualifiedName, newAttr);
        return newAttr;
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (!hasChildren) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.println(indent + "</" + this.getTagName() + ">");
        }
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (String name : this.attributes_.keySet()) {
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)this.attributes_.get(name).getNodeValue()));
            printWriter.print("\"");
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new com.gargoylesoftware.htmlunit.javascript.NamedNodeMap(this);
    }

    @Override
    public String getAttribute(String name) {
        DomAttr attr = this.attributes_.get(name);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("XmlElement.getAttributeNS is not yet implemented.");
    }

    @Override
    public Attr getAttributeNode(String name) {
        throw new UnsupportedOperationException("XmlElement.getAttributeNode is not yet implemented.");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("XmlElement.getAttributeNodeNS is not yet implemented.");
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        throw new UnsupportedOperationException("XmlElement.getElementsByTagName is not yet implemented.");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespace, String name) {
        throw new UnsupportedOperationException("XmlElement.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("XmlElement.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes_.containsKey(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("XmlElement.hasAttributeNS is not yet implemented.");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) {
        throw new UnsupportedOperationException("XmlElement.removeAttributeNode is not yet implemented.");
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) {
        throw new UnsupportedOperationException("XmlElement.setAttributeNode is not yet implemented.");
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        throw new UnsupportedOperationException("XmlElement.setAttributeNodeNS is not yet implemented.");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedOperationException("XmlElement.setIdAttribute is not yet implemented.");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedOperationException("XmlElement.setIdAttributeNS is not yet implemented.");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        throw new UnsupportedOperationException("XmlElement.setIdAttributeNode is not yet implemented.");
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass()) + "[<" + this.getTagName() + " ...>]";
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes_.isEmpty();
    }
}

