/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.KeyDataPair;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFileInput
extends HtmlInput {
    private static final long serialVersionUID = 7925479292349207154L;
    private String contentType_;
    private byte[] data_;

    HtmlFileInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        this.setAttributeValue("value", "");
        if (page.getWebClient().getBrowserVersion().isIE()) {
            this.setDefaultValue("");
        }
    }

    public final byte[] getData() {
        return this.data_;
    }

    public final void setData(byte[] data) {
        this.data_ = data;
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String value = this.getValueAttribute();
        if (StringUtils.isEmpty((String)value)) {
            return new NameValuePair[]{new KeyDataPair(this.getNameAttribute(), new File(""), null, null)};
        }
        File file = null;
        if (value.startsWith("file:/")) {
            if (value.startsWith("file://") && !value.startsWith("file:///")) {
                value = "file:///" + value.substring(7);
            }
            try {
                file = new File(new URI(value));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(value);
        }
        String contentType = this.contentType_ == null ? this.getPage().getWebClient().guessContentType(file) : this.contentType_;
        String charset = this.getPage().getPageEncoding();
        KeyDataPair keyDataPair = new KeyDataPair(this.getNameAttribute(), file, contentType, charset);
        keyDataPair.setData(this.data_);
        return new NameValuePair[]{keyDataPair};
    }

    @Override
    public void reset() {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, false);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }
}

