package Data::Object::Autobox::Code;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->code(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Code

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Code Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Code;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Code> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(CodeRef $arg1) : CodeObject

Construct a new object.

=over 4

=item new example

  my $code = Data::Object::Autobox::Code->new(sub{1});

=back

=cut
