package Net::OpenVPN::Manager::Plugin;

use Moose::Role;

use constant {
    PLUG_OK    => 0,
    PLUG_NOOP  => 1,
    PLUG_ERROR => 2,
    PLUG_FATAL => 3,
    PLUG_MAX   => 4,
};

use Exporter qw(import);
our @EXPORT = qw(PLUG_OK PLUG_NOOP PLUG_ERROR PLUG_FATAL PLUG_MAX);

has 'manager' => (
    is => 'ro',
    isa => 'Net::OpenVPN::Manager',
    required => 1,
);

has 'order' => (
    is => 'ro',
    default => 50,
);

sub log {
    my $self = shift;
    my $msg = shift;
    my $client = shift;
    $self->manager->log(ref($self).": ".$msg, $client) if defined $msg;
}

1;
