package main;
use Evo -modern;
use Test::More tests => 6;
use Promises6 'deferred';

{

  package ThenableFul;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $f->('value') }

  package ThenableRej;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $r->('reason') }

  package ThenableRF;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $r->('reason'); $f->('value') }

  package ThenableFR;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $f->('value'); $r->('reason') }

  package ThenableRejResult;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $r->((ref $self)->new) }

  package ThenableFulResult;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $f->((ref $self)->new) }
}


my $d = deferred;

$d->promise

  # resolution 3.iii.a multiple calls - others are ignored
  ->then(sub { ThenableFR->new })
  ->then(sub($v) { is $v, 'value' }, sub {fail})
  ->then(sub { ThenableRF->new })
  ->then(sub {fail}, sub($r) { is $r, 'reason' })

  # resolved
  ->then(sub { ThenableFul->new })

  # skip fulfilled
  ->then(undef, sub($v) {fail})

  # fulfilled
  ->then(sub($v) {pass}, sub($v) {fail})

  # do reject
  ->then(sub($v) { ThenableRej->new }, sub($v) {fail})

  # again
  ->then(sub($v) {fail}, sub($v) { ThenableRej->new })

  # again because skipped rej
  ->then(sub($v) {fail},)

  #again
  ->then(sub($v) {fail}, sub($v) {pass})

  # do reject and return result reject
  ->then(sub($v) { ThenableRejResult->new }, sub($v) {fail})

  # result is rejected thenable
  ->then(sub($v) {fail}, sub($v) { pass; $v })

  # so reject
  ->then(sub($v) {fail}, sub($v) {pass});

$d->resolve('S');

done_testing;
