package Promises6::Listener;
use Evo::Base -base;
use Promises6::Util 'PROGRESS';

has [qw(deferred builder)];

# onFulfill, onReject, onProgress
has cbs => sub { [] };

sub get_msg($self, $state, $val) {
  my $deferred = $self->deferred;
  my $cb       = $self->cbs->[$state];

  # then. 1.i, 1.ii
  unless (ref $cb eq 'CODE') {
    $state == PROGRESS
      ? $deferred->notify($val)
      : $deferred->change_state($state, $val);
    return;
  }

  # then 7.ii
  my $err;
CATCH: {
    local $@;
    $val = eval { $cb->($val) };
    $err = $@;
  }
  return $deferred->reject($err) if $err;

  $state == PROGRESS ? $deferred->notify($val) : $deferred->resolve($val);
}

1;

# ABSTRACT: A listener.

__END__

=pod

=encoding UTF-8

=head1 NAME

Promises6::Listener - A listener.

=head1 VERSION

version 0.005

=head1 SYNOPSIS

  use Evo::Base -strict;
  use Promises6::Builder;

  my $bldr     = Promises6::Builder->new();
  my $parent_d = $bldr->deferred;
  my $child_d  = $bldr->deferred;
  my $listener = $bldr->listener(deferred => $child_d);

  $parent_d->subscribe($listener);
  $child_d->promise->then(sub($v) { say "resolved $v" });

  $parent_d->resolve('foo');

=head1 DESCRIPTION

  This module is for internal usage only and should be used directly

=head1 ATTRIBUTES

=head2 cbs, deferred

Internal attributes

=head2 builder

An instance of L<Promises6::Builder>

=head1 METHODS

=head2 get_msg

  Gets a message from the deferred, evaluate one of the L</"cbs"> (CB) and
  initiate the resolution procudure of L</"deferred"> with the result of that
  invocation

  If corresponding CB is not a function, changes a state or notify
  L</"deferred">

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
