#!/usr/bin/perl -w

# Unit testing for PPI, generated by Test::Inline

use strict;
use lib ();
use File::Spec::Functions ':ALL';
BEGIN {
	$| = 1;
	unless ( $ENV{HARNESS_ACTIVE} ) {
		require FindBin;
		$FindBin::Bin = $FindBin::Bin; # Avoid a warning
		chdir catdir( $FindBin::Bin, updir() );
		lib->import(
			catdir('blib', 'arch'),
			catdir('blib', 'lib' ),
			catdir('lib'),
			);
	}
}

# Load the API to test
BEGIN { $PPI::XS_DISABLE = 1 }
use PPI;

# Execute the tests
use Test::More tests => 3;

# =begin testing string 3
{
my $Document = PPI::Document->new( \"print 'foo';" );
isa_ok( $Document, 'PPI::Document' );
my $Single = $Document->find_first('Token::Quote::Single');
isa_ok( $Single, 'PPI::Token::Quote::Single' );
is( $Single->string, 'foo', '->string returns as expected' );
}


1;
