# Generated by default/object.tt
package Paws::Shield::ProtectionLimits;
  use Moose;
  has ProtectedResourceTypeLimits => (is => 'ro', isa => 'ArrayRef[Paws::Shield::Limit]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Shield::ProtectionLimits

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Shield::ProtectionLimits object:

  $service_obj->Method(Att1 => { ProtectedResourceTypeLimits => $value, ..., ProtectedResourceTypeLimits => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Shield::ProtectionLimits object:

  $result = $service_obj->Method(...);
  $result->Att1->ProtectedResourceTypeLimits

=head1 DESCRIPTION

Limits settings on protections for your subscription.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ProtectedResourceTypeLimits => ArrayRef[L<Paws::Shield::Limit>]

The maximum number of resource types that you can specify in a
protection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Shield>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

